/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.digest;

import com.crystaldecisions.celib.exception.SILibException;

public class Digest {
    private static final int m_length = 16;
    private static final char[] m_B2C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private byte[] m_hash = new byte[16];

    public Digest() {
        for (int i = 0; i < 16; ++i) {
            this.m_hash[i] = 0;
        }
    }

    public int getLength() {
        return 16;
    }

    public byte getAt(int i) throws SILibException {
        try {
            return this.m_hash[i];
        }
        catch (Exception e) {
            throw new SILibException(new String[]{"Digest: out of range access."}, e);
        }
    }

    public void setAt(byte[] in, int pos, int len) throws SILibException {
        try {
            for (int i = 0; i < len; ++i) {
                this.m_hash[pos + i] = in[i];
            }
        }
        catch (Exception e) {
            throw new SILibException(new String[]{"Digest: out of range access."}, e);
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int temp = this.m_hash[i] & 0xFF;
            retval.append(m_B2C[temp / 16]);
            retval.append(m_B2C[temp % 16]);
        }
        return retval.toString();
    }

    public int compare(Object o1, Object o2) throws SILibException {
        if (o1 instanceof Digest && o2 instanceof Digest) {
            for (int i = 0; i < 16; ++i) {
                if (((Digest)o1).getAt(i) < ((Digest)o2).getAt(i)) {
                    return -1;
                }
                if (((Digest)o1).getAt(i) <= ((Digest)o2).getAt(i)) continue;
                return 1;
            }
            return 0;
        }
        return ((Comparable)o1).compareTo(o2);
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof Digest) {
                return 0 == this.compare(this, obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

