/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.digest;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.digest.Digest;
import com.crystaldecisions.celib.exception.SILibException;

public class MD5 {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.digest.MD5");
    private static final int BITS_PER_BYTE = 8;
    private static final long A = MD5.unsign(1732584193L);
    private static final long B = MD5.unsign(-271733879L);
    private static final long C = MD5.unsign(-1732584194L);
    private static final long D = MD5.unsign(271733878L);
    private static final long[] T = new long[]{MD5.unsign(-680876936L), MD5.unsign(-389564586L), MD5.unsign(606105819L), MD5.unsign(-1044525330L), MD5.unsign(-176418897L), MD5.unsign(1200080426L), MD5.unsign(-1473231341L), MD5.unsign(-45705983L), MD5.unsign(1770035416L), MD5.unsign(-1958414417L), MD5.unsign(-42063L), MD5.unsign(-1990404162L), MD5.unsign(1804603682L), MD5.unsign(-40341101L), MD5.unsign(-1502002290L), MD5.unsign(1236535329L), MD5.unsign(-165796510L), MD5.unsign(-1069501632L), MD5.unsign(643717713L), MD5.unsign(-373897302L), MD5.unsign(-701558691L), MD5.unsign(38016083L), MD5.unsign(-660478335L), MD5.unsign(-405537848L), MD5.unsign(568446438L), MD5.unsign(-1019803690L), MD5.unsign(-187363961L), MD5.unsign(1163531501L), MD5.unsign(-1444681467L), MD5.unsign(-51403784L), MD5.unsign(1735328473L), MD5.unsign(-1926607734L), MD5.unsign(-378558L), MD5.unsign(-2022574463L), MD5.unsign(1839030562L), MD5.unsign(-35309556L), MD5.unsign(-1530992060L), MD5.unsign(1272893353L), MD5.unsign(-155497632L), MD5.unsign(-1094730640L), MD5.unsign(681279174L), MD5.unsign(-358537222L), MD5.unsign(-722521979L), MD5.unsign(76029189L), MD5.unsign(-640364487L), MD5.unsign(-421815835L), MD5.unsign(530742520L), MD5.unsign(-995338651L), MD5.unsign(-198630844L), MD5.unsign(1126891415L), MD5.unsign(-1416354905L), MD5.unsign(-57434055L), MD5.unsign(1700485571L), MD5.unsign(-1894986606L), MD5.unsign(-1051523L), MD5.unsign(-2054922799L), MD5.unsign(1873313359L), MD5.unsign(-30611744L), MD5.unsign(-1560198380L), MD5.unsign(1309151649L), MD5.unsign(-145523070L), MD5.unsign(-1120210379L), MD5.unsign(718787259L), MD5.unsign(-343485551L)};
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static Digest digest(byte[] in, int nBytes) throws SILibException {
        int AIX_WebLogic_VM_Workaround_int = in.length;
        LOG.assertTrue(nBytes == AIX_WebLogic_VM_Workaround_int, "digest(): nBytes should equal to AIX_WebLogic_VM_Workaround_int");
        long nBits = nBytes * 8;
        long a = A;
        long b = B;
        long c = C;
        long d = D;
        int posPadd = 0;
        for (int nBytesLeft = nBytes; nBytesLeft >= 0; nBytesLeft -= 64) {
            long[] X = new long[16];
            byte[] buffer = new byte[64];
            int posBuff = 0;
            if (nBytesLeft < 64) {
                if (nBytesLeft < 56) {
                    posBuff = MD5.CopyBuffer(buffer, in, posBuff, in.length - nBytesLeft, nBytesLeft);
                    posBuff = MD5.CopyBuffer(buffer, padding, posBuff, posPadd, 64 - nBytesLeft - 8);
                    posBuff = MD5.CopyBuffer(buffer, MD5.LongToFourBytes(nBits & 0xFFFFFFFFFFFFFFFFL), posBuff, 0, 4);
                    posBuff = MD5.CopyBuffer(buffer, MD5.LongToFourBytes(nBits >>> 32 & 0xFFFFFFFFFFFFFFFFL), posBuff, 0, 4);
                } else {
                    posBuff = MD5.CopyBuffer(buffer, in, posBuff, in.length - nBytesLeft, nBytesLeft);
                    posBuff = MD5.CopyBuffer(buffer, padding, posBuff, posPadd, 64 - nBytesLeft);
                    posPadd += 64 - nBytesLeft;
                    nBytesLeft = 64;
                }
            } else {
                MD5.CopyBuffer(buffer, in, posBuff, in.length - nBytesLeft, 64);
            }
            MD5.BytesToLong(buffer, X);
            long aa = a;
            long bb = b;
            long cc = c;
            long dd = d;
            a = MD5.Round1(a, b, c, d, X[0], 7L, T[0]);
            d = MD5.Round1(d, a, b, c, X[1], 12L, T[1]);
            c = MD5.Round1(c, d, a, b, X[2], 17L, T[2]);
            b = MD5.Round1(b, c, d, a, X[3], 22L, T[3]);
            a = MD5.Round1(a, b, c, d, X[4], 7L, T[4]);
            d = MD5.Round1(d, a, b, c, X[5], 12L, T[5]);
            c = MD5.Round1(c, d, a, b, X[6], 17L, T[6]);
            b = MD5.Round1(b, c, d, a, X[7], 22L, T[7]);
            a = MD5.Round1(a, b, c, d, X[8], 7L, T[8]);
            d = MD5.Round1(d, a, b, c, X[9], 12L, T[9]);
            c = MD5.Round1(c, d, a, b, X[10], 17L, T[10]);
            b = MD5.Round1(b, c, d, a, X[11], 22L, T[11]);
            a = MD5.Round1(a, b, c, d, X[12], 7L, T[12]);
            d = MD5.Round1(d, a, b, c, X[13], 12L, T[13]);
            c = MD5.Round1(c, d, a, b, X[14], 17L, T[14]);
            b = MD5.Round1(b, c, d, a, X[15], 22L, T[15]);
            MD5.AIX_WebLogic_VM_Workaround(a);
            MD5.AIX_WebLogic_VM_Workaround(b);
            MD5.AIX_WebLogic_VM_Workaround(c);
            MD5.AIX_WebLogic_VM_Workaround(d);
            a = MD5.Round2(a, b, c, d, X[1], 5L, T[16]);
            d = MD5.Round2(d, a, b, c, X[6], 9L, T[17]);
            c = MD5.Round2(c, d, a, b, X[11], 14L, T[18]);
            b = MD5.Round2(b, c, d, a, X[0], 20L, T[19]);
            a = MD5.Round2(a, b, c, d, X[5], 5L, T[20]);
            d = MD5.Round2(d, a, b, c, X[10], 9L, T[21]);
            c = MD5.Round2(c, d, a, b, X[15], 14L, T[22]);
            b = MD5.Round2(b, c, d, a, X[4], 20L, T[23]);
            a = MD5.Round2(a, b, c, d, X[9], 5L, T[24]);
            d = MD5.Round2(d, a, b, c, X[14], 9L, T[25]);
            c = MD5.Round2(c, d, a, b, X[3], 14L, T[26]);
            b = MD5.Round2(b, c, d, a, X[8], 20L, T[27]);
            a = MD5.Round2(a, b, c, d, X[13], 5L, T[28]);
            d = MD5.Round2(d, a, b, c, X[2], 9L, T[29]);
            c = MD5.Round2(c, d, a, b, X[7], 14L, T[30]);
            b = MD5.Round2(b, c, d, a, X[12], 20L, T[31]);
            MD5.AIX_WebLogic_VM_Workaround(a);
            MD5.AIX_WebLogic_VM_Workaround(b);
            MD5.AIX_WebLogic_VM_Workaround(c);
            MD5.AIX_WebLogic_VM_Workaround(d);
            a = MD5.Round3(a, b, c, d, X[5], 4L, T[32]);
            d = MD5.Round3(d, a, b, c, X[8], 11L, T[33]);
            c = MD5.Round3(c, d, a, b, X[11], 16L, T[34]);
            b = MD5.Round3(b, c, d, a, X[14], 23L, T[35]);
            a = MD5.Round3(a, b, c, d, X[1], 4L, T[36]);
            d = MD5.Round3(d, a, b, c, X[4], 11L, T[37]);
            c = MD5.Round3(c, d, a, b, X[7], 16L, T[38]);
            b = MD5.Round3(b, c, d, a, X[10], 23L, T[39]);
            a = MD5.Round3(a, b, c, d, X[13], 4L, T[40]);
            d = MD5.Round3(d, a, b, c, X[0], 11L, T[41]);
            c = MD5.Round3(c, d, a, b, X[3], 16L, T[42]);
            b = MD5.Round3(b, c, d, a, X[6], 23L, T[43]);
            a = MD5.Round3(a, b, c, d, X[9], 4L, T[44]);
            d = MD5.Round3(d, a, b, c, X[12], 11L, T[45]);
            c = MD5.Round3(c, d, a, b, X[15], 16L, T[46]);
            b = MD5.Round3(b, c, d, a, X[2], 23L, T[47]);
            MD5.AIX_WebLogic_VM_Workaround(a);
            MD5.AIX_WebLogic_VM_Workaround(b);
            MD5.AIX_WebLogic_VM_Workaround(c);
            MD5.AIX_WebLogic_VM_Workaround(d);
            a = MD5.Round4(a, b, c, d, X[0], 6L, T[48]);
            d = MD5.Round4(d, a, b, c, X[7], 10L, T[49]);
            c = MD5.Round4(c, d, a, b, X[14], 15L, T[50]);
            b = MD5.Round4(b, c, d, a, X[5], 21L, T[51]);
            a = MD5.Round4(a, b, c, d, X[12], 6L, T[52]);
            d = MD5.Round4(d, a, b, c, X[3], 10L, T[53]);
            c = MD5.Round4(c, d, a, b, X[10], 15L, T[54]);
            b = MD5.Round4(b, c, d, a, X[1], 21L, T[55]);
            a = MD5.Round4(a, b, c, d, X[8], 6L, T[56]);
            d = MD5.Round4(d, a, b, c, X[15], 10L, T[57]);
            c = MD5.Round4(c, d, a, b, X[6], 15L, T[58]);
            b = MD5.Round4(b, c, d, a, X[13], 21L, T[59]);
            a = MD5.Round4(a, b, c, d, X[4], 6L, T[60]);
            d = MD5.Round4(d, a, b, c, X[11], 10L, T[61]);
            c = MD5.Round4(c, d, a, b, X[2], 15L, T[62]);
            b = MD5.Round4(b, c, d, a, X[9], 21L, T[63]);
            MD5.AIX_WebLogic_VM_Workaround(a);
            MD5.AIX_WebLogic_VM_Workaround(b);
            MD5.AIX_WebLogic_VM_Workaround(c);
            MD5.AIX_WebLogic_VM_Workaround(d);
            a = MD5.uadd(a, aa);
            b = MD5.uadd(b, bb);
            c = MD5.uadd(c, cc);
            d = MD5.uadd(d, dd);
            MD5.AIX_WebLogic_VM_Workaround(a);
            MD5.AIX_WebLogic_VM_Workaround(b);
            MD5.AIX_WebLogic_VM_Workaround(c);
            MD5.AIX_WebLogic_VM_Workaround(d);
        }
        MD5.AIX_WebLogic_VM_Workaround(a);
        MD5.AIX_WebLogic_VM_Workaround(b);
        MD5.AIX_WebLogic_VM_Workaround(c);
        MD5.AIX_WebLogic_VM_Workaround(d);
        Digest hash = new Digest();
        hash.setAt(MD5.LongToFourBytes(a), 0, 4);
        hash.setAt(MD5.LongToFourBytes(b), 4, 4);
        hash.setAt(MD5.LongToFourBytes(c), 8, 4);
        hash.setAt(MD5.LongToFourBytes(d), 12, 4);
        return hash;
    }

    private static void AIX_WebLogic_VM_Workaround(long i) {
        boolean negative = i < 0L;
    }

    private static int CopyBuffer(byte[] to, byte[] from, int toOffset, int fromOffset, int length) throws SILibException {
        try {
            for (int i = 0; i < length; ++i) {
                to[toOffset + i] = from[fromOffset + i];
            }
            return toOffset + length;
        }
        catch (Exception e) {
            throw new SILibException(new String[]{"MD5::CopyBuffer: out of range access."}, e);
        }
    }

    private static long F(long X, long Y, long Z) {
        return MD5.rollOver(MD5.rollOver(X & Y) | MD5.rollOver(MD5.unsign(X ^ 0xFFFFFFFFFFFFFFFFL) & Z));
    }

    private static long G(long X, long Y, long Z) {
        return MD5.rollOver(MD5.rollOver(X & Z) | MD5.rollOver(Y & MD5.unsign(Z ^ 0xFFFFFFFFFFFFFFFFL)));
    }

    private static long H(long X, long Y, long Z) {
        return MD5.rollOver(X ^ MD5.rollOver(Y ^ Z));
    }

    private static long I(long X, long Y, long Z) {
        return MD5.rollOver(Y ^ MD5.rollOver(X | MD5.unsign(Z ^ 0xFFFFFFFFFFFFFFFFL)));
    }

    private static long Round1(long a, long b, long c, long d, long Xk, long s, long Ti) {
        return MD5.uadd(b, MD5.circ_leftshift(MD5.uadd(a, MD5.uadd(MD5.F(b, c, d), Xk, Ti)), s));
    }

    private static long Round2(long a, long b, long c, long d, long Xk, long s, long Ti) {
        return MD5.uadd(b, MD5.circ_leftshift(MD5.uadd(a, MD5.uadd(MD5.G(b, c, d), Xk, Ti)), s));
    }

    private static long Round3(long a, long b, long c, long d, long Xk, long s, long Ti) {
        return MD5.uadd(b, MD5.circ_leftshift(MD5.uadd(a, MD5.uadd(MD5.H(b, c, d), Xk, Ti)), s));
    }

    private static long Round4(long a, long b, long c, long d, long Xk, long s, long Ti) {
        return MD5.uadd(b, MD5.circ_leftshift(MD5.uadd(a, MD5.uadd(MD5.I(b, c, d), Xk, Ti)), s));
    }

    private static long circ_leftshift(long lhs, long rhs) {
        return MD5.rollOver(MD5.unsign(lhs << (int)rhs) | lhs >>> (int)(32L - rhs));
    }

    private static byte[] LongToFourBytes(long a) {
        byte[] out = new byte[]{(byte)(a & 0xFFL), (byte)(a >>> 8 & 0xFFL), (byte)(a >>> 16 & 0xFFL), (byte)(a >>> 24 & 0xFFL)};
        return out;
    }

    private static long FourBytesToLong(byte[] b) throws SILibException {
        try {
            long out = (long)(b[0] & 0xFF) | (long)(b[1] & 0xFF) << 8 | (long)(b[2] & 0xFF) << 16 | (long)(b[3] & 0xFF) << 24;
            return out;
        }
        catch (Exception e) {
            throw new SILibException(new String[]{"MD5::FourBytesToInt: out of range access."}, e);
        }
    }

    private static void BytesToLong(byte[] b, long[] X) throws SILibException {
        try {
            byte[] temp = new byte[4];
            for (int i = 0; i < 16; ++i) {
                MD5.CopyBuffer(temp, b, 0, i * 4, 4);
                X[i] = MD5.FourBytesToLong(temp);
            }
        }
        catch (Exception e) {
            throw new SILibException(new String[]{"MD5::BytesToInt: out of range access."}, e);
        }
    }

    private static long uadd(long a, long b) {
        return MD5.rollOver(a + b);
    }

    private static long uadd(long a, long b, long c) {
        return MD5.uadd(MD5.uadd(a, b), c);
    }

    private static long unsign(long a) {
        return a & 0xFFFFFFFFL;
    }

    private static long rollOver(long a) {
        return a % 0x100000000L;
    }
}

