/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.io;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FileCleaner {
    private static Set m_toBeCleanup = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCleanupTarget(String path) {
        if (path != null) {
            Set set = m_toBeCleanup;
            synchronized (set) {
                m_toBeCleanup.add(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterCleanupTarget(String path) {
        if (path != null) {
            Set set = m_toBeCleanup;
            synchronized (set) {
                m_toBeCleanup.remove(path);
            }
        }
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(new Cleaner()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Set set = m_toBeCleanup;
                synchronized (set) {
                    Iterator iter = m_toBeCleanup.iterator();
                    while (iter.hasNext()) {
                        String path = (String)iter.next();
                        File file = new File(path);
                        try {
                            if (file.isFile()) {
                                file.delete();
                                continue;
                            }
                            if (!file.isDirectory()) continue;
                            Cleaner.deleteAll(file);
                        }
                        catch (Throwable t) {}
                    }
                    m_toBeCleanup.clear();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static void deleteAll(File dir) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.isFile()) {
                        try {
                            file.delete();
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    Cleaner.deleteAll(file);
                }
            }
            dir.delete();
        }
    }
}

