/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.misc;

import java.util.ArrayList;
import java.util.List;

public class StringPatternHelper {
    public static final char NO_ESCAPE_CHAR = '\u0000';
    public static final String EMPTY_ENTRY = "";

    public static List split(String in, String separator, char escapeChar) {
        ArrayList<String> ret = new ArrayList<String>();
        int startIndex = 0;
        int lastIndex = in.length() - 1;
        if (lastIndex < startIndex) {
            ret.add(EMPTY_ENTRY);
        } else {
            while (startIndex <= lastIndex) {
                int nextIndex = StringPatternHelper.findNextUnescaped(in, startIndex, separator, escapeChar);
                if (nextIndex >= 0) {
                    ret.add(in.substring(startIndex, nextIndex));
                    if (nextIndex == lastIndex) {
                        ret.add(EMPTY_ENTRY);
                        break;
                    }
                    startIndex = nextIndex + 1;
                    continue;
                }
                ret.add(in.substring(startIndex));
                break;
            }
        }
        return ret;
    }

    public static String format(String in, char escapechar, char[] searchfor) {
        StringBuffer out = new StringBuffer(in.length());
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == escapechar) {
                out.append(escapechar);
            } else {
                for (int j = 0; j < searchfor.length; ++j) {
                    if (searchfor[j] == escapechar || searchfor[j] != c) continue;
                    out.append(escapechar);
                }
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String unformat(String in, char escapechar) {
        StringBuffer out = new StringBuffer(in.length());
        int lastIndex = in.length() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            char c = in.charAt(i);
            if (c == escapechar && i < lastIndex) {
                c = in.charAt(++i);
            }
            out.append(c);
        }
        return out.toString();
    }

    private static int findNextUnescaped(String in, int startFrom, String substring, char escapeChar) {
        int nextIndex = in.indexOf(substring, startFrom);
        int numEscapeChar = 0;
        for (int i = nextIndex - 1; i >= startFrom && in.charAt(i) == escapeChar; --i) {
            ++numEscapeChar;
        }
        if (0 == numEscapeChar % 2) {
            return nextIndex;
        }
        return StringPatternHelper.findNextUnescaped(in, nextIndex + 1, substring, escapeChar);
    }
}

