/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.crystaldecisions.celib.conversion.BooleanConversion;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.conversion.DoubleConversion;
import com.crystaldecisions.celib.conversion.EncodeUtils;
import com.crystaldecisions.celib.conversion.IntegerConversion;
import com.crystaldecisions.celib.conversion.LongConversion;
import com.crystaldecisions.celib.exception.UnexpectedPropertyValueRuntimeException;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IPropertyChangeListener;
import com.crystaldecisions.celib.properties.PropertyBag;
import java.util.Date;
import java.util.Map;

public class Property
implements IPropertyChangeListener,
Comparable {
    public static final int READ_ONLY = Integer.MIN_VALUE;
    public static final int INDEX = 0x40000000;
    public static final int DIRTY = 0x20000000;
    public static final int DATE_TIME = 0x10000000;
    public static final int BAG = 0x8000000;
    public static final int DELETE = 0x4000000;
    public static final int NO_COPY_NO_COMMIT = 0x2000000;
    public static final int NO_COPY = 0x2000000;
    public static final int HIDDEN = 0x1000000;
    public static final int ENCRYPTED = 0x800000;
    public static final int BINARY = 0x400000;
    public static final int PROP_ID_LIST = 0x200000;
    public static final int WAS_DELETED = 0x100000;
    public static final int NO_COPY_BUT_COMMIT = 524288;
    public static final int ALL = 65536;
    private Integer m_id;
    private int m_flags;
    private Object m_value;
    private int m_type;
    private PropertyBag m_container;

    protected Property() {
    }

    protected Property(Integer id, Object value, int flags, PropertyBag container) {
        this(id, value, flags, 0, container);
        this.setType(value);
    }

    protected Property(Integer id, Object value, int flags, int type, PropertyBag container) {
        this.m_id = id;
        this.m_flags = flags;
        this.m_container = container;
        this.m_value = value;
        if (this.m_value instanceof PropertyBag) {
            PropertyBag propBag = (PropertyBag)this.m_value;
            if (!propBag.hasPropertyChangeListener()) {
                propBag.addPropertyChangeListener(this);
            }
            if (propBag.getStringHandler() == null) {
                propBag.setStringHandler(container.getStringHandler());
            }
        }
        this.m_type = type;
        this.syncFlags();
    }

    public void setFlags(int flags) {
        this.m_flags = flags;
    }

    public void cleanFlag(int flag) {
        this.m_flags &= ~flag;
    }

    public void setFlag(int flag) {
        this.m_flags |= flag;
    }

    protected void notifyPropertyChange() {
        this.m_container.propertyChange(this);
    }

    public boolean getBoolean() {
        Object value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value != null) {
            return BooleanConversion.parseBoolean(value.toString());
        }
        return false;
    }

    public Date getDate() {
        Object value = this.getValue();
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value != null && value.toString().length() > 0) {
            return DateConversion.convertVariantDate(Double.parseDouble(value.toString()), null);
        }
        return null;
    }

    public double getDouble() {
        Object value = this.getValue();
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value != null) {
            return DoubleConversion.parseDouble(value.toString());
        }
        return 0.0;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public int getType() {
        return this.m_type;
    }

    public Integer getID() {
        return this.m_id;
    }

    public int getInt() {
        Object value = this.getValue();
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value != null) {
            Integer integer = IntegerConversion.parseInteger(value.toString());
            if (integer == null) {
                throw new NumberFormatException(value.toString());
            }
            return integer;
        }
        return 0;
    }

    public long getLong() {
        Object value = this.getValue();
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value != null) {
            return LongConversion.parseLong(value.toString());
        }
        return 0L;
    }

    public PropertyBag getPropertyBag() {
        Object value = this.getValue();
        if (value instanceof PropertyBag) {
            return (PropertyBag)value;
        }
        if (this.isDeleted()) {
            return null;
        }
        return this.unpackBag(this.m_value);
    }

    public String getString() {
        Object value = this.getValue();
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public Object getValue() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value != null && this.isContainer() && !(this.m_value instanceof PropertyBag)) {
            this.m_value = this.unpackBag(this.m_value);
        } else if (this.isBinary() && !(this.m_value instanceof byte[])) {
            this.m_value = EncodeUtils.base64Decode((String)this.m_value);
        }
        return this.m_value;
    }

    public boolean isBinary() {
        return (this.getFlags() & 0x400000) != 0;
    }

    public boolean isDeleted() {
        return (this.getFlags() & 0x4000000) != 0 || this.m_value == null;
    }

    public boolean isContainer() {
        return this.m_value != null && (this.getFlags() & 0x8000000) != 0;
    }

    public boolean isDirty() {
        return (this.getFlags() & 0x20000000) != 0;
    }

    public void setValue(Object value) {
        if ((this.m_flags & 0x800000) != 0 && value != null) {
            value = this.m_container.getStringHandler().pack((String)value);
        }
        this.setRawValue(value);
    }

    void setRawValue(Object value) {
        if (value != null) {
            if (this.m_value == null) {
                this.setType(value);
            } else if (!this.m_value.getClass().isInstance(value)) {
                this.setType(value);
            }
        }
        this.m_value = value;
        this.syncFlags();
        this.m_flags |= 0x20000000;
        this.notifyPropertyChange();
    }

    Object getRawValue() {
        return this.m_value;
    }

    public String toString() {
        if (this.m_value == null) {
            return null;
        }
        return this.m_value.toString();
    }

    public void propertyChange(Property changed) {
        this.m_flags |= 0x20000000;
        this.notifyPropertyChange();
    }

    Property copyTo(PropertyBag container) {
        return this.copyTo(container, true);
    }

    Property copyTo(PropertyBag container, boolean performEncrypt) {
        Object value = this.m_value;
        if (value instanceof PropertyBag) {
            PropertyBag bag = container.getFactory().makePropertyBag();
            bag.cloneFromNonValueProperties((PropertyBag)value);
            if (performEncrypt) {
                bag.putAll((Map)((PropertyBag)value));
            } else {
                bag.putAllWithoutEncryption((PropertyBag)value);
            }
            value = bag;
        } else if (value instanceof byte[]) {
            byte[] stream = (byte[])value;
            value = new byte[stream.length];
            System.arraycopy(stream, 0, value, 0, stream.length);
        }
        return container.getFactory().makeProperty(this.m_id, value, this.m_flags | 0x20000000, this.m_type, container);
    }

    void cloneFrom(Property other, boolean performEncryption) {
        this.m_flags = other.m_flags;
        Object value = other.m_value;
        if (value instanceof PropertyBag) {
            PropertyBag bag = this.getContainer().getFactory().makePropertyBag();
            bag.cloneFromNonValueProperties((PropertyBag)value);
            bag.putAll((Map)((PropertyBag)value));
            value = bag;
        } else if (value instanceof byte[]) {
            byte[] stream = (byte[])value;
            value = new byte[stream.length];
            System.arraycopy(stream, 0, value, 0, stream.length);
        }
        if (performEncryption && (this.m_flags & 0x800000) != 0) {
            this.setValue(value);
        } else {
            this.m_value = value;
            this.m_type = other.m_type;
            this.m_flags |= 0x20000000;
            this.notifyPropertyChange();
        }
    }

    protected PropertyBag getContainer() {
        return this.m_container;
    }

    private void syncFlags() {
        if (this.m_value == null) {
            this.m_flags |= 0x4000000;
        } else {
            if (this.m_value instanceof PropertyBag) {
                this.m_flags |= 0x8000000;
            } else if (this.m_value instanceof Date) {
                this.m_flags |= 0x10000000;
            } else if (this.m_value instanceof byte[]) {
                this.m_flags |= 0x400000;
            }
            this.m_flags &= 0xFBFFFFFF;
        }
    }

    private PropertyBag unpackBag(Object value) {
        IBagUnpacker unpacker = this.m_container.getUnpackerFactory().makeUnpacker();
        try {
            unpacker.initialize(value);
        }
        catch (AssertionError e) {
            String name = IDHelper.idToName(this.m_id);
            throw new UnexpectedPropertyValueRuntimeException(name, value);
        }
        PropertyBag bag = this.m_container.getFactory().makePropertyBag();
        bag.unpack(unpacker);
        bag.addPropertyChangeListener(this);
        bag.setStringHandler(this.m_container.getStringHandler());
        return bag;
    }

    public int compareTo(Object o) {
        if (o instanceof Property) {
            Property other = (Property)o;
            if (this == other) {
                return 0;
            }
            if (this.getID().equals(other.getID())) {
                if (this.m_value == null) {
                    if (other.m_value == null) {
                        return 0;
                    }
                    return -1;
                }
                if (other.m_value == null) {
                    return 1;
                }
                if (this.isContainer() || other.isContainer()) {
                    throw new ClassCastException();
                }
                return ((Comparable)this.m_value).compareTo(other.m_value);
            }
            throw new ClassCastException();
        }
        throw new ClassCastException("com.crystaldecisions.celib.properties.Property");
    }

    private void setType(Object value) {
        this.m_type = value instanceof Integer ? 3 : (value instanceof Date ? 7 : (value instanceof Double ? 7 : (value instanceof Boolean ? 8 : (value instanceof String ? 27 : (value instanceof Long ? 23 : (value instanceof byte[] ? 27 : (value instanceof PropertyBag ? 63 : (value instanceof Short ? 2 : 0))))))));
    }
}

