/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.crystaldecisions.celib.conversion.IntegerConversion;

public class URLDecoder {
    public static String decode(String s) {
        return URLDecoder.decode(s, 0, s.length());
    }

    public static String decode(String s, int offset, int end) {
        int nIn = end - offset;
        char[] out = null;
        int beginIndex = offset;
        int nOut = 0;
        for (int i = offset; i < end; ++i) {
            int co;
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    co = 32;
                    if (out != null) break;
                    beginIndex = i;
                    out = new char[nIn];
                    break;
                }
                case '%': {
                    if (out == null) {
                        beginIndex = i;
                        out = new char[nIn];
                    }
                    try {
                        if (s.charAt(i + 1) == 'u') {
                            co = (char)IntegerConversion.parseInt(s, i + 2, i + 6, 16);
                            i += 5;
                            break;
                        }
                        co = (char)IntegerConversion.parseInt(s, i + 1, i + 3, 16);
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                }
                default: {
                    co = c;
                }
            }
            if (out != null) {
                out[nOut] = co;
            }
            ++nOut;
        }
        if (out != null) {
            s.getChars(offset, beginIndex, out, 0);
            return new String(out, 0, nOut);
        }
        return s.substring(offset, end);
    }

    public static String decode(char[] ca, int offset, int end) {
        int nIn = end - offset;
        char[] out = null;
        int beginIndex = offset;
        int nOut = 0;
        for (int i = offset; i < end; ++i) {
            int co;
            int c = ca[i];
            switch (c) {
                case 43: {
                    co = 32;
                    if (out != null) break;
                    beginIndex = i;
                    out = new char[nIn];
                    break;
                }
                case 37: {
                    if (out == null) {
                        beginIndex = i;
                        out = new char[nIn];
                    }
                    try {
                        if (ca[i + 1] == 'u') {
                            co = (char)IntegerConversion.parseInt(ca, i + 2, i + 6, 16);
                            i += 5;
                            break;
                        }
                        co = (char)IntegerConversion.parseInt(ca, i + 1, i + 3, 16);
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                }
                default: {
                    co = c;
                }
            }
            if (out != null) {
                out[nOut] = co;
            }
            ++nOut;
        }
        if (out != null) {
            int cop = offset;
            while (cop < beginIndex) {
                out[cop - offset] = ca[cop++];
            }
            return new String(out, 0, nOut);
        }
        return new String(ca, offset, nIn);
    }
}

