/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.properties;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.conversion.DateConversion;
import com.crystaldecisions.celib.io.URLEncodingWriter;
import com.crystaldecisions.celib.properties.FlagHelper;
import com.crystaldecisions.celib.properties.IBagPacker;
import com.crystaldecisions.celib.properties.IDHelper;
import com.crystaldecisions.celib.properties.IStreamBagPacker;
import com.crystaldecisions.celib.properties.Property;
import com.crystaldecisions.celib.properties.PropertyBag;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;

public class URLPacker
implements IStreamBagPacker {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.properties.URLPacker");
    private char m_delimiter;

    public URLPacker() {
        this.m_delimiter = (char)38;
    }

    public URLPacker(char delimiter) {
        this.m_delimiter = delimiter;
    }

    public IBagPacker getNestedPacker() {
        return this;
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw);
        return sw.toString();
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w) {
        try {
            URLEncodingWriter uw = new URLEncodingWriter(w);
            Iterator iter = properties.allIterator();
            boolean firstOne = true;
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                if (FlagHelper.isPropertyExcluded(includeMask, excludeMask, property.getFlags())) continue;
                if (!firstOne) {
                    w.write(this.m_delimiter);
                } else {
                    firstOne = false;
                }
                w.write(IDHelper.idToName(property.getID()));
                w.write(61);
                if (property.isContainer()) {
                    int nestedExcludeMask;
                    PropertyBag nested = property.getPropertyBag();
                    IBagPacker packer = this.getNestedPacker();
                    int nestedIncludeMask = recursive ? includeMask : 0;
                    int n = nestedExcludeMask = recursive ? excludeMask : 0;
                    if (packer instanceof IStreamBagPacker) {
                        ((IStreamBagPacker)packer).packToStream(nested, nestedIncludeMask, nestedExcludeMask, recursive, uw);
                        continue;
                    }
                    uw.write(packer.packToChar(nested, nestedIncludeMask, nestedExcludeMask, recursive));
                    continue;
                }
                Object value = property.getValue();
                if (value == null) continue;
                if (value instanceof Integer) {
                    w.write(value.toString());
                    continue;
                }
                if (value instanceof Long) {
                    w.write(value.toString());
                    continue;
                }
                if (value instanceof Boolean) {
                    w.write((Boolean)value != false ? 49 : 48);
                    continue;
                }
                if (value instanceof Double) {
                    w.write(value.toString());
                    continue;
                }
                if (value instanceof String) {
                    uw.write((String)value);
                    continue;
                }
                if (!(value instanceof Date)) continue;
                double variantDate = DateConversion.convertToVariantDate((Date)value, null);
                w.write(Double.toString(variantDate));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"packToStream(): this shouldn't happen", (Throwable)e);
        }
    }

    public void packToStream(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, Writer w, int clearMask, int setMask) {
        this.packToStream(properties, includeMask, excludeMask, recursive, w);
    }

    public String pack(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        return this.pack(properties, includeMask, excludeMask, recursive);
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive) {
        CharArrayWriter sw = new CharArrayWriter();
        this.packToStream(properties, includeMask, excludeMask, recursive, sw);
        return sw.toCharArray();
    }

    public char[] packToChar(PropertyBag properties, int includeMask, int excludeMask, boolean recursive, int clearMask, int setMask) {
        return this.packToChar(properties, includeMask, excludeMask, recursive);
    }
}

