/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.registry;

import com.crystaldecisions.celib.holder.IntHolder;
import com.crystaldecisions.celib.registry.Registry;
import com.crystaldecisions.celib.registry.RegistryDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class UnixRegistryDriver
implements RegistryDriver {
    public static final String KEYFILE = ".keyname";
    public static final String REGISTRYFILE = ".registry";
    private boolean m_keyExists = false;
    private ArrayList m_pairCollection = new ArrayList();
    private String m_registryFileName;
    private String m_registryKeyName;
    private String m_regRootLocation = Registry.REGISTRYFILESROOT;

    public void doAppendKey(String subKey) {
        this.m_registryKeyName = this.m_registryKeyName + subKey;
        this.setRegistryFileName();
        this.m_pairCollection.clear();
        this.readRegistryFile();
    }

    public int doCreateRegistryObject(String keyName, String subkey, int key) {
        this.m_registryKeyName = subkey + keyName;
        this.setRegistryFileName();
        return this.readRegistryFile() ? 1 : 0;
    }

    public boolean doDeleteValue(String name) {
        return false;
    }

    public void doDestroy(int type) {
        this.m_pairCollection.clear();
    }

    public void doDestroyValueIterator(int pValue, int type) {
    }

    public int doEnumValues() {
        if (!this.m_keyExists) {
            return 0;
        }
        return 1;
    }

    public String doGetKeyName() {
        return this.m_registryKeyName;
    }

    public boolean doGetType(String arg2, IntHolder arg3) {
        for (int i = 0; i < this.m_pairCollection.size(); ++i) {
            UnixRegistryPair pair = (UnixRegistryPair)this.m_pairCollection.get(i);
            if (pair.getKey().compareTo(arg2) != 0) continue;
            arg3.set(pair.getType());
            return true;
        }
        return false;
    }

    public boolean doKeyExists() {
        return this.m_keyExists;
    }

    public boolean doNextValue(Registry.ValueIterator valueIter) {
        int index = valueIter.getIndex();
        if (++index >= this.m_pairCollection.size()) {
            return false;
        }
        valueIter.setIndex(index);
        return true;
    }

    public String doReadValue(String name) {
        for (int i = 0; i < this.m_pairCollection.size(); ++i) {
            UnixRegistryPair pair = (UnixRegistryPair)this.m_pairCollection.get(i);
            if (pair.getKey().compareTo(name) != 0) continue;
            return pair.getValue();
        }
        return "";
    }

    public String doReadValue(String name, int defaultValue) {
        return this.doReadValue(name);
    }

    public String doReadValue(String name, String defaultValue) {
        return this.doReadValue(name);
    }

    public void doSetSubSubKey(String subSubKey) {
    }

    public boolean doValueEmpty(Registry.ValueIterator valueIter) {
        return valueIter.getIndex() >= this.m_pairCollection.size();
    }

    public String doValueGetName(Registry.ValueIterator valueIter) {
        if (this.doValueEmpty(valueIter)) {
            return "";
        }
        UnixRegistryPair pair = (UnixRegistryPair)this.m_pairCollection.get(valueIter.getIndex());
        return pair.getKey();
    }

    public String doValueGetValue(Registry.ValueIterator valueIter) {
        if (this.doValueEmpty(valueIter)) {
            return "";
        }
        UnixRegistryPair pair = (UnixRegistryPair)this.m_pairCollection.get(valueIter.getIndex());
        return pair.getValue();
    }

    public boolean doWriteValue(String name, int value) {
        return false;
    }

    public boolean doWriteValue(String name, String value) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readRegistryFile() {
        String myline;
        File m_file = new File(this.m_registryFileName);
        if (!m_file.exists() || !m_file.isFile()) return false;
        BufferedReader br = null;
        br = new BufferedReader(new FileReader(m_file));
        while ((myline = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(myline, "=");
            if (st.countTokens() < 2) continue;
            String tempName = st.nextToken();
            tempName = tempName.substring(1, tempName.length() - 1);
            String tempValue = st.nextToken();
            UnixRegistryPair newPair = null;
            if (tempValue.charAt(0) == '\"') {
                newPair = new UnixRegistryPair(tempName, tempValue.substring(1, tempValue.length() - 1), 1);
            } else if (tempValue.startsWith("dword:")) {
                tempValue = tempValue.substring(6, tempValue.length());
                try {
                    tempValue = Integer.toString(Integer.parseInt(tempValue, 16));
                    newPair = new UnixRegistryPair(tempName, tempValue, 4);
                }
                catch (NumberFormatException e) {}
            } else if (tempValue.startsWith("dword10:")) {
                newPair = new UnixRegistryPair(tempName, tempValue.substring(8, tempValue.length()), 4);
            }
            if (newPair == null) continue;
            this.m_pairCollection.add(newPair);
        }
        this.m_keyExists = true;
        Object var10_11 = null;
        if (br == null) return true;
        try {
            br.close();
            return true;
        }
        catch (IOException e) {}
        return true;
        {
            catch (IOException ioe) {
                System.out.println("IO Error:" + ioe);
                boolean bl = false;
                Object var10_12 = null;
                if (br == null) return bl;
                try {
                    br.close();
                    return bl;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void setRegistryFileName() {
        this.m_registryFileName = this.m_regRootLocation;
        String tempKey = this.m_registryKeyName.toLowerCase();
        int index = tempKey.indexOf(47);
        if (index >= 0) {
            if (index == 0) {
                this.m_registryFileName = this.m_registryFileName + '\\';
            }
            boolean endWithSlash = tempKey.lastIndexOf(47) == tempKey.length() - 1;
            StringTokenizer st = new StringTokenizer(tempKey, "/");
            if (st.hasMoreTokens()) {
                this.m_registryFileName = this.m_registryFileName + st.nextToken().replace('\\', '/');
            }
            while (st.hasMoreTokens()) {
                this.m_registryFileName = this.m_registryFileName + '\\' + st.nextToken().replace('\\', '/');
            }
            if (endWithSlash) {
                this.m_registryFileName = this.m_registryFileName + '\\';
            }
        } else {
            this.m_registryFileName = this.m_registryFileName + tempKey.replace('\\', '/');
        }
        this.m_registryFileName = !this.m_registryFileName.endsWith("/") ? this.m_registryFileName + "/.registry" : this.m_registryFileName + REGISTRYFILE;
    }

    private class UnixRegistryPair
    extends Registry.Pair {
        private int m_type;

        UnixRegistryPair(String key, String value, int type) {
            super(key, value);
            this.m_type = type;
        }

        public int getType() {
            return this.m_type;
        }
    }
}

