/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.rexec;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class RExecClient {
    private static final int REXEC_PORT = 512;
    private static final byte NULL = 0;
    private boolean m_connected;
    private Socket m_errSocket;
    private Socket m_conn;
    private InputStream m_in;
    private InputStream m_errInput;
    private OutputStream m_errOutput;
    private final String m_host;
    private final String m_username;
    private final String m_password;
    private final String m_cmd;
    private final boolean m_useErr;
    private byte[] m_error;
    private int m_timeout = 0;

    public RExecClient(String host, String username, String password, String cmd, boolean useErr, int timeout) {
        this.m_host = host;
        this.m_username = username;
        this.m_password = password;
        this.m_cmd = cmd;
        this.m_useErr = useErr;
        this.m_connected = false;
        this.m_timeout = timeout;
    }

    public RExecClient(String host, String username, String password, String cmd) {
        this.m_host = host;
        this.m_username = username;
        this.m_password = password;
        this.m_cmd = cmd;
        this.m_useErr = true;
        this.m_connected = false;
    }

    public RExecClient(String host, String username, String password, String cmd, int timeout) {
        this.m_host = host;
        this.m_username = username;
        this.m_password = password;
        this.m_cmd = cmd;
        this.m_useErr = true;
        this.m_connected = false;
        this.m_timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exec() throws IOException {
        try {
            this.write();
            byte[] byArray = this.readOutput();
            return byArray;
        }
        finally {
            this.close();
        }
    }

    public byte[] getError() {
        return this.m_error;
    }

    public String getErrorMessage() {
        return new String(this.m_error);
    }

    private InputStream getInputStream() {
        return this.m_in;
    }

    private InputStream getErrorInputStream() {
        return this.m_errInput;
    }

    private OutputStream getErrorOutputStream() {
        return this.m_errOutput;
    }

    private byte[] read(InputStream in) throws IOException {
        BufferedInputStream bf = new BufferedInputStream(in, 1024);
        ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int len = bf.read(buffer);
        while (len != -1) {
            bao.write(buffer, 0, len);
            len = bf.read(buffer);
        }
        return bao.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws IOException {
        this.m_conn = new Socket(this.m_host, 512);
        this.m_conn.setSoTimeout(this.m_timeout);
        OutputStream out = this.m_conn.getOutputStream();
        this.m_in = this.m_conn.getInputStream();
        if (this.m_useErr) {
            ServerSocket errServerSocket = new ServerSocket(0);
            try {
                errServerSocket.setSoTimeout(this.m_timeout);
                String errPort = Integer.toString(errServerSocket.getLocalPort());
                out.write(errPort.getBytes());
                out.write(0);
                out.flush();
                this.m_errSocket = errServerSocket.accept();
                this.m_errSocket.setSoTimeout(this.m_timeout);
                this.m_errInput = this.m_errSocket.getInputStream();
                this.m_errOutput = this.m_errSocket.getOutputStream();
            }
            finally {
                errServerSocket.close();
            }
        } else {
            out.write(0);
        }
        out.write(this.m_username.getBytes());
        out.write(0);
        out.write(this.m_password.getBytes());
        out.write(0);
        out.write(this.m_cmd.getBytes());
        out.write(0);
        out.flush();
    }

    private byte[] readOutput() throws IOException {
        byte[] output = null;
        int ch = this.m_in.read();
        if (ch != 0) {
            this.m_error = this.read(this.m_in);
            throw new IOException(new String(this.m_error));
        }
        output = this.read(this.m_in);
        return output;
    }

    private void close() {
        if (this.m_conn != null) {
            try {
                this.m_in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.m_conn.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.m_in = null;
            this.m_conn = null;
        }
        if (this.m_errSocket != null) {
            try {
                this.m_errInput.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.m_errOutput.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.m_errSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_errOutput = null;
            this.m_errInput = null;
            this.m_errSocket = null;
        }
    }
}

