/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.stringhandler;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.stringhandler.Crypto3DES;
import com.crystaldecisions.celib.stringhandler.CryptoDES40;
import com.crystaldecisions.celib.stringhandler.CryptoSystem;
import com.crystaldecisions.celib.stringhandler.CryptoXOR;

public final class CryptoFactory {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.stringhandler.CryptoFactory");
    private static CryptoSystem s_crypt3DES;
    private static CryptoSystem s_cryptDES40;
    private static CryptoSystem s_cryptXOR;
    private static boolean s_initialized;
    private static Object s_lock;

    private static void init() {
        try {
            s_crypt3DES = new Crypto3DES();
        }
        catch (Throwable t) {
            LOG.warn((Object)"init(): couldn't load 3DES", t);
        }
        try {
            s_cryptDES40 = new CryptoDES40();
        }
        catch (Throwable t) {
            LOG.warn((Object)"init(): couldn't load DES40", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoSystem getCrypto(String system) {
        Object object = s_lock;
        synchronized (object) {
            if (!s_initialized) {
                CryptoFactory.init();
                s_initialized = true;
            }
        }
        if ("3DES".equalsIgnoreCase(system)) {
            return s_crypt3DES;
        }
        if ("DES40".equalsIgnoreCase(system)) {
            return s_cryptDES40;
        }
        if ("XOR".equalsIgnoreCase(system)) {
            return s_cryptXOR;
        }
        return null;
    }

    public static CryptoSystem getCrypto() {
        return s_cryptXOR;
    }

    static {
        s_cryptXOR = new CryptoXOR();
        s_initialized = false;
        s_lock = new Object();
    }
}

