/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.stringhandler;

import com.crystaldecisions.celib.stringhandler.CryptoSystem;
import com.crystaldecisions.celib.stringhandler.StringHandlerException;

public final class CryptoXOR
implements CryptoSystem {
    public void encrypt(byte[] cleartext, byte[] cyphertext, byte[] key) throws StringHandlerException {
        if (cleartext.length != cyphertext.length) {
            throw new StringHandlerException.OutputTooSmall(cleartext.length);
        }
        int length = cleartext.length;
        int kindex = 0;
        for (int index = 0; index < length; ++index) {
            cyphertext[index] = (byte)(cleartext[index] ^ key[kindex]);
            kindex = (kindex + 1) % key.length;
        }
    }

    public int getBlockSize() {
        return 8;
    }

    public void decrypt(byte[] i_key, byte[] i_cyphertext, int i_cypheroffset, long i_IV, byte[] o_cleartext, int i_clearoffset) throws StringHandlerException {
        this.encrypt(i_key, i_cyphertext, i_cypheroffset, i_IV, o_cleartext, i_clearoffset);
    }

    public void encrypt(byte[] i_key, byte[] i_cleartext, int i_clearoffset, long i_IV, byte[] o_cyphertext, int i_cypheroffset) throws StringHandlerException {
        if (o_cyphertext.length - i_cypheroffset < i_cleartext.length - i_clearoffset) {
            throw new StringHandlerException.OutputTooSmall(i_cleartext.length - i_clearoffset);
        }
        int length = i_cleartext.length - i_clearoffset;
        int kindex = 0;
        for (int index = 0; index < length; ++index) {
            byte cypher;
            byte clear = i_cleartext[index + i_clearoffset];
            o_cyphertext[index + i_cypheroffset] = cypher = (byte)(clear ^ i_key[kindex]);
            kindex = (kindex + 1) % i_key.length;
        }
    }

    public int getKeySize() {
        return 8;
    }
}

