/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.stringhandler;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.celib.stringhandler.CryptoUtil;
import com.crystaldecisions.celib.stringhandler.StringHandler;
import java.io.UnsupportedEncodingException;

public class SIStringHandler
implements StringHandler {
    private static final ILogger LOG = LoggerManager.getLogger((String)"com.crystaldecisions.celib.stringhandler.SIStringHandler");

    public String unpack(String enc) {
        return this.unpackHelper(enc);
    }

    private String unpackHelper(String enc) {
        if (enc.startsWith("z")) {
            String newPW = SIStringHandler.asciiToBin(enc.substring(1));
            return SIStringHandler.parseToken(newPW);
        }
        return SIStringHandler.parseToken(enc);
    }

    public String pack(String unenc) {
        return this.packHelper(unenc);
    }

    private String packHelper(String unenc) {
        String bin = SIStringHandler.generateToken(unenc);
        String ascii = "z" + SIStringHandler.binToAscii(bin);
        return ascii;
    }

    private static String parseToken(String enc) {
        try {
            char[] chars = enc.toCharArray();
            byte[] ret = new byte[chars.length];
            short[] c = SIStringHandler.dummy();
            for (int index = 0; index < ret.length; ++index) {
                int newindex;
                for (newindex = (index + 1) % 43 + 19 * (index / 43) + 10; newindex < 0; newindex += 128) {
                }
                short key = c[(newindex % 128 + 32) % 128];
                int pswdchar = ~(~key ^ chars[index]);
                ret[index] = (byte)pswdchar;
            }
            return new String(ret, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"parseToken(): UTF8 not supported", (Throwable)e);
            return "";
        }
    }

    private static String generateToken(String unenc) {
        try {
            byte[] utf = unenc.getBytes("UTF8");
            char[] ret = new char[utf.length];
            short[] c = SIStringHandler.dummy();
            for (int index = 0; index < ret.length; ++index) {
                int newindex;
                for (newindex = (index + 1) % 43 + 19 * (index / 43) + 10; newindex < 0; newindex += 128) {
                }
                short key = c[(newindex % 128 + 32) % 128];
                int pswdchar = ~utf[index];
                ret[index] = (char)(pswdchar ^= ~key);
            }
            return new String(ret);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"generateToken(): UTF8 not supported", (Throwable)e);
            return "";
        }
    }

    private static short[] dummy() {
        short[] dummyData = new short[]{84, 241, 152, 115, 46, 134, 52, 36, 198, 148, 82, 39, 166, 91, 97, 139, 211, 167, 242, 231, 107, 235, 141, 233, 112, 217, 13, 17, 62, 144, 169, 226, 127, 205, 56, 175, 246, 72, 145, 38, 229, 202, 69, 52, 191, 199, 252, 94, 52, 36, 198, 38, 229, 202, 13, 17, 62, 233, 198, 148, 91, 199, 233, 89, 134, 130, 4, 247, 211, 86, 244, 58, 100, 175, 211, 47, 182, 195, 170, 182, 120, 77, 58, 15, 131, 247, 106, 104, 139, 91, 211, 42, 58, 211, 77, 137, 95, 158, 233, 239, 143, 127, 212, 221, 218, 173, 66, 141, 97, 144, 139, 100, 252, 1, 2, 48, 49, 50, 233, 131, 236, 86, 236, 91, 95, 19, 233, 141};
        return dummyData;
    }

    private static String asciiToBin(String ascii) {
        char[] in = ascii.toCharArray();
        int iIn = 0;
        char[] temp = new char[3];
        if (!CryptoUtil.isAscii4(in, iIn)) {
            return null;
        }
        CryptoUtil.unpack3(in, iIn, temp, 0);
        iIn += 4;
        int cbMessage = temp[0] << 16 | temp[1] << 8 | temp[2];
        if (in.length != CryptoUtil.lengthInAscii(cbMessage)) {
            return null;
        }
        char[] out = new char[cbMessage + 3];
        int iOut = 0;
        while (iIn < in.length) {
            if (!CryptoUtil.isAscii4(in, iIn)) {
                return null;
            }
            CryptoUtil.unpack3(in, iIn, out, iOut);
            iIn += 4;
            iOut += 3;
        }
        return new String(out).substring(0, cbMessage);
    }

    private static String binToAscii(String bin) {
        char[] in = bin.toCharArray();
        char[] out = new char[CryptoUtil.lengthInAscii(in.length)];
        char[] temp = new char[]{(char)((in.length & 0xFF0000) >> 16), (char)((in.length & 0xFF00) >> 8), (char)(in.length & 0xFF)};
        CryptoUtil.pack4(temp, 0, out, 0);
        int indexIn = 0;
        int indexOut = 4;
        while (indexIn < in.length) {
            temp[1] = '\u0000';
            temp[2] = '\u0000';
            System.arraycopy(in, indexIn, temp, 0, Math.min(3, in.length - indexIn));
            CryptoUtil.pack4(temp, 0, out, indexOut);
            indexIn += 3;
            indexOut += 4;
        }
        return new String(out);
    }
}

