/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.synchronization;

import com.crystaldecisions.celib.synchronization.IRWLock;
import com.crystaldecisions.celib.synchronization.SynchronizationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RWLock
implements IRWLock {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private WaitingQueue _writers = new WaitingQueue();
    private WaitingQueue _readers = new WaitingQueue();
    private long _lastIndex = -9223372036854775807L;
    private static ThreadLocal s_elements = new ThreadLocal();

    public boolean forReading() throws SynchronizationException {
        return this.forReading(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forReading(int waitTime) throws SynchronizationException {
        if (waitTime < -1) {
            throw new SynchronizationException.InvalidWaitTime(waitTime);
        }
        WaitingQueueElement element = null;
        HashMap<RWLock, WaitingQueueElement> elements = (HashMap<RWLock, WaitingQueueElement>)s_elements.get();
        if (elements != null) {
            element = (WaitingQueueElement)elements.get(this);
        }
        if (element != null && element._lockCount > 0) {
            ++element._lockCount;
            return true;
        }
        RWLock rWLock = this;
        synchronized (rWLock) {
            if (element == null) {
                if (elements == null) {
                    elements = new HashMap<RWLock, WaitingQueueElement>();
                    s_elements.set(elements);
                }
                element = new WaitingQueueElement(1, this._lastIndex++);
                elements.put(this, element);
                this._readers.addTail(element);
            }
            long index = element._index;
            long startTime = System.currentTimeMillis();
            do {
                long nextWriter = Long.MIN_VALUE;
                WaitingQueueElement nextWriterElement = this._writers.head();
                if (nextWriterElement != null) {
                    nextWriter = nextWriterElement._index;
                }
                if (nextWriter == Long.MIN_VALUE || nextWriter > index) {
                    ++element._lockCount;
                    element._granted = true;
                    return true;
                }
                if (waitTime == 0) {
                    elements.remove(this);
                    this._readers.removeTail();
                    return false;
                }
                try {
                    if (waitTime == -1) {
                        this.wait();
                        continue;
                    }
                    long delta = Math.abs(System.currentTimeMillis() - startTime);
                    this.wait((long)waitTime - delta);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (waitTime == -1 || startTime + (long)waitTime > System.currentTimeMillis());
            elements.remove(this);
            this._readers.remove(element);
            this.notifyAll();
            return false;
        }
    }

    public boolean forWriting() throws SynchronizationException {
        return this.forWriting(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forWriting(int waitTime) throws SynchronizationException {
        if (waitTime < -1) {
            throw new SynchronizationException.InvalidWaitTime(waitTime);
        }
        WaitingQueueElement element = null;
        HashMap<RWLock, WaitingQueueElement> elements = (HashMap<RWLock, WaitingQueueElement>)s_elements.get();
        if (elements != null) {
            element = (WaitingQueueElement)elements.get(this);
        }
        if (element != null && element._granted) {
            if (element._lockType == 1) {
                throw new SynchronizationException.UpgradeNotAllowed();
            }
            ++element._lockCount;
            return true;
        }
        RWLock rWLock = this;
        synchronized (rWLock) {
            if (element == null) {
                if (elements == null) {
                    elements = new HashMap<RWLock, WaitingQueueElement>();
                    s_elements.set(elements);
                }
                element = new WaitingQueueElement(2, this._lastIndex++);
                elements.put(this, element);
                this._writers.addTail(element);
            }
            long index = element._index;
            long startTime = System.currentTimeMillis();
            do {
                WaitingQueueElement nextReaderElement = this._readers.head();
                long nextReader = Long.MIN_VALUE;
                if (nextReaderElement != null) {
                    nextReader = nextReaderElement._index;
                }
                if ((nextReader == Long.MIN_VALUE || nextReader > index) && this._writers.head() == element) {
                    ++element._lockCount;
                    element._granted = true;
                    return true;
                }
                if (waitTime == 0) {
                    elements.remove(this);
                    this._writers.removeTail();
                    return false;
                }
                try {
                    if (waitTime == -1) {
                        this.wait();
                        continue;
                    }
                    long delta = Math.abs(System.currentTimeMillis() - startTime);
                    this.wait((long)waitTime - delta);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (waitTime == -1 || startTime + (long)waitTime > System.currentTimeMillis());
            elements.remove(this);
            this._writers.remove(element);
            this.notifyAll();
            return false;
        }
    }

    public boolean upgrade() throws SynchronizationException {
        return this.upgrade(-1);
    }

    public boolean upgrade(int waitTime) throws SynchronizationException {
        throw new SynchronizationException.UpgradeNotAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downgrade() throws SynchronizationException {
        WaitingQueueElement element = null;
        Map elements = (Map)s_elements.get();
        if (elements != null) {
            element = (WaitingQueueElement)elements.get(this);
        }
        if (element == null) {
            throw new SynchronizationException.LockNotHeld();
        }
        if (element._lockType == 2) {
            RWLock rWLock = this;
            synchronized (rWLock) {
                element._lockType = 1;
                this._writers.removeHead();
                this._readers.addHead(element);
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SynchronizationException {
        WaitingQueueElement e = null;
        Map elements = (Map)s_elements.get();
        if (elements != null) {
            e = (WaitingQueueElement)elements.get(this);
        }
        if (e == null) {
            throw new SynchronizationException.LockNotHeld();
        }
        if (--e._lockCount != 0) {
            return;
        }
        elements.remove(this);
        RWLock rWLock = this;
        synchronized (rWLock) {
            if (e._lockType == 1) {
                this._readers.remove(e);
            } else {
                this._writers.remove(e);
            }
            this.notifyAll();
        }
    }

    public static class WaitingQueue {
        private LinkedList m_elements = new LinkedList();
        private int _removableCount = 0;
        private static final int THRESHOLD = 20;

        public void addTail(WaitingQueueElement e) {
            this.pulse();
            this.m_elements.addLast(e);
        }

        public WaitingQueueElement removeHead() {
            this.pulse();
            int size = this.m_elements.size();
            while (size > 0) {
                WaitingQueueElement e = (WaitingQueueElement)this.m_elements.removeFirst();
                if (!e._removable) {
                    return e;
                }
                --size;
                --this._removableCount;
            }
            return null;
        }

        public WaitingQueueElement head() {
            this.pulse();
            int size = this.m_elements.size();
            while (size > 0) {
                WaitingQueueElement e = (WaitingQueueElement)this.m_elements.getFirst();
                if (e._removable) {
                    this.m_elements.removeFirst();
                    --size;
                    --this._removableCount;
                    continue;
                }
                return e;
            }
            return null;
        }

        public WaitingQueueElement tail() {
            this.pulse();
            int size = this.m_elements.size();
            while (size > 0) {
                WaitingQueueElement e = (WaitingQueueElement)this.m_elements.getLast();
                if (e._removable) {
                    this.m_elements.removeLast();
                    --size;
                    --this._removableCount;
                    continue;
                }
                return e;
            }
            return null;
        }

        public WaitingQueueElement removeTail() {
            this.pulse();
            int size = this.m_elements.size();
            while (size > 0) {
                WaitingQueueElement e = (WaitingQueueElement)this.m_elements.removeLast();
                if (!e._removable) {
                    return e;
                }
                --size;
                --this._removableCount;
            }
            return null;
        }

        public void addHead(WaitingQueueElement element) {
            this.pulse();
            this.m_elements.addFirst(element);
        }

        public void remove(WaitingQueueElement e) {
            e._removable = true;
            ++this._removableCount;
            this.pulse();
        }

        private void pulse() {
            this.purge();
        }

        private void purge() {
            if (this._removableCount > 20 || this._removableCount > this.m_elements.size() / 2) {
                Iterator iter = this.m_elements.iterator();
                while (iter.hasNext()) {
                    WaitingQueueElement element = (WaitingQueueElement)iter.next();
                    if (!element._removable) continue;
                    iter.remove();
                }
                this._removableCount = 0;
            }
        }
    }

    public static class WaitingQueueElement {
        final long _index;
        int _lockType;
        int _lockCount;
        boolean _granted;
        private boolean _removable;

        public WaitingQueueElement(long index) {
            this(0, index);
        }

        public WaitingQueueElement(int type, long index) {
            this._lockType = type;
            this._lockCount = 0;
            this._granted = false;
            this._index = index;
            this._removable = false;
        }
    }
}

