/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.synchronization;

import java.util.List;

public class ReadWriteLock {
    private static final boolean DEBUG = false;
    private static final int MAXTHREADS = 1000;
    private static List allLocks = null;
    private RWNode[] waiters = new RWNode[1000];
    private int cWaiters = 0;

    public static void dumpAllLocks() {
    }

    public synchronized void dump() {
        System.out.println("State of: " + this);
        for (int i = 0; i < this.cWaiters; ++i) {
            System.out.println(this.waiters[i]);
        }
    }

    public boolean isLockedForReadOnly() {
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            return false;
        }
        RWNode node = this.waiters[index];
        return node.state == 0;
    }

    public boolean isLockedForWrite() {
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            return false;
        }
        RWNode node = this.waiters[index];
        return node.state == 1;
    }

    public void lockRead() {
        this.lockRead(false);
    }

    public synchronized void lockRead(boolean debug) {
        RWNode node;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            node = new RWNode(me, 0, debug);
            this.addWaiter(node);
        } else {
            node = this.waiters[index];
        }
        while (this.firstWriter() == 0 && this.getIndex(me) != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {}
        }
        ++node.nAcquires;
    }

    public void lockWrite() {
        this.lockWrite(false);
    }

    public synchronized void lockWrite(boolean debug) {
        RWNode node;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            node = new RWNode(me, 1, debug);
            this.addWaiter(node);
        } else {
            node = this.waiters[index];
            if (node.state == 0) {
                throw new UpgradeException();
            }
            node.state = 1;
        }
        while (this.getIndex(me) != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {}
        }
        ++node.nAcquires;
    }

    public synchronized void unlock() {
        try {
            int reader;
            Thread me = Thread.currentThread();
            int index = this.getIndex(me);
            RWNode node = this.waiters[index];
            --node.nAcquires;
            if (node.nAcquires == 0) {
                this.removeWaiter(index);
            }
            if ((reader = this.firstReader()) > 0) {
                node = this.waiters[reader];
                this.removeWaiter(reader);
                this.insertWaiter(node, 0);
            }
            this.notifyAll();
        }
        catch (Exception e) {
            System.out.println("Exception thrown in ReadWriteLock.unlock");
        }
    }

    private void addWaiter(RWNode node) {
        if (this.cWaiters == 1000) {
            throw new TooManyThreadsException();
        }
        this.waiters[this.cWaiters++] = node;
    }

    private void insertWaiter(RWNode node, int index) {
        if (this.cWaiters == 1000) {
            throw new TooManyThreadsException();
        }
        System.arraycopy(this.waiters, index, this.waiters, index + 1, this.cWaiters - index);
        this.waiters[index] = node;
        ++this.cWaiters;
    }

    private void removeWaiter(int index) {
        System.arraycopy(this.waiters, index + 1, this.waiters, index, this.cWaiters - (index + 1));
        --this.cWaiters;
    }

    private int firstReader() {
        for (int index = 0; index < this.cWaiters; ++index) {
            RWNode node = this.waiters[index];
            if (node.state != 0) continue;
            return index;
        }
        return -1;
    }

    private int firstWriter() {
        for (int index = 0; index < this.cWaiters; ++index) {
            RWNode node = this.waiters[index];
            if (node.state != 1) continue;
            return index;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread t) {
        for (int index = 0; index < this.cWaiters; ++index) {
            RWNode node = this.waiters[index];
            if (node.thread != t) continue;
            return index;
        }
        return -1;
    }

    public static class TooManyThreadsException
    extends RuntimeException {
    }

    public static class UpgradeException
    extends RuntimeException {
        UpgradeException() {
        }

        UpgradeException(String msg) {
            super(msg);
        }
    }

    static class RWNode {
        static final int READER = 0;
        static final int WRITER = 1;
        Thread thread;
        int state;
        int nAcquires;
        String debugInfo;

        RWNode(Thread t, int state, boolean debug) {
            this.thread = t;
            this.state = state;
            this.nAcquires = 0;
        }

        public String toString() {
            return (this.state == 0 ? "READER" : "WRITER") + " " + this.thread.toString() + " acquires: " + this.nAcquires + (this.debugInfo != null ? "\n" + this.debugInfo : "");
        }
    }
}

