/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.trace;

import com.crystaldecisions.celib.exception.AssertionFailException;
import com.crystaldecisions.celib.trace.ILogger;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class CELogger
implements ILogger {
    private final Logger m_delegate;

    CELogger(String name) {
        this.m_delegate = Logger.getLogger((String)name);
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.m_delegate.error((Object)msg, (Throwable)new AssertionFailException());
        }
    }

    public void assertNotNull(Object object, String name) {
        if (object == null) {
            this.assertLog(false, "Variable " + name + " shouldn't be null");
        }
    }

    public void assertEquals(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            if (obj1 != obj2) {
                this.assertLog(false, "Expected:" + obj1 + ", but was:" + obj2);
            }
        } else if (!obj1.equals(obj2)) {
            this.assertLog(false, "Expected:" + obj1 + ", but was:" + obj2);
        }
    }

    public void assertEqualsIgnoreCase(String obj1, String obj2) {
        if (obj1 == null || obj2 == null) {
            if (obj1 != obj2) {
                this.assertLog(false, "Expected:" + obj1 + ", but was:" + obj2);
            }
        } else if (!obj1.equalsIgnoreCase(obj2)) {
            this.assertLog(false, "Expected:" + obj1 + ", but was:" + obj2);
        }
    }

    public void debug(Object message) {
        this.m_delegate.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.m_delegate.debug(message, t);
    }

    public void error(Object message) {
        this.m_delegate.error(message);
    }

    public void error(Object message, Throwable t) {
        this.m_delegate.error(message, t);
    }

    public void fatal(Object message) {
        this.m_delegate.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.m_delegate.fatal(message, t);
    }

    public void info(Object message) {
        this.m_delegate.info(message);
    }

    public void info(Object message, Throwable t) {
        this.m_delegate.info(message, t);
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public void warn(Object message) {
        this.m_delegate.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.m_delegate.warn(message, t);
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Priority.WARN);
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Priority.FATAL);
    }
}

