/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.trace;

import com.crystaldecisions.celib.classloader.ClassLoaderHelper;
import com.crystaldecisions.celib.collections.CaseInsensHashMap;
import com.crystaldecisions.celib.trace.CELogger;
import com.crystaldecisions.celib.trace.CENDC;
import com.crystaldecisions.celib.trace.DumbLogger;
import com.crystaldecisions.celib.trace.DumbNDC;
import com.crystaldecisions.celib.trace.ILogger;
import com.crystaldecisions.celib.trace.INDC;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class TraceManager {
    public static final String DEFAULT_CONFIGURATION_FOLDER = "META-INF/CrystalEnterprise.Trace";
    public static final String DEFAULT_CONFIGURATION = "basic";
    private static LoggerFactory s_loggerFactory;
    private static boolean TRACE;
    private static INDC s_ndc;

    private static boolean checkTraceFlag(Map props) {
        String trace = (String)props.get("crystal.enterprise.trace");
        return trace == null || trace.equalsIgnoreCase("true") || trace.equalsIgnoreCase("on") || trace.equalsIgnoreCase("yes");
    }

    public static void resetAndConfigure(String resource) {
        if (TRACE) {
            URL url = null;
            url = ClassLoaderHelper.getResource("META-INF/CrystalEnterprise.Trace/" + resource + ".properties");
            if (url == null) {
                try {
                    url = new URL(resource);
                }
                catch (MalformedURLException e) {
                    url = ClassLoaderHelper.getResource(resource);
                }
            }
            if (url != null) {
                System.setProperty("log4j.defaultInitOverride", "true");
                PropertyConfigurator.configure((URL)url);
            }
        }
    }

    public static void reInitialize() {
        Properties props = System.getProperties();
        CaseInsensHashMap insensSystemProps = new CaseInsensHashMap(props);
        TRACE = TraceManager.checkTraceFlag(insensSystemProps);
        if (TRACE) {
            try {
                String override = (String)insensSystemProps.get("crystal.enterprise.trace.override");
                if (override == null || "false".equalsIgnoreCase(override)) {
                    String resource = (String)insensSystemProps.get("crystal.enterprise.trace.configuration");
                    if (resource == null) {
                        resource = DEFAULT_CONFIGURATION;
                    }
                    TraceManager.resetAndConfigure(resource);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static ILogger getLogger(String name) {
        return s_loggerFactory.makeLogger(name);
    }

    public static ILogger getLogger(Class clazz) {
        return s_loggerFactory.makeLogger(clazz.getName());
    }

    public static INDC getNDC() {
        return s_ndc;
    }

    static {
        Properties props = System.getProperties();
        CaseInsensHashMap insensSystemProps = new CaseInsensHashMap(props);
        TRACE = TraceManager.checkTraceFlag(insensSystemProps);
        if (TRACE) {
            try {
                String override = (String)insensSystemProps.get("crystal.enterprise.trace.override");
                if (override == null || "false".equalsIgnoreCase(override)) {
                    String resource = (String)insensSystemProps.get("crystal.enterprise.trace.configuration");
                    if (resource == null) {
                        resource = DEFAULT_CONFIGURATION;
                    }
                    TraceManager.resetAndConfigure(resource);
                }
                s_loggerFactory = new LoggerFactory(){

                    public ILogger makeLogger(String name) {
                        return new CELogger(name);
                    }
                };
                s_ndc = new CENDC();
            }
            catch (Throwable t) {
                TRACE = false;
                final DumbLogger dumpLogger = new DumbLogger();
                s_loggerFactory = new LoggerFactory(){

                    public ILogger makeLogger(String name) {
                        return dumpLogger;
                    }
                };
                s_ndc = new DumbNDC();
            }
        } else {
            final DumbLogger dumpLogger = new DumbLogger();
            s_loggerFactory = new LoggerFactory(){

                public ILogger makeLogger(String name) {
                    return dumpLogger;
                }
            };
            s_ndc = new DumbNDC();
        }
    }

    private static interface LoggerFactory {
        public ILogger makeLogger(String var1);
    }
}

