/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.celib.uri;

import com.crystaldecisions.celib.exception.SILibException;
import com.crystaldecisions.celib.properties.IBagUnpacker;
import com.crystaldecisions.celib.properties.IStreamBagPacker;
import com.crystaldecisions.celib.properties.PropertyBag;
import com.crystaldecisions.celib.properties.URLPacker;
import com.crystaldecisions.celib.properties.URLUnpacker;
import com.crystaldecisions.celib.uri.AbstractURI;
import com.crystaldecisions.celib.uri.URIException;
import java.io.IOException;
import java.io.Writer;

public class OcaURI
extends AbstractURI {
    private static final String OCA_PROTOCOL = "osca:iiop";

    public OcaURI(String uri) throws SILibException {
        super(uri);
    }

    public OcaURI(String machine, Integer id, String value) {
        this.m_protocol = OCA_PROTOCOL;
        this.m_path = "//" + machine;
        PropertyBag pb = this.getProperties();
        pb.addItem(id, value, 0);
    }

    protected IStreamBagPacker getPacker() {
        return new URLPacker(',');
    }

    protected IBagUnpacker getUnpacker() {
        return new URLUnpacker(',');
    }

    protected int parseProtocol(String in, int start) throws SILibException {
        if (in.regionMatches(start, OCA_PROTOCOL, 0, OCA_PROTOCOL.length()) && in.charAt(start + OCA_PROTOCOL.length()) == ':') {
            this.m_protocol = OCA_PROTOCOL;
            return start + OCA_PROTOCOL.length() + 1;
        }
        throw new URIException.Invalid(in);
    }

    protected int parsePath(String in, int start) throws SILibException {
        if (in.charAt(start) == '/' && in.charAt(start + 1) == '/') {
            int delim = in.indexOf(59, start + 2);
            if (delim == -1) {
                delim = in.length();
            }
            this.m_path = in.substring(start, delim);
            return delim + 1;
        }
        throw new URIException.Invalid(in);
    }

    protected void pathToString(Writer out, boolean hasProperties) throws IOException {
        out.write(this.m_path);
        if (hasProperties) {
            out.write(59);
        }
    }
}

