/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.BiDir;

import com.crystaldecisions.thirdparty.com.ooc.BiDirIOP.ProfileBody;
import com.crystaldecisions.thirdparty.com.ooc.BiDirIOP.ProfileBodyHelper;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetDatabase;
import com.crystaldecisions.thirdparty.com.ooc.OB.HexConverter;
import com.crystaldecisions.thirdparty.com.ooc.OB.Util;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetComponentInfo;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_PARAM;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INV_OBJREF;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORB;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UserException;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_0;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_0Helper;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.IOP.IORHelper;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedComponent;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedComponentHelper;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedProfile;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class IORDump {
    static void PrintTagCodeSets(PrintStream out, TaggedComponent component) {
        int i;
        byte[] data = component.component_data;
        Buffer buf = new Buffer(data, data.length);
        InputStream in = new InputStream(buf);
        in._OB_readEndian();
        CodeSetComponentInfo info = CodeSetComponentInfoHelper.read(in);
        CodeSetDatabase db = CodeSetDatabase.instance();
        out.println("Native char codeset:");
        String name = db.idToName(info.ForCharData.native_code_set);
        if (name != null) {
            out.println("  \"" + name + "\"");
        } else {
            out.println("  [No codeset information]");
        }
        for (i = 0; i < info.ForCharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                out.println("Char conversion codesets:");
            }
            if ((name = db.idToName(info.ForCharData.conversion_code_sets[i])) != null) {
                out.println("  \"" + name + "\"");
                continue;
            }
            out.println("  [No codeset information]");
        }
        out.println("Native wchar codeset: ");
        name = db.idToName(info.ForWcharData.native_code_set);
        if (name != null) {
            out.println("  \"" + name + "\"");
        } else {
            out.println("  [No codeset information]");
        }
        for (i = 0; i < info.ForWcharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                out.println("Wchar conversion codesets:");
            }
            if ((name = db.idToName(info.ForWcharData.conversion_code_sets[i])) != null) {
                out.println("  \"" + name + "\"");
                continue;
            }
            out.println("  [No codeset information]");
        }
    }

    static void PrintIIOPProfile(PrintStream out, TaggedProfile profile) {
        byte[] data = profile.profile_data;
        Buffer buf = new Buffer(data, data.length);
        InputStream in = new InputStream(buf);
        in._OB_readEndian();
        ProfileBody_1_0 body = ProfileBody_1_0Helper.read(in);
        out.println("iiop_version: " + body.iiop_version.major + '.' + body.iiop_version.minor);
        out.println("host: " + body.host);
        int port = body.port < 0 ? 65535 + body.port + 1 : body.port;
        out.println("port: " + port);
        out.println("object_key: (" + body.object_key.length + ")");
        Util.printOctets(out, body.object_key, 0, body.object_key.length);
        if (body.iiop_version.major > 1 || body.iiop_version.minor >= 1) {
            int l = in.read_ulong();
            int countAlternate = 1;
            for (int i = 0; i < l; ++i) {
                TaggedComponent component = TaggedComponentHelper.read(in);
                if (component.tag == 3) {
                    byte[] d = component.component_data;
                    Buffer b = new Buffer(d, d.length);
                    InputStream s = new InputStream(b);
                    s._OB_readEndian();
                    String altHost = s.read_string();
                    int altPort = s.read_ushort();
                    int p = altPort < 0 ? 65535 + altPort + 1 : altPort;
                    out.println("Alternate IIOP address #" + countAlternate + ":");
                    out.println("  host: " + altHost);
                    out.println("  port: " + p);
                    ++countAlternate;
                    continue;
                }
                if (component.tag != 1) continue;
                IORDump.PrintTagCodeSets(out, component);
            }
        }
    }

    static void PrintBiDirIOPProfile(PrintStream out, TaggedProfile profile) {
        byte[] data = profile.profile_data;
        Buffer buf = new Buffer(data, data.length);
        InputStream in = new InputStream(buf);
        in._OB_readEndian();
        ProfileBody body = ProfileBodyHelper.read(in);
        out.println("giop_version: " + body.giop_version.major + '.' + body.giop_version.minor);
        out.println("peer: " + body.peer);
        out.println("object_key: (" + body.object_key.length + ")");
        Util.printOctets(out, body.object_key, 0, body.object_key.length);
        for (int i = 0; i < body.components.length; ++i) {
            if (body.components[i].tag != 1) continue;
            IORDump.PrintTagCodeSets(out, body.components[i]);
        }
        if (body.profiles.length == 0) {
            out.println("No encapsulated profiles - callbacks only");
        } else {
            int countIOP = 1;
            for (int i = 0; i < body.profiles.length; ++i) {
                out.println("Encapsulated IIOP profile #" + countIOP++ + ":");
                IORDump.PrintIIOPProfile(out, body.profiles[i]);
            }
        }
    }

    static void PrintObjref(PrintStream out, IOR ior) {
        int countIOP = 1;
        int countMulti = 1;
        int countBiDir = 1;
        out.println("type_id: " + ior.type_id);
        for (int i = 0; i < ior.profiles.length; ++i) {
            if (ior.profiles[i].tag == 0) {
                out.println("IIOP profile #" + countIOP++ + ":");
                IORDump.PrintIIOPProfile(out, ior.profiles[i]);
                continue;
            }
            if (ior.profiles[i].tag == 1) {
                out.print("Multiple component profile #" + countMulti++ + ": ");
                byte[] data = ior.profiles[i].profile_data;
                Buffer buf = new Buffer(data, data.length);
                InputStream in = new InputStream(buf);
                in._OB_readEndian();
                int cnt = in.read_ulong();
                if (cnt == 0) {
                    out.println();
                    continue;
                }
                for (int j = 0; j < cnt; ++j) {
                    TaggedComponent comp = TaggedComponentHelper.read(in);
                    if (comp.tag == 0) {
                        out.println("IOP::TAG_ORB_TYPE");
                        continue;
                    }
                    if (comp.tag == 1) {
                        out.println("IOP::TAG_CODE_SETS");
                        IORDump.PrintTagCodeSets(out, comp);
                        continue;
                    }
                    if (comp.tag == 2) {
                        out.println("IOP::TAG_POLICIES");
                        continue;
                    }
                    if (comp.tag == 3) {
                        out.println("IOP::TAG_ALTERNATE_IIOP_ADDRESS");
                        continue;
                    }
                    if (comp.tag == 13) {
                        out.println("IOP::TAG_ASSOCIATION_OPTION");
                        continue;
                    }
                    if (comp.tag == 14) {
                        out.println("IOP::TAG_SEC_NAM");
                        continue;
                    }
                    if (comp.tag == 15) {
                        out.println("IOP::TAG_SPKM_1_SEC_MECH");
                        continue;
                    }
                    if (comp.tag == 16) {
                        out.println("IOP::TAG_SPKM_2_SEC_MECH");
                        continue;
                    }
                    if (comp.tag == 17) {
                        out.println("IOP::TAG_KerberosV5_SEC_MECH");
                        continue;
                    }
                    if (comp.tag == 18) {
                        out.println("IOP::TAG_CSI_ECMA_Secret_SEC_MECH");
                        continue;
                    }
                    if (comp.tag == 19) {
                        out.println("IOP::TAG_CSI_ECMA_Hybrid_SEC_MECH");
                        continue;
                    }
                    if (comp.tag == 20) {
                        out.println("IOP::TAG_SSL_SEC_TRANS");
                        continue;
                    }
                    if (comp.tag == 21) {
                        out.println("IOP::TAG_CSI_ECMA_Public_SEC_MECH");
                        continue;
                    }
                    if (comp.tag == 22) {
                        out.println("IOP::TAG_GENERIC_SEC_MECH");
                        continue;
                    }
                    if (comp.tag == 25) {
                        out.println("IOP::TAG_JAVA_CODEBASE");
                        continue;
                    }
                    out.println("Unknown tag: " + comp.tag);
                }
                continue;
            }
            if (ior.profiles[i].tag == 1024) {
                out.println("Bi-directional IIOP profile #" + countBiDir++ + ":");
                IORDump.PrintBiDirIOPProfile(out, ior.profiles[i]);
                continue;
            }
            out.println("Unknown profile tag: " + ior.profiles[i].tag);
        }
        out.flush();
    }

    static void PrintObjref(PrintStream out, String s) {
        InputStream in;
        if (!s.startsWith("IOR:")) {
            throw new INV_OBJREF();
        }
        byte[] data = HexConverter.asciiToOctets(s, 4);
        Buffer buf = new Buffer(data, data.length);
        boolean endian = (in = new InputStream(buf)).read_boolean();
        in._OB_swap(endian);
        IOR ior = IORHelper.read(in);
        out.println("byteorder: " + (endian ? "little" : "big") + " endian");
        IORDump.PrintObjref(out, ior);
    }

    static void DumpIOR(String ior) {
        try {
            IORDump.PrintObjref(System.out, ior);
        }
        catch (INV_OBJREF ex) {
            System.out.println("IOR is invalid");
        }
        System.out.flush();
    }

    static void usage() {
        System.err.println("Usage:");
        System.err.println("com.crystaldecisions.thirdparty.com.ooc.BiDir.IORDump [options] [-f FILE ... | IOR ...]\n\nOptions:\n-h, --help             Show this message.\n-v, --version          Show ORBacus version.\n-f                     Read IORs from files instead from the\n                       command line.");
    }

    static int run(ORB orb, String[] args) throws UserException {
        int i;
        boolean files = false;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                IORDump.usage();
                return 0;
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                System.out.println("ORBacus 4.0.5");
                return 0;
            }
            if (!args[i].equals("-f")) {
                System.err.println("IORDump: unknown option `" + args[i] + "'");
                IORDump.usage();
                return 1;
            }
            files = true;
        }
        if (i == args.length) {
            System.err.println("IORDump: no IORs");
            System.err.println();
            IORDump.usage();
            return 1;
        }
        if (!files) {
            int count = 0;
            while (i < args.length) {
                if (count > 0) {
                    System.out.println();
                }
                System.out.println("IOR #" + ++count + ':');
                try {
                    com.crystaldecisions.thirdparty.org.omg.CORBA.Object obj = orb.string_to_object(args[i]);
                    String s = orb.object_to_string(obj);
                    IORDump.DumpIOR(s);
                }
                catch (BAD_PARAM ex) {
                    System.err.println("IOR is invalid");
                }
                ++i;
            }
        } else {
            int count = 0;
            while (i < args.length) {
                try {
                    String line;
                    FileReader fin = new FileReader(args[i]);
                    BufferedReader in = new BufferedReader(fin);
                    while ((line = in.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        if (count > 0) {
                            System.out.println();
                        }
                        System.out.println("IOR #" + ++count + ':');
                        IORDump.DumpIOR(line);
                    }
                }
                catch (FileNotFoundException ex) {
                    System.err.println("IORDump: can't open `" + args[i] + "': " + ex);
                    return 1;
                }
                catch (IOException ex) {
                    System.err.println("IORDump: can't read `" + args[i] + "': " + ex);
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("com.crystaldecisions.thirdparty.org.omg.CORBA.ORBClass", "com.crystaldecisions.thirdparty.com.ooc.CORBA.ORB");
        props.put("com.crystaldecisions.thirdparty.org.omg.CORBA.ORBSingletonClass", "com.crystaldecisions.thirdparty.com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            orb = ORB.init(args, props);
            status = IORDump.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                ((com.crystaldecisions.thirdparty.com.ooc.CORBA.ORB)orb).destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

