/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.ACMTimeoutPolicy;
import com.crystaldecisions.thirdparty.com.ooc.OB.ACMTimeoutPolicyHelper;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.Client;
import com.crystaldecisions.thirdparty.com.ooc.OB.ClientProfilePair;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeConverters;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetUtil;
import com.crystaldecisions.thirdparty.com.ooc.OB.CollocatedClient;
import com.crystaldecisions.thirdparty.com.ooc.OB.CollocatedServer;
import com.crystaldecisions.thirdparty.com.ooc.OB.ConnectionPoolPolicy;
import com.crystaldecisions.thirdparty.com.ooc.OB.ConnectionPoolPolicyHelper;
import com.crystaldecisions.thirdparty.com.ooc.OB.ConnectionReusePolicyHelper;
import com.crystaldecisions.thirdparty.com.ooc.OB.ConnectionReusePolicyOperations;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPClient;
import com.crystaldecisions.thirdparty.com.ooc.OB.LocalCodeConverter;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManager;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManagerFactory;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManager_impl;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Acceptor;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ConFactory;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ConFactoryRegistry;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Connector;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INV_OBJREF;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_RESOURCES;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Policy;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public final class ClientManager {
    private boolean destroy_ = false;
    private ORBInstance orbInstance_;
    private Vector allClients_ = new Vector();
    private Vector reusableClients_ = new Vector();
    private int concModel_;
    private int defaultACMTimeout_;

    protected void finalize() throws Throwable {
        Assert.assertTrue(this.destroy_);
        Assert.assertTrue(this.allClients_.size() == 0);
        Assert.assertTrue(this.reusableClients_.size() == 0);
        super.finalize();
    }

    synchronized void destroy() {
        if (this.destroy_) {
            return;
        }
        this.destroy_ = true;
        Enumeration e = this.allClients_.elements();
        while (e.hasMoreElements()) {
            Client client = (Client)e.nextElement();
            client.destroy();
        }
        this.orbInstance_ = null;
        this.allClients_.removeAllElements();
        this.reusableClients_.removeAllElements();
    }

    public ClientManager(int concModel) {
        this.concModel_ = concModel;
    }

    public void setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.client_timeout");
        this.defaultACMTimeout_ = value != null ? Integer.parseInt(value) : 0;
    }

    public synchronized Vector getClientProfilePairs(IOR ior, Policy[] policies) {
        int i;
        int j;
        int i2;
        Assert.assertTrue(ior.type_id != null);
        if (ior.type_id.length() == 0 && ior.profiles.length == 0) {
            throw new INV_OBJREF("Object reference is nil");
        }
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        int acmTimeout = this.defaultACMTimeout_;
        for (int i3 = 0; i3 < policies.length; ++i3) {
            if (policies[i3].policy_type() != 1330577418) continue;
            ACMTimeoutPolicy policy = ACMTimeoutPolicyHelper.narrow(policies[i3]);
            acmTimeout = policy.value();
            break;
        }
        Vector<ClientProfilePair> pairs = new Vector<ClientProfilePair>();
        ConnectionReusePolicyOperations reusePolicy = null;
        ConnectionPoolPolicy connPoolPolicy = null;
        for (int i4 = 0; i4 < policies.length; ++i4) {
            if (policies[i4].policy_type() == 1330577411) {
                reusePolicy = ConnectionReusePolicyHelper.narrow(policies[i4]);
                continue;
            }
            if (policies[i4].policy_type() != 1330577419) continue;
            connPoolPolicy = ConnectionPoolPolicyHelper.narrow(policies[i4]);
        }
        boolean privateClients = reusePolicy != null && !reusePolicy.value();
        POAManagerFactory pmFactory = this.orbInstance_.getPOAManagerFactory();
        POAManager[] managers = pmFactory.get_poa_managers();
        for (i2 = 0; i2 < managers.length; ++i2) {
            try {
                Acceptor[] acceptors = managers[i2].get_acceptors();
                boolean local = false;
                for (j = 0; j < acceptors.length && !local; ++j) {
                    ProfileInfo[] localProfileInfos = acceptors[j].get_local_profiles(ior);
                    if (localProfileInfos.length <= 0) continue;
                    local = true;
                }
                if (!local) continue;
                POAManager_impl manager = (POAManager_impl)managers[i2];
                CollocatedServer collocatedServer = manager._OB_getCollocatedServer();
                CodeConverters conv = new CodeConverters();
                conv.inputCharConverter = LocalCodeConverter.instanceChar();
                conv.outputCharConverter = LocalCodeConverter.instanceChar();
                conv.wcharConverter = LocalCodeConverter.instanceWchar();
                CollocatedClient client = new CollocatedClient(collocatedServer, this.concModel_, conv);
                this.allClients_.addElement(client);
                ProfileInfo[] profileInfos = ((Client)client).getUsableProfiles(ior, policies);
                for (int j2 = 0; j2 < profileInfos.length; ++j2) {
                    ClientProfilePair pair = new ClientProfilePair();
                    pair.client = client;
                    pair.profile = profileInfos[j2];
                    pairs.addElement(pair);
                }
                continue;
            }
            catch (AdapterInactive ex) {
                // empty catch block
            }
        }
        if (!privateClients) {
            for (i2 = 0; i2 < this.reusableClients_.size(); ++i2) {
                Client reusableClient = (Client)this.reusableClients_.elementAt(i2);
                ProfileInfo[] profileInfos = reusableClient.getUsableProfiles(ior, policies);
                for (j = 0; j < profileInfos.length; ++j) {
                    ClientProfilePair pair = new ClientProfilePair();
                    pair.client = reusableClient;
                    pair.profile = profileInfos[j];
                    pairs.addElement(pair);
                }
            }
        }
        ConFactoryRegistry conFactoryRegistry = this.orbInstance_.getConFactoryRegistry();
        ConFactory[] factories = conFactoryRegistry.get_factories();
        for (i = 0; i < factories.length; ++i) {
            Connector[] connectors = factories[i].create_connectors(ior, policies);
            for (int j3 = 0; j3 < connectors.length; ++j3) {
                ProfileInfo[] profileInfos = connectors[j3].get_usable_profiles(ior, policies);
                Assert.assertTrue(profileInfos.length >= 1);
                for (int k = 0; k < profileInfos.length; ++k) {
                    CodeConverters conv = CodeSetUtil.getCodeConverters(profileInfos[k]);
                    GIOPClient client = new GIOPClient(this.orbInstance_, connectors[j3], this.concModel_, conv, acmTimeout);
                    if (pairs.size() > 0) {
                        int l;
                        for (l = 0; l < pairs.size(); ++l) {
                            ClientProfilePair pair = (ClientProfilePair)pairs.elementAt(l);
                            if (pair.client.equal(client)) break;
                        }
                        if (l != pairs.size()) {
                            ((Client)client).destroy();
                            continue;
                        }
                    }
                    if (connPoolPolicy != null) {
                        client.setConnectionPool(connPoolPolicy.value());
                    }
                    this.allClients_.addElement(client);
                    ProfileInfo[] clientProfileInfos = ((Client)client).getUsableProfiles(ior, policies);
                    for (int l = 0; l < clientProfileInfos.length; ++l) {
                        ClientProfilePair pair = new ClientProfilePair();
                        pair.client = client;
                        pair.profile = clientProfileInfos[l];
                        pairs.addElement(pair);
                    }
                    if (privateClients) continue;
                    this.reusableClients_.addElement(client);
                }
            }
        }
        if (pairs.size() == 0) {
            throw new NO_RESOURCES("Unable to create client");
        }
        for (i = 0; i < pairs.size(); ++i) {
            ClientProfilePair pair = (ClientProfilePair)pairs.elementAt(i);
            pair.client.incUsage();
        }
        return pairs;
    }

    public synchronized void releaseClient(Client client) {
        if (this.destroy_) {
            return;
        }
        boolean inUse = client.decUsage();
        if (!inUse) {
            Client c;
            int i;
            for (i = 0; i < this.reusableClients_.size(); ++i) {
                c = (Client)this.reusableClients_.elementAt(i);
                if (c != client) continue;
                this.reusableClients_.removeElementAt(i);
                break;
            }
            for (i = 0; i < this.allClients_.size(); ++i) {
                c = (Client)this.allClients_.elementAt(i);
                if (c != client) continue;
                client.destroy();
                this.allClients_.removeElementAt(i);
                return;
            }
            Assert.assertTrue(false);
        }
    }

    public boolean equivalent(IOR ior1, IOR ior2) {
        ConFactoryRegistry conFactoryRegistry = this.orbInstance_.getConFactoryRegistry();
        ConFactory[] factories = conFactoryRegistry.get_factories();
        for (int i = 0; i < factories.length; ++i) {
            if (factories[i].equivalent(ior1, ior2)) continue;
            return false;
        }
        return true;
    }

    public int hash(IOR ior, int maximum) {
        ConFactoryRegistry conFactoryRegistry = this.orbInstance_.getConFactoryRegistry();
        ConFactory[] factories = conFactoryRegistry.get_factories();
        int hash = 0;
        for (int i = 0; i < factories.length; ++i) {
            hash ^= factories[i].hash(ior, maximum);
        }
        return hash % (maximum + 1);
    }
}

