/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.CharMapInfo;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeConverterBase;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetDatabase;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetInfo;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetUtil;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.DATA_CONVERSION;
import com.crystaldecisions.thirdparty.org.omg.CORBA.MARSHAL;

public final class CodeConverter
extends CodeConverterBase {
    private CharMapInfo fromMap_;
    private CharMapInfo toMap_;
    private int conversionType_;

    CodeConverter(CodeSetInfo fromSet, CodeSetInfo toSet) {
        super(fromSet, toSet);
        CodeSetDatabase db = CodeSetDatabase.instance();
        if (fromSet != null) {
            if (fromSet.max_bytes == 1) {
                if (fromSet.rgy_value != 65537) {
                    this.fromMap_ = db.getCharMapInfo(fromSet);
                }
            } else if (fromSet.rgy_value != 65801) {
                this.fromMap_ = db.getCharMapInfo(fromSet);
            }
        }
        if (toSet != null) {
            if (toSet.max_bytes == 1) {
                if (toSet.rgy_value != 65537) {
                    this.toMap_ = db.getCharMapInfo(toSet);
                }
            } else if (toSet.rgy_value != 65801) {
                this.toMap_ = db.getCharMapInfo(toSet);
            }
        }
        this.conversionType_ = this.fromMap_ != null && this.toMap_ != null ? 3 : (this.fromMap_ != null ? 1 : (this.toMap_ != null ? 2 : 0));
    }

    public int getConversionType() {
        return this.conversionType_;
    }

    public char convertCharFrom(char v) {
        char value = v;
        if (value >= (char)this.fromMap_.lower_bound && value <= (char)this.fromMap_.upper_bound) {
            value = (char)this.fromMap_.map_values[value - this.fromMap_.lower_bound];
        }
        return value;
    }

    public char convertCharTo(char v) {
        char value = v;
        for (int i = 0; i <= this.toMap_.upper_bound - this.toMap_.lower_bound; ++i) {
            if (this.toMap_.map_values[i] != value) continue;
            value = (char)(this.toMap_.lower_bound + i);
            break;
        }
        return value;
    }

    public char convertCharBoth(char v) {
        char value = v;
        if (value >= (char)this.fromMap_.lower_bound && value <= (char)this.fromMap_.upper_bound) {
            value = (char)this.fromMap_.map_values[value - this.fromMap_.lower_bound];
        }
        for (int i = 0; i <= this.toMap_.upper_bound - this.toMap_.lower_bound; ++i) {
            if (this.toMap_.map_values[i] != value) continue;
            value = (char)(this.toMap_.lower_bound + i);
            break;
        }
        return value;
    }

    public void write_wchar(OutputStream out, char v) throws DATA_CONVERSION {
        if (this.toSet_.rgy_value == 0x5010001) {
            CodeSetUtil.unicodeToUtf8(out, v);
        } else {
            int len = this.count_wchar(v);
            char value = v;
            while (len != 0) {
                out.buf_.data_[out.buf_.pos_ + --len] = (byte)value;
                value = (char)(value >> 8);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int count_wchar(InputStream in) {
        if (this.toSet_.rgy_value != 0x5010001) return this.toSet_.max_bytes;
        byte first = in.buf_.data_[in.buf_.pos_];
        if ((first & 0x80) == 0) {
            return 1;
        }
        if ((first & 0xE0) == 192) {
            return 2;
        }
        if ((first & 0xF0) == 224) {
            return 3;
        }
        if ((first & 0xF8) == 240) {
            return 4;
        }
        if ((first & 0xFC) == 248) {
            return 5;
        }
        if ((first & 0xFE) != 252) throw new MARSHAL(MinorCodes.describeMarshal(1330577427), 1330577427, CompletionStatus.COMPLETED_NO);
        return 6;
    }

    public int count_wchar(char value) {
        int len = this.toSet_.rgy_value == 0x5010001 ? (value < '\u0080' ? 1 : (value < '\u07ff' ? 2 : 3)) : this.toSet_.max_bytes;
        return len;
    }

    public char read_wchar(InputStream in, int len) throws DATA_CONVERSION {
        char v;
        if (this.toSet_.rgy_value == 0x5010001) {
            return CodeSetUtil.utf8ToUnicode(in);
        }
        while (len > 1 && in.buf_.data_[in.buf_.pos_] == 0) {
            ++in.buf_.pos_;
            --len;
        }
        if (len == 0 || len > 2 || len > this.fromSet_.max_bytes) {
            throw new DATA_CONVERSION();
        }
        block0 : switch (len) {
            case 1: {
                v = (char)(in.buf_.data_[in.buf_.pos_++] & 0xFF);
                break;
            }
            case 2: {
                switch (this.toSet_.max_bytes) {
                    case 2: 
                    case 4: {
                        v = (char)(in.buf_.data_[in.buf_.pos_++] << 8);
                        v = (char)(v | (char)in.buf_.data_[in.buf_.pos_++] & 0xFF);
                        break block0;
                    }
                }
                throw new DATA_CONVERSION();
            }
            default: {
                throw new DATA_CONVERSION();
            }
        }
        return v;
    }

    public char convert_wchar_to(char v) throws DATA_CONVERSION {
        char value = v;
        if (value != '\u0000') {
            if (this.fromMap_ != null && value >= (char)this.fromMap_.lower_bound && value <= (char)this.fromMap_.upper_bound) {
                value = (char)this.fromMap_.map_values[value - this.fromMap_.lower_bound];
            }
            if (this.toMap_ != null) {
                for (int i = 0; i <= this.toMap_.upper_bound - this.toMap_.lower_bound; ++i) {
                    if (this.toMap_.map_values[i] != value) continue;
                    value = (char)(this.toMap_.lower_bound + i);
                    break;
                }
            }
        }
        return value;
    }

    public char convert_wchar_from(char v) throws DATA_CONVERSION {
        char value = v;
        if (value != '\u0000') {
            if (this.toMap_ != null && value >= (char)this.toMap_.lower_bound && value <= (char)this.toMap_.upper_bound) {
                value = (char)this.toMap_.map_values[value - this.toMap_.lower_bound];
            }
            if (this.fromMap_ != null) {
                for (int i = 0; i <= this.fromMap_.upper_bound - this.fromMap_.lower_bound; ++i) {
                    if (this.fromMap_.map_values[i] != value) continue;
                    value = (char)(this.fromMap_.lower_bound + i);
                    break;
                }
            }
        }
        return value;
    }
}

