/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.CharMapDatabaseInit;
import com.crystaldecisions.thirdparty.com.ooc.OB.CharMapInfo;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeConverter;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeConverterBase;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetDatabaseInit;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetInfo;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetUtil;
import com.crystaldecisions.thirdparty.com.ooc.OB.LocalCodeConverter;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetComponent;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CODESET_INCOMPATIBLE;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public final class CodeSetDatabase {
    public static final int ISOLATIN1 = 65537;
    public static final int ISOLATIN2 = 65538;
    public static final int ISOLATIN3 = 65539;
    public static final int ISOLATIN4 = 65540;
    public static final int ISOLATIN5 = 65541;
    public static final int ISOLATIN7 = 65543;
    public static final int ISOLATIN9 = 65545;
    public static final int PCS = 65568;
    public static final int UTF8 = 0x5010001;
    public static final int UTF16 = 65801;
    public static final int UCS2 = 65792;
    private Vector codeConverters_ = new Vector();
    private static CodeSetDatabase instance_;
    private static CharMapDatabaseInit database_;

    protected void finalize() throws Throwable {
        this.codeConverters_ = null;
        super.finalize();
    }

    public static CodeSetDatabase instance() {
        if (instance_ == null) {
            instance_ = new CodeSetDatabase();
            String locale = Locale.getDefault().getLanguage();
            if (locale.equals("C") || locale.equals("POSIX")) {
                CodeSetUtil.addCharCodeSet(65537);
            } else {
                String loc = locale.substring(0, 2);
                if (loc.equals("de") || loc.equals("en") || loc.equals("fr") || loc.equals("nl") || loc.equals("pt")) {
                    CodeSetUtil.addCharCodeSet(65537);
                } else if (loc.equals("da") || loc.equals("fi") || loc.equals("is") || loc.equals("no") || loc.equals("sv")) {
                    CodeSetUtil.addCharCodeSet(65540);
                } else if (loc.equals("it")) {
                    CodeSetUtil.addCharCodeSet(65539);
                } else if (loc.equals("cs") || loc.equals("hu") || loc.equals("pl") || loc.equals("sk")) {
                    CodeSetUtil.addCharCodeSet(65538);
                } else if (loc.equals("el")) {
                    CodeSetUtil.addCharCodeSet(65543);
                } else if (loc.equals("ru")) {
                    CodeSetUtil.addCharCodeSet(65541);
                } else if (loc.equals("tr")) {
                    CodeSetUtil.addCharCodeSet(65545);
                }
            }
            CodeSetUtil.addCharCodeSet(65568);
            CodeSetUtil.addWcharCodeSet(65801);
            CodeSetUtil.addWcharCodeSet(65792);
        }
        return instance_;
    }

    public synchronized CodeConverterBase getConverter(int to, int from) {
        if (to == 0 || from == 0) {
            return null;
        }
        if (to == from) {
            CodeSetInfo codeSetInfo = this.getCodeSetInfo(to);
            if (codeSetInfo.max_bytes == 1) {
                return LocalCodeConverter.instanceChar();
            }
        }
        Enumeration e = this.codeConverters_.elements();
        while (e.hasMoreElements()) {
            CodeConverterBase c = (CodeConverterBase)e.nextElement();
            if (c.getTo().rgy_value != to || c.getFrom().rgy_value != from) continue;
            return c;
        }
        CodeConverter converter = new CodeConverter(this.getCodeSetInfo(from), this.getCodeSetInfo(to));
        this.codeConverters_.addElement(converter);
        return converter;
    }

    public CodeSetInfo getCodeSetInfo(int rgy_value) {
        for (int i = 0; i < CodeSetDatabaseInit.codeSetInfoArraySize_; ++i) {
            if (CodeSetDatabaseInit.codeSetInfoArray_[i].rgy_value != rgy_value) continue;
            return CodeSetDatabaseInit.codeSetInfoArray_[i];
        }
        return null;
    }

    int determineTCS(CodeSetComponent clientCS, CodeSetComponent serverCS, int fallback) {
        if (clientCS.native_code_set == 0 || serverCS.native_code_set == 0) {
            return 0;
        }
        if (clientCS.native_code_set == serverCS.native_code_set) {
            return serverCS.native_code_set;
        }
        if (this.checkCodeSetId(clientCS, serverCS.native_code_set)) {
            return serverCS.native_code_set;
        }
        if (this.checkCodeSetId(serverCS, clientCS.native_code_set)) {
            return clientCS.native_code_set;
        }
        for (int i = 0; i < serverCS.conversion_code_sets.length; ++i) {
            if (!this.checkCodeSetId(clientCS, serverCS.conversion_code_sets[i])) continue;
            return serverCS.conversion_code_sets[i];
        }
        if (this.isCompatible(clientCS.native_code_set, serverCS.native_code_set)) {
            return fallback;
        }
        throw new CODESET_INCOMPATIBLE();
    }

    boolean isCompatible(int id1, int id2) {
        CodeSetInfo cs1 = this.getCodeSetInfo(id1);
        CodeSetInfo cs2 = this.getCodeSetInfo(id2);
        if (cs1 == null || cs2 == null) {
            return false;
        }
        for (int i = 0; i < cs1.char_values_size; ++i) {
            for (int j = 0; j < cs2.char_values_size; ++j) {
                if (cs1.char_values[i] != cs2.char_values[j]) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkCodeSetId(CodeSetComponent cs, int id) {
        for (int i = 0; i < cs.conversion_code_sets.length; ++i) {
            if (cs.conversion_code_sets[i] != id) continue;
            return true;
        }
        return false;
    }

    public int nameToId(String name) {
        Assert.assertTrue(name != null);
        for (int i = 0; i < CodeSetDatabaseInit.codeSetInfoArraySize_; ++i) {
            String s = CodeSetDatabaseInit.codeSetInfoArray_[i].description;
            if (s.indexOf(name) == -1) continue;
            return CodeSetDatabaseInit.codeSetInfoArray_[i].rgy_value;
        }
        return 0;
    }

    public String idToName(int rgy_value) {
        for (int i = 0; i < CodeSetDatabaseInit.codeSetInfoArraySize_; ++i) {
            if (CodeSetDatabaseInit.codeSetInfoArray_[i].rgy_value != rgy_value) continue;
            return CodeSetDatabaseInit.codeSetInfoArray_[i].description;
        }
        return null;
    }

    CharMapInfo getCharMapInfo(CodeSetInfo codeSetInfo) {
        String name = "";
        switch (codeSetInfo.rgy_value) {
            case 65537: {
                name = "ISO 8859-1 (1987) to Unicode";
                break;
            }
            case 65538: {
                name = "ISO 8859-2 (1987) to Unicode";
                break;
            }
            case 65539: {
                name = "ISO 8859-3 (1988) to Unicode";
                break;
            }
            case 65540: {
                name = "ISO 8859-4 (1988) to Unicode";
                break;
            }
            case 65541: {
                name = "ISO 8859-5 (1988) to Unicode";
                break;
            }
            case 65543: {
                name = "ISO 8859-7 (1987) to Unicode";
                break;
            }
            case 65545: {
                name = "ISO 8859-9 (1989) to Unicode";
                break;
            }
            case 65568: {
                name = "PCS to Unicode";
                break;
            }
        }
        for (int i = 0; i < CharMapDatabaseInit.charMapInfoArraySize_; ++i) {
            if (!CharMapDatabaseInit.charMapInfoArray_[i].name.equals(name)) continue;
            return CharMapDatabaseInit.charMapInfoArray_[i];
        }
        return null;
    }

    static {
        database_ = new CharMapDatabaseInit();
    }
}

