/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeConverters;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetDatabase;
import com.crystaldecisions.thirdparty.com.ooc.OB.CodeSetIORInterceptor_impl;
import com.crystaldecisions.thirdparty.com.ooc.OB.PIManager;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetComponent;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetComponentInfo;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetComponentInfoHolder;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetContextHelper;
import com.crystaldecisions.thirdparty.org.omg.CONV_FRAME.CodeSetContextHolder;
import com.crystaldecisions.thirdparty.org.omg.CORBA.DATA_CONVERSION;
import com.crystaldecisions.thirdparty.org.omg.IOP.ServiceContext;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedComponent;
import com.crystaldecisions.thirdparty.org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import java.util.Enumeration;
import java.util.Vector;

public final class CodeSetUtil {
    private static int native_cs_ = 65537;
    private static int native_wcs_ = 65801;
    private static int default_wcs_ = 0;
    private static Vector supportedCharCodeSets_ = new Vector();
    private static Vector supportedWcharCodeSets_ = new Vector();

    static int native_cs() {
        return native_cs_;
    }

    public static void native_cs(int id) {
        native_cs_ = id;
    }

    static int native_wcs() {
        return native_wcs_;
    }

    public static void native_wcs(int id) {
        native_wcs_ = id;
    }

    public static void default_wcs(int id) {
        default_wcs_ = id;
    }

    static void addCharCodeSet(int id) {
        supportedCharCodeSets_.addElement(new Integer(id));
    }

    static void addWcharCodeSet(int id) {
        supportedCharCodeSets_.addElement(new Integer(id));
        supportedWcharCodeSets_.addElement(new Integer(id));
    }

    static CodeSetComponentInfo createCodeSetComponentInfo() {
        CodeSetComponent c = CodeSetUtil.createCharCodeSetComponent(native_cs_);
        CodeSetComponent wc = CodeSetUtil.createWcharCodeSetComponent(native_wcs_);
        return new CodeSetComponentInfo(c, wc);
    }

    static CodeSetComponent createCharCodeSetComponent(int id) {
        CodeSetDatabase.instance();
        CodeSetComponent codeSetComponent = new CodeSetComponent();
        codeSetComponent.native_code_set = id;
        Vector<Integer> conversion_code_sets = new Vector<Integer>();
        Enumeration e = supportedCharCodeSets_.elements();
        while (e.hasMoreElements()) {
            Integer cs = (Integer)e.nextElement();
            if (cs == id) continue;
            conversion_code_sets.addElement(cs);
        }
        codeSetComponent.conversion_code_sets = new int[conversion_code_sets.size()];
        e = conversion_code_sets.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            codeSetComponent.conversion_code_sets[i++] = (Integer)e.nextElement();
        }
        return codeSetComponent;
    }

    static CodeSetComponent createWcharCodeSetComponent(int id) {
        CodeSetDatabase.instance();
        CodeSetComponent codeSetComponent = new CodeSetComponent();
        codeSetComponent.native_code_set = id;
        Vector<Integer> conversion_code_sets = new Vector<Integer>();
        Enumeration e = supportedWcharCodeSets_.elements();
        while (e.hasMoreElements()) {
            Integer cs = (Integer)e.nextElement();
            if (cs == id) continue;
            conversion_code_sets.addElement(cs);
        }
        codeSetComponent.conversion_code_sets = new int[conversion_code_sets.size()];
        e = conversion_code_sets.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            codeSetComponent.conversion_code_sets[i++] = (Integer)e.nextElement();
        }
        return codeSetComponent;
    }

    static boolean getCodeSetInfoFromComponents(ProfileInfo profileInfo, CodeSetComponentInfoHolder info) {
        if (profileInfo.major == 1 && profileInfo.minor == 0) {
            return false;
        }
        for (int i = 0; i < profileInfo.components.length; ++i) {
            if (!CodeSetUtil.checkForCodeSetInfo(profileInfo.components[i], info)) continue;
            return true;
        }
        return false;
    }

    static CodeConverters getCodeConverters(ProfileInfo profileInfo) {
        CodeSetComponentInfoHolder serverInfo = new CodeSetComponentInfoHolder();
        serverInfo.value = new CodeSetComponentInfo();
        serverInfo.value.ForCharData = new CodeSetComponent();
        serverInfo.value.ForWcharData = new CodeSetComponent();
        serverInfo.value.ForCharData.native_code_set = 65537;
        serverInfo.value.ForCharData.conversion_code_sets = new int[0];
        serverInfo.value.ForWcharData.native_code_set = default_wcs_;
        serverInfo.value.ForWcharData.conversion_code_sets = new int[0];
        CodeSetUtil.getCodeSetInfoFromComponents(profileInfo, serverInfo);
        CodeSetDatabase db = CodeSetDatabase.instance();
        CodeConverters conv = new CodeConverters();
        CodeSetComponent client_cs = CodeSetUtil.createCharCodeSetComponent(CodeSetUtil.native_cs());
        int tcs_c = db.determineTCS(client_cs, serverInfo.value.ForCharData, 0x5010001);
        conv.inputCharConverter = db.getConverter(CodeSetUtil.native_cs(), tcs_c);
        conv.outputCharConverter = db.getConverter(tcs_c, CodeSetUtil.native_cs());
        CodeSetComponent client_wcs = CodeSetUtil.createWcharCodeSetComponent(CodeSetUtil.native_wcs());
        int tcs_wc = db.determineTCS(client_wcs, serverInfo.value.ForWcharData, 65801);
        conv.wcharConverter = db.getConverter(tcs_wc, CodeSetUtil.native_wcs());
        return conv;
    }

    static boolean checkForCodeSetInfo(TaggedComponent comp, CodeSetComponentInfoHolder info) {
        if (comp.tag == 1) {
            byte[] coct = comp.component_data;
            Buffer buf = new Buffer(coct, coct.length);
            InputStream in = new InputStream(buf, 0, false, null, false);
            in._OB_readEndian();
            info.value = CodeSetComponentInfoHelper.read(in);
            return true;
        }
        return false;
    }

    static void extractCodeSetContext(ServiceContext context, CodeSetContextHolder ctx) {
        byte[] coct = context.context_data;
        Buffer buf = new Buffer(coct, coct.length);
        InputStream in = new InputStream(buf, 0, false, null, false);
        in._OB_readEndian();
        ctx.value = CodeSetContextHelper.read(in);
    }

    static void unicodeToUtf8(OutputStream out, char value) throws DATA_CONVERSION {
        int len;
        int first;
        if (value < 128) {
            first = value;
            len = 1;
        } else if (value < 2047) {
            first = 192;
            len = 2;
        } else if (value < 65535) {
            first = 224;
            len = 3;
        } else {
            throw new DATA_CONVERSION();
        }
        while (len > 1) {
            out.buf_.data_[out.buf_.pos_ + --len] = (byte)(0x80 | value & 0x3F);
            value = (char)(value >> 6);
        }
        first = (char)(first | value);
        out.buf_.data_[out.buf_.pos_] = (byte)first;
    }

    static char utf8ToUnicode(InputStream in) throws DATA_CONVERSION {
        char value;
        int rem;
        byte first;
        if (((first = in.buf_.data_[in.buf_.pos_++]) & 0x80) == 0) {
            return (char)first;
        }
        if ((first & 0xE0) == 192) {
            rem = 1;
            value = (char)(first & 0x1F);
        } else if ((first & 0xF0) == 224) {
            rem = 2;
            value = (char)(first & 0xF);
        } else if ((first & 0xF8) == 240) {
            rem = 3;
            value = (char)(first & 7);
        } else if ((first & 0xFC) == 248) {
            rem = 4;
            value = (char)(first & 3);
        } else if ((first & 0xFE) == 252) {
            rem = 5;
            value = (char)(first & 1);
        } else {
            throw new DATA_CONVERSION();
        }
        if (rem >= 3) {
            throw new DATA_CONVERSION();
        }
        while (rem != 0) {
            if ((in.buf_.data_[in.buf_.pos_] & 0xC0) != 128) {
                throw new DATA_CONVERSION();
            }
            value = (char)(value << 6);
            value = (char)(value | in.buf_.data_[in.buf_.pos_++] & 0x3F);
            --rem;
        }
        return value;
    }

    public static void registerIORInterceptor(PIManager manager) {
        try {
            manager.addIORInterceptor(new CodeSetIORInterceptor_impl());
        }
        catch (DuplicateName ex) {
            Assert.assertTrue(false);
        }
    }
}

