/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.Downcall;
import com.crystaldecisions.thirdparty.com.ooc.OB.Util;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.Vector;

final class DowncallManager {
    private Vector unsent_ = new Vector();
    private Vector pending_ = new Vector();
    private SystemException exception_ = null;

    DowncallManager() {
    }

    int unsentCount() {
        return this.unsent_.size();
    }

    int pendingCount() {
        return this.pending_.size();
    }

    void addUnsent(Buffer buf) {
        this.unsent_.addElement(new UnsentMessage(buf));
    }

    void addUnsent(Downcall down) {
        if (this.exception_ != null) {
            down.setFailureException(this.exception_);
            return;
        }
        this.unsent_.addElement(new UnsentMessage(down));
    }

    Buffer getFirstUnsentBuffer() {
        if (this.unsent_.size() > 0) {
            return ((UnsentMessage)this.unsent_.firstElement()).buf;
        }
        return null;
    }

    Downcall getFirstUnsentDowncall() {
        if (this.unsent_.size() > 0) {
            return ((UnsentMessage)this.unsent_.firstElement()).down;
        }
        return null;
    }

    void moveFirstUnsentToPending() {
        if (this.unsent_.size() == 0) {
            Assert.assertTrue(this.exception_ != null);
            return;
        }
        Downcall down = ((UnsentMessage)this.unsent_.firstElement()).down;
        this.unsent_.removeElementAt(0);
        if (down != null) {
            if (down.responseExpected()) {
                down.setPending();
                this.pending_.insertElementAt(down, 0);
            } else {
                down.setNoException(null);
            }
        }
    }

    Downcall findAndRemovePending(int reqId) {
        int i;
        Downcall downcall = null;
        for (i = 0; i < this.pending_.size() && (downcall = (Downcall)this.pending_.elementAt(i)).requestId() != reqId; ++i) {
        }
        if (i >= this.pending_.size()) {
            return null;
        }
        this.pending_.removeElementAt(i);
        return downcall;
    }

    void setFailureException(SystemException ex, boolean notCompleted) {
        if (this.exception_ != null) {
            return;
        }
        this.exception_ = Util.copySystemException(ex);
        this.exception_.fillInStackTrace();
        this.exception_.completed = CompletionStatus.COMPLETED_NO;
        for (int i = 0; i < this.unsent_.size(); ++i) {
            Downcall down = ((UnsentMessage)this.unsent_.elementAt((int)i)).down;
            if (down == null) continue;
            down.setFailureException(this.exception_);
        }
        this.unsent_.removeAllElements();
        SystemException except = Util.copySystemException(this.exception_);
        except.fillInStackTrace();
        if (!notCompleted) {
            except.completed = CompletionStatus.COMPLETED_MAYBE;
        }
        for (int i = 0; i < this.pending_.size(); ++i) {
            Downcall downcall = (Downcall)this.pending_.elementAt(i);
            downcall.setFailureException(except);
        }
        this.pending_.removeAllElements();
    }

    SystemException getFailureException() {
        return this.exception_;
    }

    private static class UnsentMessage {
        Buffer buf;
        Downcall down;

        UnsentMessage() {
        }

        UnsentMessage(UnsentMessage msg) {
            this.buf = msg.buf;
            this.down = msg.down;
        }

        UnsentMessage(Buffer b) {
            this.buf = b;
            this.buf.pos(0);
        }

        UnsentMessage(Downcall d) {
            this.down = d;
            this.buf = d.output()._OB_buffer();
            this.buf.pos(0);
        }
    }
}

