/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.CoreTraceLevels;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPServerWorker;
import com.crystaldecisions.thirdparty.com.ooc.OB.OAInterface;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Acceptor;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AcceptorInfo;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.Vector;

abstract class GIOPServerStarter {
    protected ORBInstance orbInstance_;
    protected Acceptor acceptor_;
    protected OAInterface oaInterface_;
    protected Vector workers_ = new Vector();
    public static final int StateActive = 0;
    public static final int StateHolding = 1;
    public static final int StateClosed = 2;
    protected int state_;

    protected void finalize() throws Throwable {
        Assert.assertTrue(this.state_ == 2);
        super.finalize();
    }

    protected void logCloseAcceptor() {
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            AcceptorInfo info = this.acceptor_.get_info();
            String msg = "stopped accepting connections\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("incoming", msg);
        }
    }

    GIOPServerStarter(ORBInstance orbInstance, Acceptor acceptor, OAInterface oaInterface) {
        this.orbInstance_ = orbInstance;
        this.acceptor_ = acceptor;
        this.oaInterface_ = oaInterface;
        this.state_ = 1;
        try {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                AcceptorInfo info = this.acceptor_.get_info();
                String msg = "accepting connections\n";
                msg = msg + info.describe();
                this.orbInstance_.getLogger().trace("incoming", msg);
            }
            this.acceptor_.listen();
        }
        catch (SystemException ex) {
            this.acceptor_.close();
            this.state_ = 2;
            throw ex;
        }
    }

    public abstract void setState(int var1);

    public synchronized void removeWorker(GIOPServerWorker worker) {
        for (int i = 0; i < this.workers_.size(); ++i) {
            if (this.workers_.elementAt(i) != worker) continue;
            this.workers_.removeElementAt(i);
            return;
        }
    }
}

