/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPServerStarter;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPServerWorker;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPServerWorkerThreaded;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.OAInterface;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Acceptor;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.IMP_LIMIT;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_PERMISSION;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import java.util.Vector;

final class GIOPServerStarterThreaded
extends GIOPServerStarter {
    protected Thread starterThread_;

    GIOPServerStarterThreaded(ORBInstance orbInstance, Acceptor acceptor, OAInterface oaInterface) {
        super(orbInstance, acceptor, oaInterface);
        try {
            ThreadGroup group = this.orbInstance_.getServerWorkerGroup();
            this.starterThread_ = new StarterThread(group, this);
            String isclientapp = orbInstance.getProperties().getProperty("com.businessobjects.enterprise.isclientapp");
            if (isclientapp != null && isclientapp.equalsIgnoreCase("TRUE")) {
                this.starterThread_.setDaemon(true);
            }
            this.starterThread_.start();
        }
        catch (OutOfMemoryError ex) {
            this.acceptor_.close();
            this.state_ = 2;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int state) {
        Vector workers = null;
        GIOPServerStarterThreaded gIOPServerStarterThreaded = this;
        synchronized (gIOPServerStarterThreaded) {
            if (this.state_ == state) {
                return;
            }
            if (this.state_ != 1 && state < this.state_) {
                return;
            }
            switch (state) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    try {
                        Transport tr = this.acceptor_.connect_self();
                        tr.close();
                        break;
                    }
                    catch (SystemException ex) {
                        // empty catch block
                    }
                }
            }
            this.state_ = state;
            this.notifyAll();
            workers = (Vector)this.workers_.clone();
        }
        block14: for (int i = 0; i < workers.size(); ++i) {
            GIOPServerWorker w = (GIOPServerWorker)workers.elementAt(i);
            switch (this.state_) {
                case 0: {
                    w.setState(0);
                    continue block14;
                }
                case 1: {
                    w.setState(1);
                    continue block14;
                }
                case 2: {
                    w.setState(2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void starterRun() {
        while (this.state_ != 2) {
            Transport transport = null;
            try {
                transport = this.acceptor_.accept(true);
                Assert.assertTrue(transport != null);
            }
            catch (NO_PERMISSION ex) {
            }
            catch (SystemException ex) {
                // empty catch block
            }
            if (transport == null) continue;
            GIOPServerWorkerThreaded worker = null;
            GIOPServerStarterThreaded gIOPServerStarterThreaded = this;
            synchronized (gIOPServerStarterThreaded) {
                while (this.state_ == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                try {
                    worker = new GIOPServerWorkerThreaded(this.orbInstance_, this, transport, this.oaInterface_);
                    this.workers_.addElement(worker);
                }
                catch (SystemException ex) {
                    String msg = "can't accept connection\n" + ex.getMessage();
                    this.orbInstance_.getLogger().warning(msg);
                }
            }
            if (worker == null) continue;
            switch (this.state_) {
                case 0: {
                    ((GIOPServerWorker)worker).setState(0);
                    break;
                }
                case 1: {
                    ((GIOPServerWorker)worker).setState(1);
                    break;
                }
                case 2: {
                    ((GIOPServerWorker)worker).setState(2);
                }
            }
        }
    }

    protected final class StarterThread
    extends Thread {
        private GIOPServerStarterThreaded starter_;

        StarterThread(ThreadGroup group, GIOPServerStarterThreaded starter) {
            super(group, "ORBacus:Server:StarterThread");
            this.starter_ = starter;
        }

        public void run() {
            try {
                this.starter_.starterRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert.assertTrue(false);
            }
            while (true) {
                Transport transport = null;
                try {
                    transport = this.starter_.acceptor_.accept(false);
                }
                catch (SystemException ex) {
                    // empty catch block
                }
                if (transport == null) break;
                try {
                    GIOPServerWorkerThreaded worker = new GIOPServerWorkerThreaded(this.starter_.orbInstance_, this.starter_, transport, this.starter_.oaInterface_);
                    this.starter_.workers_.addElement(worker);
                    ((GIOPServerWorker)worker).setState(2);
                }
                catch (SystemException systemException) {}
            }
            this.starter_.logCloseAcceptor();
            this.starter_.acceptor_.close();
            this.starter_ = null;
        }
    }
}

