/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPServerStarterThreaded;
import com.crystaldecisions.thirdparty.com.ooc.OB.GIOPServerWorker;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.OAInterface;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.Upcall;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Transport;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.IMP_LIMIT;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;

final class GIOPServerWorkerThreaded
extends GIOPServerWorker {
    protected Thread senderThread_;
    protected Thread receiverThread_;

    protected void add(Buffer buf) {
        super.add(buf);
        this.notifyAll();
    }

    protected boolean setStateNoSync(int state) {
        if (!super.setStateNoSync(state)) {
            return false;
        }
        this.notifyAll();
        return true;
    }

    GIOPServerWorkerThreaded(ORBInstance orbInstance, GIOPServerStarterThreaded starter, Transport transport, OAInterface oaInterface) {
        super(orbInstance, starter, transport, oaInterface);
        try {
            ThreadGroup group = this.orbInstance_.getServerWorkerGroup();
            this.senderThread_ = new SenderThread(group, this);
            this.senderThread_.start();
            this.receiverThread_ = new ReceiverThread(group, this);
            this.receiverThread_.start();
        }
        catch (OutOfMemoryError ex) {
            this.transport_.close();
            this.state_ = 4;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized boolean setState(int state) {
        return this.setStateNoSync(state);
    }

    public synchronized void upcallEndReply(Upcall upcall) {
        this.addUpcall(upcall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void senderRun() {
        block10: while (true) {
            Buffer buf = null;
            GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this;
            synchronized (gIOPServerWorkerThreaded) {
                while (true) {
                    long current;
                    if (this.state_ == 4) {
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 2 && this.upcallCount_ == 0) {
                        this.logCloseConnection();
                        this.transport_.shutdown();
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 3) {
                        this.setStateNoSync(4);
                        return;
                    }
                    if (!this.unsent_.isEmpty()) {
                        buf = (Buffer)this.unsent_.firstElement();
                        this.unsent_.removeElementAt(0);
                        // MONITOREXIT @DISABLED, blocks:[18, 5, 10, 11] lbl22 : MonitorExitStatement: MONITOREXIT : var2_2
                        try {
                            if (!this.transport_.send_detect(buf, true)) {
                                gIOPServerWorkerThreaded = this;
                                synchronized (gIOPServerWorkerThreaded) {
                                    this.setStateNoSync(4);
                                    return;
                                }
                            }
                            Assert.assertTrue(buf.is_full());
                            continue block10;
                        }
                        catch (SystemException ex) {
                            GIOPServerWorkerThreaded gIOPServerWorkerThreaded2 = this;
                            synchronized (gIOPServerWorkerThreaded2) {
                                this.exception(4, ex);
                                return;
                            }
                        }
                    }
                    if (this.acmTimeout_ > 0 && this.upcallCount_ == 0 && (current = System.currentTimeMillis() / 1000L) >= this.timestamp_ + (long)this.acmTimeout_) {
                        this.setStateNoSync(2);
                        continue;
                    }
                    try {
                        if (this.acmTimeout_ > 0 && this.upcallCount_ == 0) {
                            this.wait(this.acmTimeout_ * 1000);
                            continue;
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiverRun() {
        while (true) {
            GIOPServerWorkerThreaded gIOPServerWorkerThreaded;
            Assert.assertTrue(this.buf_ == null);
            this.buf_ = new Buffer(12);
            try {
                if (!this.transport_.receive_detect(this.buf_, true)) {
                    GIOPServerWorkerThreaded gIOPServerWorkerThreaded2 = this;
                    synchronized (gIOPServerWorkerThreaded2) {
                        this.setStateNoSync(4);
                        return;
                    }
                }
                Assert.assertTrue(this.buf_.is_full());
            }
            catch (SystemException ex) {
                gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(4, ex);
                    return;
                }
            }
            try {
                this.incoming_.extractHeader(this.buf_);
                this.buf_.realloc(12 + this.incoming_.size());
            }
            catch (SystemException ex) {
                gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(3, ex);
                    return;
                }
            }
            if (!this.buf_.is_full()) {
                try {
                    if (!this.transport_.receive_detect(this.buf_, true)) {
                        GIOPServerWorkerThreaded ex = this;
                        synchronized (ex) {
                            this.setStateNoSync(4);
                            return;
                        }
                    }
                    Assert.assertTrue(this.buf_.is_full());
                }
                catch (SystemException ex) {
                    gIOPServerWorkerThreaded = this;
                    synchronized (gIOPServerWorkerThreaded) {
                        this.exception(4, ex);
                        return;
                    }
                }
            }
            Upcall upcall = null;
            gIOPServerWorkerThreaded = this;
            synchronized (gIOPServerWorkerThreaded) {
                while (this.state_ == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.state_ != 0 && this.state_ != 2) {
                    return;
                }
                upcall = this.execute();
            }
            if (upcall == null) continue;
            upcall.invoke();
        }
    }

    protected static final class ReceiverThread
    extends Thread {
        private GIOPServerWorkerThreaded worker_;

        ReceiverThread(ThreadGroup group, GIOPServerWorkerThreaded worker) {
            super(group, "ORBacus:Server:ReceiverThread");
            this.worker_ = worker;
        }

        public void run() {
            try {
                this.worker_.receiverRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert.assertTrue(false);
            }
            this.worker_ = null;
        }
    }

    protected static final class SenderThread
    extends Thread {
        private GIOPServerWorkerThreaded worker_;

        SenderThread(ThreadGroup group, GIOPServerWorkerThreaded worker) {
            super(group, "ORBacus:Server:SenderThread");
            this.worker_ = worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.worker_.senderRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert.assertTrue(false);
            }
            while (true) {
                try {
                    if (this.worker_.shutdownTimeout_ > 0) {
                        this.worker_.receiverThread_.join(this.worker_.shutdownTimeout_ * 1000);
                        break;
                    }
                    this.worker_.receiverThread_.join();
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
            GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this.worker_;
            synchronized (gIOPServerWorkerThreaded) {
                this.worker_.setStateNoSync(4);
            }
            this.worker_ = null;
        }
    }
}

