/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.LocalObject;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.ObjectFactory;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INV_POLICY;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORBPackage.InvalidName;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Object;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Policy;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SetOverrideType;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class InitialServiceManager {
    private Hashtable services_ = new Hashtable(37);
    private String defaultInitRef_;
    private boolean destroy_ = false;
    private ORBInstance orbInstance_;

    protected void finalize() throws Throwable {
        Assert.assertTrue(this.destroy_);
        super.finalize();
    }

    synchronized void destroy() {
        Assert.assertTrue(!this.destroy_);
        this.destroy_ = true;
        this.services_ = null;
        this.orbInstance_ = null;
    }

    public void setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.default_init_ref");
        this.defaultInitRef_ = value == null ? "" : value;
        String propRoot = "ooc.orb.service.";
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(propRoot)) continue;
            value = properties.getProperty(key);
            Assert.assertTrue(value != null);
            key = key.substring(propRoot.length());
            try {
                this.addInitialReference(key, value, true);
            }
            catch (InvalidName ex) {
                Assert.assertTrue(false);
            }
        }
    }

    public synchronized String[] listInitialServices() {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        String[] list = new String[this.services_.size()];
        int i = 0;
        Enumeration e = this.services_.keys();
        while (e.hasMoreElements()) {
            list[i++] = (String)e.nextElement();
        }
        return list;
    }

    public synchronized Object resolveInitialReferences(String identifier) throws InvalidName {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assertTrue(identifier != null);
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        Object obj = null;
        Service svc = (Service)this.services_.get(identifier);
        if (svc != null) {
            if (svc.obj != null) {
                obj = svc.obj;
            } else if (svc.ref.length() > 0) {
                svc.obj = obj = objectFactory.stringToObject(svc.ref);
                this.services_.put(identifier, svc);
            }
        }
        if (obj == null && this.defaultInitRef_.length() > 0 && !this.services_.containsKey(identifier)) {
            String url = this.defaultInitRef_ + '/' + identifier;
            obj = objectFactory.stringToObject(url);
        }
        if (obj == null) {
            throw new InvalidName();
        }
        if (obj instanceof LocalObject) {
            return obj;
        }
        Policy[] orbPolicies = objectFactory.policies();
        Vector<Policy> vec = new Vector<Policy>();
        for (int i = 0; i < orbPolicies.length; ++i) {
            Policy policy = null;
            try {
                policy = obj._get_policy(orbPolicies[i].policy_type());
            }
            catch (INV_POLICY ex) {
                // empty catch block
            }
            if (policy == null) {
                policy = orbPolicies[i];
            }
            vec.addElement(policy);
        }
        java.lang.Object[] p = new Policy[vec.size()];
        vec.copyInto(p);
        return obj._set_policy_override((Policy[])p, SetOverrideType.SET_OVERRIDE);
    }

    public void addInitialReference(String name, Object obj) throws InvalidName {
        this.addInitialReference(name, obj, false);
    }

    public synchronized void addInitialReference(String name, String iorString, boolean override) throws InvalidName {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assertTrue(name != null && iorString != null);
        if (this.services_.containsKey(name) && !override) {
            throw new InvalidName();
        }
        Service svc = new Service();
        svc.ref = iorString;
        this.services_.put(name, svc);
    }

    public synchronized void addInitialReference(String name, Object p, boolean override) throws InvalidName {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assertTrue(name != null);
        if (this.services_.containsKey(name) && !override) {
            throw new InvalidName();
        }
        Service svc = new Service();
        svc.ref = "";
        svc.obj = p;
        this.services_.put(name, svc);
    }

    private class Service {
        String ref;
        Object obj;

        private Service() {
        }
    }
}

