/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Logger;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import java.util.Hashtable;
import java.util.Vector;

public final class OptionFilter {
    private String errorPrefix_;
    private String optionPrefix_;
    private Hashtable argTable_ = new Hashtable();

    public OptionFilter(String errorPrefix, String optionPrefix) {
        this.errorPrefix_ = errorPrefix;
        this.optionPrefix_ = optionPrefix;
    }

    public void add(String option, int nrOfArgs) {
        this.argTable_.put(option, new Integer(nrOfArgs));
    }

    public Option[] parse(Logger logger, String[] args) {
        Vector<Option> options = new Vector<Option>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(this.optionPrefix_)) continue;
            String option = args[i].substring(this.optionPrefix_.length());
            Integer nrOfArgs = (Integer)this.argTable_.get(option);
            if (nrOfArgs != null) {
                int n = nrOfArgs;
                String[] value = new String[n];
                try {
                    for (int j = 0; j < n; ++j) {
                        value[j] = args[++i];
                    }
                    options.addElement(new Option(option, value));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    String err = this.errorPrefix_ + ": argument expected for `" + this.optionPrefix_ + option + "'";
                    logger.error(err);
                    throw new INITIALIZE(err);
                }
            }
            logger.warning(this.errorPrefix_ + ": unknown option: `" + this.optionPrefix_ + option + "'");
        }
        Object[] result = new Option[options.size()];
        options.copyInto(result);
        return result;
    }

    public String[] filter(String[] args) {
        Vector<String> unknown = new Vector<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(this.optionPrefix_)) {
                Integer nrOfArgs = (Integer)this.argTable_.get(args[i].substring(this.optionPrefix_.length()));
                if (nrOfArgs == null) continue;
                i += nrOfArgs.intValue();
                continue;
            }
            unknown.addElement(args[i]);
        }
        Object[] rem = new String[unknown.size()];
        unknown.copyInto(rem);
        return rem;
    }

    public class Option {
        public String name;
        public String[] value;

        public Option(String n, String[] v) {
            this.name = n;
            this.value = v;
        }
    }
}

