/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.org.omg.CORBA.Any;
import com.crystaldecisions.thirdparty.org.omg.CORBA.NO_IMPLEMENT;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StructMember;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TCKind;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TypeCode;
import com.crystaldecisions.thirdparty.org.omg.CORBA.UnionMember;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ValueMember;

public final class TypeCodeFactory {
    private static TypeCode[] primitives_ = new TypeCode[33];

    private TypeCodeFactory() {
    }

    public static TypeCode createPrimitiveTC(TCKind kind) {
        Assert.assertTrue(kind.value() < primitives_.length);
        if (primitives_[kind.value()] != null) {
            return primitives_[kind.value()];
        }
        TypeCode tc = null;
        if (kind == TCKind.tk_null || kind == TCKind.tk_void || kind == TCKind.tk_short || kind == TCKind.tk_long || kind == TCKind.tk_ushort || kind == TCKind.tk_ulong || kind == TCKind.tk_float || kind == TCKind.tk_double || kind == TCKind.tk_boolean || kind == TCKind.tk_char || kind == TCKind.tk_octet || kind == TCKind.tk_any || kind == TCKind.tk_TypeCode || kind == TCKind.tk_Principal || kind == TCKind.tk_string || kind == TCKind.tk_longlong || kind == TCKind.tk_ulonglong || kind == TCKind.tk_longdouble || kind == TCKind.tk_wchar || kind == TCKind.tk_wstring || kind == TCKind.tk_fixed) {
            com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode p = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
            p.kind_ = kind;
            p.length_ = 0;
            tc = p;
        } else if (kind == TCKind.tk_objref) {
            tc = TypeCodeFactory.createInterfaceTC("IDL:omg.org/CORBA/Object:1.0", "Object");
        } else if (kind == TCKind.tk_value) {
            tc = TypeCodeFactory.createValueTC("IDL:omg.org/CORBA/ValueBase:1.0", "ValueBase", (short)2, null, new ValueMember[0]);
        } else {
            Assert.assertTrue(false);
        }
        TypeCodeFactory.primitives_[kind.value()] = tc;
        return tc;
    }

    public static TypeCode createStructTC(String id, String name, StructMember[] members) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_struct;
        tc.id_ = id;
        tc.name_ = name;
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.memberNames_[i] = members[i].name;
            tc.memberTypes_[i] = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)members[i].type;
        }
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static TypeCode createUnionTC(String id, String name, TypeCode discriminator_type, UnionMember[] members) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_union;
        tc.id_ = id;
        tc.name_ = name;
        tc.discriminatorType_ = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)discriminator_type;
        tc.labels_ = new Any[members.length];
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.labels_[i] = members[i].label;
            tc.memberNames_[i] = members[i].name;
            tc.memberTypes_[i] = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)members[i].type;
        }
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static TypeCode createEnumTC(String id, String name, String[] members) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_enum;
        tc.id_ = id;
        tc.name_ = name;
        tc.memberNames_ = new String[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.memberNames_[i] = members[i];
        }
        return tc;
    }

    public static TypeCode createAliasTC(String id, String name, TypeCode original_type) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_alias;
        tc.id_ = id;
        tc.name_ = name;
        tc.contentType_ = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)original_type;
        return tc;
    }

    public static TypeCode createExceptionTC(String id, String name, StructMember[] members) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_except;
        tc.id_ = id;
        tc.name_ = name;
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.memberNames_[i] = members[i].name;
            tc.memberTypes_[i] = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)members[i].type;
        }
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static TypeCode createInterfaceTC(String id, String name) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_objref;
        tc.id_ = id;
        tc.name_ = name;
        return tc;
    }

    public static TypeCode createStringTC(int bound) {
        Assert.assertTrue(bound >= 0);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_string;
        tc.length_ = bound;
        return tc;
    }

    public static TypeCode createWStringTC(int bound) {
        Assert.assertTrue(bound >= 0);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_wstring;
        tc.length_ = bound;
        return tc;
    }

    public static TypeCode createFixedTC(short digits, short scale) {
        Assert.assertTrue(digits >= 0);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_fixed;
        tc.fixedDigits_ = digits;
        tc.fixedScale_ = scale;
        return tc;
    }

    public static TypeCode createSequenceTC(int bound, TypeCode element_type) {
        Assert.assertTrue(bound >= 0);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_sequence;
        tc.length_ = bound;
        tc.contentType_ = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)element_type;
        return tc;
    }

    public static TypeCode createRecursiveSequenceTC(int bound, int offset) {
        throw new NO_IMPLEMENT();
    }

    public static TypeCode createArrayTC(int length, TypeCode element_type) {
        Assert.assertTrue(length >= 0);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_array;
        tc.length_ = length;
        tc.contentType_ = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)element_type;
        return tc;
    }

    public static TypeCode createValueTC(String id, String name, short type_modifier, TypeCode concrete_base, ValueMember[] members) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_value;
        tc.id_ = id;
        tc.name_ = name;
        tc.typeModifier_ = type_modifier;
        tc.concreteBaseType_ = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)concrete_base;
        tc.memberNames_ = new String[members.length];
        tc.memberTypes_ = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode[members.length];
        tc.memberVisibility_ = new short[members.length];
        for (int i = 0; i < members.length; ++i) {
            tc.memberNames_[i] = members[i].name;
            tc.memberTypes_[i] = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)members[i].type;
            tc.memberVisibility_[i] = members[i].access;
        }
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode._OB_embedRecTC(tc);
        return tc;
    }

    public static TypeCode createValueBoxTC(String id, String name, TypeCode boxed_type) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_value_box;
        tc.id_ = id;
        tc.name_ = name;
        tc.contentType_ = (com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode)boxed_type;
        return tc;
    }

    public static TypeCode createNativeTC(String id, String name) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_native;
        tc.id_ = id;
        tc.name_ = name;
        return tc;
    }

    public static TypeCode createRecursiveTC(String id) {
        Assert.assertTrue(id != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.recId_ = id;
        return tc;
    }

    public static TypeCode createAbstractInterfaceTC(String id, String name) {
        Assert.assertTrue(id != null && name != null);
        com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode tc = new com.crystaldecisions.thirdparty.com.ooc.CORBA.TypeCode();
        tc.kind_ = TCKind.tk_abstract_interface;
        tc.id_ = id;
        tc.name_ = name;
        return tc;
    }
}

