/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OB;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.StringValueFactory;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.WStringValueFactory;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.MinorCodes;
import com.crystaldecisions.thirdparty.com.ooc.OB.Util;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_PARAM;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.StringValueHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.WStringValueHelper;
import com.crystaldecisions.thirdparty.org.omg.CORBA.portable.ValueFactory;
import java.util.Hashtable;

public final class ValueFactoryManager {
    private Hashtable factories_ = new Hashtable(1023);
    private Hashtable classFactories_ = new Hashtable(1023);
    private boolean destroy_;

    protected void finalize() throws Throwable {
        Assert.assertTrue(this.destroy_);
        super.finalize();
    }

    synchronized void destroy() {
        Assert.assertTrue(!this.destroy_);
        this.factories_ = null;
    }

    public ValueFactoryManager() {
        this.registerValueFactory(StringValueHelper.id(), new StringValueFactory());
        this.registerValueFactory(WStringValueHelper.id(), new WStringValueFactory());
    }

    public synchronized ValueFactory registerValueFactory(String id, ValueFactory factory) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assertTrue(id != null && factory != null);
        ValueFactory old = (ValueFactory)this.factories_.get(id);
        this.factories_.put(id, factory);
        return old;
    }

    public synchronized void unregisterValueFactory(String id) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assertTrue(id != null);
        if (this.factories_.remove(id) == null) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446337) + ": " + id, 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized ValueFactory lookupValueFactory(String id) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assertTrue(id != null);
        return (ValueFactory)this.factories_.get(id);
    }

    public ValueFactory lookupValueFactoryWithClass(String id) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assertTrue(id != null);
        ValueFactory result = (ValueFactory)this.factories_.get(id);
        if (result != null) {
            return result;
        }
        result = (ValueFactory)this.classFactories_.get(id);
        if (result != null) {
            return result;
        }
        Class c = Util.idToClass(id, "DefaultFactory");
        if (c != null) {
            try {
                result = (ValueFactory)c.newInstance();
                this.classFactories_.put(id, result);
            }
            catch (ClassCastException ex) {
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return result;
    }
}

