/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OBPortableServer;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.LocalObject;
import com.crystaldecisions.thirdparty.com.ooc.IMR.ActiveState;
import com.crystaldecisions.thirdparty.com.ooc.IMR.ActiveStateFactory;
import com.crystaldecisions.thirdparty.com.ooc.IMR.Domain;
import com.crystaldecisions.thirdparty.com.ooc.IMR.DomainHelper;
import com.crystaldecisions.thirdparty.com.ooc.IMR.NoSuchOAD;
import com.crystaldecisions.thirdparty.com.ooc.IMR.NoSuchServer;
import com.crystaldecisions.thirdparty.com.ooc.IMR.OADNotRunning;
import com.crystaldecisions.thirdparty.com.ooc.IMR.ServerStatus;
import com.crystaldecisions.thirdparty.com.ooc.OAD.AlreadyLinked;
import com.crystaldecisions.thirdparty.com.ooc.OAD.ProcessEndpointManagerHolder;
import com.crystaldecisions.thirdparty.com.ooc.OAD.ProcessEndpoint_impl;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.IIOPConfig;
import com.crystaldecisions.thirdparty.com.ooc.OB.IMRActiveStateHolder;
import com.crystaldecisions.thirdparty.com.ooc.OB.InitialServiceManager;
import com.crystaldecisions.thirdparty.com.ooc.OB.LocationForward;
import com.crystaldecisions.thirdparty.com.ooc.OB.Logger;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBControl;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.RefCountPolicyList;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.DirectServant;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POALocator;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManager;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManagerFactory;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManagerFactoryPackage.AcceptorConfig;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManagerFactoryPackage.POAManagerAlreadyExists;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManager_impl;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POA_impl;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AccFactory;
import com.crystaldecisions.thirdparty.com.ooc.OCI.AccFactoryRegistry;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Acceptor;
import com.crystaldecisions.thirdparty.com.ooc.OCI.InvalidParam;
import com.crystaldecisions.thirdparty.com.ooc.OCI.NoSuchFactory;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Param;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_PARAM;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORBPackage.InvalidName;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAManagerPackage.State;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class POAManagerFactory_impl
extends LocalObject
implements POAManagerFactory {
    private ORBInstance orbInstance_;
    private Hashtable managers_ = new Hashtable(7);
    private String serverName_;
    private String serverInstance_;
    private int count_ = 0;
    private boolean needIMR_;
    private IMRActiveStateHolder imrHolder_;
    private POALocator poaLocator_;
    private ProcessEndpoint_impl processEndpoint_;

    private String getUniqueName() {
        long now = System.currentTimeMillis();
        String name = "POAManager-" + now;
        Assert.assertTrue(!this.managers_.containsKey(name = name + this.count_++));
        return name;
    }

    private void validateName(String name) throws POAManagerAlreadyExists {
        POAManager manager = (POAManager)this.managers_.get(name);
        if (manager != null) {
            if (manager.get_state() == State.INACTIVE) {
                this.managers_.remove(name);
            } else {
                throw new POAManagerAlreadyExists();
            }
        }
    }

    public POAManagerFactory_impl(String serverName, String serverInstance) {
        this.serverName_ = serverName;
        this.serverInstance_ = serverInstance;
        this.imrHolder_ = new IMRActiveStateHolder(serverName, serverInstance);
        this.poaLocator_ = new POALocator();
        if (serverName == null) {
            this.serverName_ = "_RootPOA";
            this.needIMR_ = false;
        } else {
            this.needIMR_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POAManager create_poa_manager(String name) throws POAManagerAlreadyExists, InvalidParam {
        Hashtable hashtable = this.managers_;
        synchronized (hashtable) {
            if (name.length() == 0) {
                name = this.getUniqueName();
            } else {
                this.validateName(name);
            }
            Properties props = this.orbInstance_.getProperties();
            Logger logger = this.orbInstance_.getLogger();
            IIOPConfig cfg = new IIOPConfig(props, logger);
            cfg.parseAll(name);
            Param[] params = cfg.getParams();
            Acceptor[] acceptors = null;
            try {
                AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
                AccFactory factory = registry.get_factory(1330577409);
                acceptors = factory.create_acceptors(params);
            }
            catch (NoSuchFactory ex) {
                String err = "unable to create IIOP acceptor";
                logger.error(err);
                throw new INITIALIZE(err);
            }
            POAManager_impl manager = new POAManager_impl(this.orbInstance_, this.imrHolder_, this.poaLocator_, name, this.serverName_, acceptors);
            this.managers_.put(name, manager);
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POAManager create_poa_manager_with_config(String name, AcceptorConfig[] config) throws POAManagerAlreadyExists, NoSuchFactory, InvalidParam {
        Hashtable hashtable = this.managers_;
        synchronized (hashtable) {
            if (name.length() == 0) {
                name = this.getUniqueName();
            } else {
                this.validateName(name);
            }
            AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
            ArrayList<Acceptor> acceptors = new ArrayList<Acceptor>();
            for (int i = 0; i < config.length; ++i) {
                AccFactory factory = registry.get_factory(config[i].id);
                Acceptor[] moreAcceptors = factory.create_acceptors(config[i].params);
                for (int j = 0; j < moreAcceptors.length; ++j) {
                    Acceptor acceptor = moreAcceptors[j];
                    acceptors.add(acceptor);
                }
            }
            POAManager_impl manager = new POAManager_impl(this.orbInstance_, this.imrHolder_, this.poaLocator_, name, this.serverName_, acceptors.toArray(new Acceptor[acceptors.size()]));
            this.managers_.put(name, manager);
            return manager;
        }
    }

    public POAManager[] get_poa_managers() {
        Enumeration e = this.managers_.keys();
        Vector<POAManager> result = new Vector<POAManager>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            POAManager manager = (POAManager)this.managers_.get(name);
            if (manager == null) continue;
            result.addElement(manager);
        }
        Object[] r = new POAManager[result.size()];
        result.copyInto(r);
        return r;
    }

    public void destroy() {
        this.orbInstance_ = null;
        if (this.managers_.size() != 0) {
            this._OB_deactivate();
        }
    }

    public void _OB_deactivate() {
        Enumeration e = this.managers_.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            POAManager manager = (POAManager)this.managers_.get(name);
            if (manager == null) continue;
            try {
                manager.deactivate(true, true);
            }
            catch (AdapterInactive ex) {}
        }
        this.managers_.clear();
        ActiveState as = this.imrHolder_.getActiveState();
        if (as != null) {
            Logger logger = this.orbInstance_.getLogger();
            try {
                as.set_status(this.serverInstance_, ServerStatus.STOPPING);
            }
            catch (SystemException ex) {
                String msg = this.serverName_ + ": Cannot contact IMR on shutdown";
                logger.warning(msg);
            }
            this.imrHolder_.setActiveState(null);
        }
    }

    public DirectServant _OB_getDirectServant(IOR ior, RefCountPolicyList policies) throws LocationForward {
        if (this.managers_.size() == 0) {
            return null;
        }
        Enumeration e = this.managers_.keys();
        while (e.hasMoreElements()) {
            try {
                String name = (String)e.nextElement();
                POAManager_impl manager = (POAManager_impl)this.managers_.get(name);
                if (manager == null) continue;
                Acceptor[] acceptors = manager.get_acceptors();
                for (int i = 0; i < acceptors.length; ++i) {
                    ProfileInfo[] profileInfos = acceptors[i].get_local_profiles(ior);
                    if (profileInfos.length <= 0) continue;
                    return manager._OB_getDirectServant(profileInfos[0].key, policies);
                }
            }
            catch (AdapterInactive ex) {
            }
        }
        return null;
    }

    public void _OB_setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
    }

    public void _OB_initializeIMR(POA_impl root, ORBControl orbControl) {
        if (!this.needIMR_) {
            return;
        }
        this.processEndpoint_ = new ProcessEndpoint_impl(this.serverName_, this.serverInstance_, root, orbControl);
        Domain imrDomain = null;
        try {
            InitialServiceManager initServiceManager = this.orbInstance_.getInitialServiceManager();
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object imrObj = initServiceManager.resolveInitialReferences("IMR");
            imrDomain = DomainHelper.narrow(imrObj);
        }
        catch (InvalidName ex) {
        }
        catch (BAD_PARAM ex) {
            // empty catch block
        }
        Logger logger = this.orbInstance_.getLogger();
        Properties properties = this.orbInstance_.getProperties();
        if (imrDomain == null) {
            String msg = this.serverName_ + ": IMRDomain not reachable";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        String exec = properties.getProperty("com.crystaldecisions.thirdparty.com.ooc.imr.register");
        if (exec != null) {
            String msg = this.serverName_ + ": Self registration not implemented" + " for java servers";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        try {
            ActiveStateFactory factory = imrDomain.get_active_state_factory();
            ActiveState as = factory.get_active_state(this.serverName_);
            this.imrHolder_.setActiveState(as);
            ProcessEndpointManagerHolder endpoint = new ProcessEndpointManagerHolder();
            IOR ior = root._OB_createIOR(new byte[0]);
            as.startup(this.serverInstance_, ior, endpoint);
            this.processEndpoint_._OB_establish_link(endpoint.value, this.orbInstance_.getORB());
        }
        catch (BAD_PARAM ex) {
            String msg = this.serverName_ + ": (IMR) Server already running";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        catch (NoSuchServer ex) {
            String msg = this.serverName_ + ": (IMR) Not registered with IMR";
            logger.error(msg);
            throw new INITIALIZE();
        }
        catch (NoSuchOAD ex) {
            String msg = this.serverName_ + ": (IMR) No OAD for host";
            logger.error(msg);
            throw new INITIALIZE();
        }
        catch (OADNotRunning ex) {
            String msg = this.serverName_ + ": (IMR) OAD not running";
            logger.error(msg);
            throw new INITIALIZE();
        }
        catch (AlreadyLinked ex) {
            String msg = this.serverName_ + ": (IMR) Process registered with OAD";
            logger.error(msg);
            throw new INITIALIZE();
        }
    }
}

