/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OBPortableServer;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.LocalObject;
import com.crystaldecisions.thirdparty.com.ooc.IMR.ActiveState;
import com.crystaldecisions.thirdparty.com.ooc.IMR.POAStatus;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OB.BootManager_impl;
import com.crystaldecisions.thirdparty.com.ooc.OB.CollocatedServer;
import com.crystaldecisions.thirdparty.com.ooc.OB.IMRActiveStateHolder;
import com.crystaldecisions.thirdparty.com.ooc.OB.InitialServiceManager;
import com.crystaldecisions.thirdparty.com.ooc.OB.LocationForward;
import com.crystaldecisions.thirdparty.com.ooc.OB.Logger;
import com.crystaldecisions.thirdparty.com.ooc.OB.OAInterface;
import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OB.ObjectKey;
import com.crystaldecisions.thirdparty.com.ooc.OB.ObjectKeyData;
import com.crystaldecisions.thirdparty.com.ooc.OB.RefCountPolicyList;
import com.crystaldecisions.thirdparty.com.ooc.OB.ServerManager;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.DirectServant;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POALocator;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAManager;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POANameHasher;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAOAInterface_impl;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POA_impl;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Acceptor;
import com.crystaldecisions.thirdparty.com.ooc.PortableServer.Current_impl;
import com.crystaldecisions.thirdparty.org.omg.CORBA.BAD_INV_ORDER;
import com.crystaldecisions.thirdparty.org.omg.CORBA.CompletionStatus;
import com.crystaldecisions.thirdparty.org.omg.CORBA.INITIALIZE;
import com.crystaldecisions.thirdparty.org.omg.CORBA.OBJECT_NOT_EXIST;
import com.crystaldecisions.thirdparty.org.omg.CORBA.ORBPackage.InvalidName;
import com.crystaldecisions.thirdparty.org.omg.CORBA.SystemException;
import com.crystaldecisions.thirdparty.org.omg.CORBA.TRANSIENT;
import com.crystaldecisions.thirdparty.org.omg.GIOP.Version;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POA;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.POAManagerPackage.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class POAManager_impl
extends LocalObject
implements POAManager {
    private ORBInstance orbInstance_;
    private Hashtable poas_;
    private State state_;
    private Acceptor[] acceptors_;
    private ServerManager serverManager_;
    private String name_;
    private String serverName_;
    private IMRActiveStateHolder imrHolder_;
    private POALocator poaLocator_;
    private OAInterface oaInterface_;
    private Version version_ = new Version();
    private BootManager_impl bootManagerImpl_;

    private void waitPendingRequests() {
        boolean inInvocation = false;
        try {
            InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
            com.crystaldecisions.thirdparty.org.omg.CORBA.Object o = initialServiceManager.resolveInitialReferences("POACurrent");
            Current_impl current = (Current_impl)o;
            inInvocation = current._OB_inUpcall();
        }
        catch (InvalidName ex) {
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        if (inInvocation) {
            throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
        }
        Enumeration keys = this.poas_.keys();
        while (keys.hasMoreElements()) {
            POA_impl poaImpl = (POA_impl)this.poas_.get(keys.nextElement());
            poaImpl._OB_waitPendingRequests();
        }
    }

    public synchronized void activate() throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.ACTIVE) {
            this.state_ = State.ACTIVE;
            this.notifyAll();
            this.serverManager_.activate();
            this.oaInterface_.activate();
            this._OB_updateIMR();
        }
        this.imrHolder_.serverRunning(this.orbInstance_);
    }

    public synchronized void hold_requests(boolean waitCompletion) throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.HOLDING) {
            this.state_ = State.HOLDING;
            this.notifyAll();
            this.serverManager_.hold();
            this.oaInterface_.activate();
            if (waitCompletion) {
                this.waitPendingRequests();
            }
            this._OB_updateIMR();
        }
    }

    public synchronized void discard_requests(boolean waitCompletion) throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.DISCARDING) {
            this.state_ = State.DISCARDING;
            this.notifyAll();
            this.oaInterface_.discard();
            if (waitCompletion) {
                this.waitPendingRequests();
            }
            this._OB_updateIMR();
        }
    }

    public synchronized void deactivate(boolean etherealize, boolean waitCompletion) throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.INACTIVE) {
            this.serverManager_.destroy();
            this.state_ = State.INACTIVE;
            this.notifyAll();
            if (etherealize) {
                Enumeration keys = this.poas_.keys();
                while (keys.hasMoreElements()) {
                    POA_impl poaImpl = (POA_impl)this.poas_.get(keys.nextElement());
                    if (poaImpl == null) continue;
                    poaImpl._OB_etherealize();
                }
            }
            this._OB_updateIMR();
        }
    }

    public State get_state() {
        return this.state_;
    }

    public String name() {
        return this.name_;
    }

    public synchronized Acceptor[] get_acceptors() throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        Acceptor[] result = new Acceptor[this.acceptors_.length];
        System.arraycopy(this.acceptors_, 0, result, 0, this.acceptors_.length);
        return result;
    }

    POAManager_impl(ORBInstance orbInstance, IMRActiveStateHolder imrHolder, POALocator poaLocator, String name, String serverName, Acceptor[] acceptors) {
        this.orbInstance_ = orbInstance;
        this.poas_ = new Hashtable(63);
        this.state_ = State.HOLDING;
        this.acceptors_ = acceptors;
        this.name_ = name;
        this.serverName_ = serverName;
        this.imrHolder_ = imrHolder;
        this.poaLocator_ = poaLocator;
        this.oaInterface_ = new POAOAInterface_impl(this, this.serverName_, this.orbInstance_);
        String rootKey = "ooc.orb.poamanager." + this.name_ + ".";
        int rootKeyLen = rootKey.length();
        Logger logger = this.orbInstance_.getLogger();
        Properties properties = orbInstance.getProperties();
        String[] props = new String[]{"conc_model", "host", "numeric", "port", "version"};
        int numProps = props.length;
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            int i;
            String prop;
            String key = (String)keys.nextElement();
            if (key.equals("ooc.orb.oa.thread_pool")) continue;
            if (key.startsWith(rootKey)) {
                prop = key.substring(rootKeyLen);
            } else {
                if (!key.startsWith("ooc.orb.oa.")) continue;
                prop = key.substring(11);
            }
            for (i = 0; i < numProps && !prop.equals(props[i]); ++i) {
            }
            if (i < numProps) continue;
            String err = key + ": unknown property";
            logger.warning(err);
        }
        this.version_.major = 1;
        this.version_.minor = (byte)2;
        int concModel = 2;
        for (int i = 0; i < numProps; ++i) {
            String err;
            String key = props[i];
            String fullkey = rootKey + key;
            String value = properties.getProperty(fullkey);
            if (value == null) {
                fullkey = "ooc.orb.oa." + key;
                value = properties.getProperty(fullkey);
            }
            if (value == null) continue;
            if (key.equals("conc_model")) {
                if (value.equals("threaded")) {
                    concModel = 2;
                    continue;
                }
                if (value.equals("thread_per_client")) {
                    concModel = 2;
                    continue;
                }
                if (value.equals("thread_per_request")) {
                    concModel = 2;
                    continue;
                }
                if (value.equals("thread_pool")) {
                    concModel = 2;
                    continue;
                }
                err = fullkey + ": unknown value";
                logger.warning(err);
                continue;
            }
            if (!key.equals("version")) continue;
            if (value.equals("1.0")) {
                this.version_.major = 1;
                this.version_.minor = 0;
                continue;
            }
            if (value.equals("1.1")) {
                this.version_.major = 1;
                this.version_.minor = 1;
                continue;
            }
            if (value.equals("1.2")) {
                this.version_.major = 1;
                this.version_.minor = (byte)2;
                continue;
            }
            err = fullkey + ": expected `1.0', `1.1' or `1.2'";
            logger.error(err);
            throw new INITIALIZE(err);
        }
        this.serverManager_ = new ServerManager(this.orbInstance_, this.acceptors_, this.oaInterface_, concModel);
        this.bootManagerImpl_ = (BootManager_impl)orbInstance.getBootManager();
    }

    synchronized void _OB_addPOA(POA poa, String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        Assert.assertTrue(!this.poas_.containsKey(idkey));
        this.poas_.put(idkey, poa);
        this.poaLocator_.add(poa, id);
    }

    synchronized void _OB_removePOA(String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        Assert.assertTrue(this.poas_.containsKey(idkey));
        this.poas_.remove(idkey);
        this.poaLocator_.remove(id);
    }

    ActiveState _OB_getIMRActiveState() {
        return this.imrHolder_.getActiveState();
    }

    void _OB_updateIMR() {
        ActiveState as = this.imrHolder_.getActiveState();
        if (as == null) {
            return;
        }
        Vector poas = new Vector();
        Enumeration keys = this.poas_.keys();
        while (keys.hasMoreElements()) {
            POA_impl poaImpl = (POA_impl)this.poas_.get(keys.nextElement());
            if (poaImpl == null) continue;
            poaImpl._OB_isPersistent(poas);
        }
        if (poas.size() > 0) {
            try {
                POAStatus state = null;
                switch (this.state_.value()) {
                    case 3: {
                        state = POAStatus.INACTIVE;
                        break;
                    }
                    case 1: {
                        state = POAStatus.ACTIVE;
                        break;
                    }
                    case 0: {
                        state = POAStatus.HOLDING;
                        break;
                    }
                    case 2: {
                        state = POAStatus.DISCARDING;
                    }
                }
                String[][] arr = new String[poas.size()][];
                poas.copyInto((Object[])arr);
                as.poa_status_update(arr, state);
            }
            catch (SystemException ex) {
                // empty catch block
            }
        }
    }

    synchronized DirectServant _OB_getDirectServant(byte[] key, RefCountPolicyList policies) throws LocationForward, AdapterInactive {
        POA poa;
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        ObjectKeyData data = new ObjectKeyData();
        if (ObjectKey.ParseObjectKey(key, data) && (poa = this._OB_locatePOA(data)) != null) {
            POA_impl poaImpl = (POA_impl)poa;
            return poaImpl._OB_getDirectServant(data.oid, policies);
        }
        IOR ior = this.bootManagerImpl_._OB_locate(key);
        if (ior != null) {
            throw new LocationForward(ior, false);
        }
        throw new OBJECT_NOT_EXIST("No POA for local servant");
    }

    POA _OB_locatePOA(ObjectKeyData data) throws LocationForward {
        POA_impl poaImpl;
        com.crystaldecisions.thirdparty.org.omg.PortableServer.POAManager manager;
        Assert.assertTrue(data.poaID.length != 0);
        Assert.assertTrue(this.get_state() != State.INACTIVE);
        POA poa = (POA)this.poas_.get(new POANameHasher(data.poaID));
        if (poa == null && (poa = this.poaLocator_.locate(data)) != null && (manager = poa.the_POAManager()) != this) {
            POA_impl poaImpl2 = (POA_impl)poa;
            IOR ior = poaImpl2._OB_createIOR(data.oid);
            throw new LocationForward(ior, false);
        }
        if (poa != null && !(poaImpl = (POA_impl)poa)._OB_poaMatches(data)) {
            poa = null;
        }
        return poa;
    }

    public CollocatedServer _OB_getCollocatedServer() {
        return this.serverManager_.getCollocatedServer();
    }

    public synchronized void _OB_validateState() {
        while (this.state_ != State.ACTIVE) {
            if (this.state_ == State.INACTIVE || this.state_ == State.DISCARDING) {
                throw new TRANSIENT("POAManager is inactive or discarding requests", 0, CompletionStatus.COMPLETED_NO);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Version _OB_getGIOPVersion() {
        return new Version(this.version_.major, this.version_.minor);
    }
}

