/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OBPortableServer;

import com.crystaldecisions.thirdparty.com.ooc.OB.ORBInstance;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ActiveObjectOnlyStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.DefaultServantHolder;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.NonRetainStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.POAPolicies;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.RetainStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ServantActivatorStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ServantLocationStrategy;
import com.crystaldecisions.thirdparty.com.ooc.OBPortableServer.ServantLocatorStrategy;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.RequestProcessingPolicyValue;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.ServantRetentionPolicyValue;

class ServantLocationStrategyFactory {
    ServantLocationStrategyFactory() {
    }

    public static ServantLocationStrategy createServantLocationStrategy(POAPolicies policies, ORBInstance orbInstance) {
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
            return new ActiveObjectOnlyStrategy(policies, orbInstance);
        }
        ServantLocatorStrategy servantLocator = null;
        ServantActivatorStrategy servantActivator = null;
        DefaultServantHolder defaultServant = null;
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) {
            defaultServant = new DefaultServantHolder();
        }
        if (policies.requestProcessingPolicy() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
            if (policies.servantRetentionPolicy() == ServantRetentionPolicyValue.RETAIN) {
                servantActivator = new ServantActivatorStrategy();
            } else {
                servantLocator = new ServantLocatorStrategy(orbInstance);
            }
        }
        if (policies.servantRetentionPolicy() == ServantRetentionPolicyValue.RETAIN) {
            return new RetainStrategy(policies, orbInstance, servantActivator, defaultServant);
        }
        return new NonRetainStrategy(servantLocator, defaultServant);
    }
}

