/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OBPortableServer;

import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.org.omg.PortableServer.Servant;

class TableEntry {
    private Servant servant_;
    int ACTIVE = 0;
    int DEACTIVATE_PENDING = 1;
    int DEACTIVATED = 2;
    private int state_;
    private int outstandingRequests_;

    TableEntry(Servant s) {
        this.servant_ = s;
        this.state_ = this.ACTIVE;
        this.outstandingRequests_ = 0;
    }

    void setServant(Servant s) {
        Assert.assertTrue(s != null);
        this.servant_ = s;
    }

    void clearServant() {
        this.servant_ = null;
    }

    Servant getServant() {
        return this.servant_;
    }

    boolean active() {
        return this.state_ == this.ACTIVE;
    }

    void setDeactivatePending() {
        this.state_ = this.DEACTIVATE_PENDING;
    }

    synchronized void setDeactivated() {
        this.state_ = this.DEACTIVATED;
        this.notifyAll();
    }

    synchronized void waitDeactivated() {
        Assert.assertTrue(this.state_ != this.ACTIVE);
        while (this.state_ != this.DEACTIVATED) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    int getOutstandingRequests() {
        return this.outstandingRequests_;
    }

    void incOutstandingRequest() {
        ++this.outstandingRequests_;
    }

    int decOutstandingRequest() {
        return --this.outstandingRequests_;
    }
}

