/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.thirdparty.com.ooc.OCI.IIOP;

import com.crystaldecisions.thirdparty.com.ooc.CORBA.InputStream;
import com.crystaldecisions.thirdparty.com.ooc.CORBA.OutputStream;
import com.crystaldecisions.thirdparty.com.ooc.OB.Assert;
import com.crystaldecisions.thirdparty.com.ooc.OCI.Buffer;
import com.crystaldecisions.thirdparty.com.ooc.OCI.IIOP.InternalError;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfo;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfoHolder;
import com.crystaldecisions.thirdparty.com.ooc.OCI.ProfileInfoSeqHolder;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_0;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_0Helper;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_1;
import com.crystaldecisions.thirdparty.org.omg.IIOP.ProfileBody_1_1Helper;
import com.crystaldecisions.thirdparty.org.omg.IIOP.Version;
import com.crystaldecisions.thirdparty.org.omg.IOP.IOR;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedComponent;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedComponentHelper;
import com.crystaldecisions.thirdparty.org.omg.IOP.TaggedProfile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public final class Util {
    public static IOR createIOR(String host, int port, String id, ProfileInfo profileInfo) {
        IOR ior = new IOR();
        ior.type_id = id;
        ior.profiles = new TaggedProfile[1];
        ior.profiles[0] = new TaggedProfile();
        ior.profiles[0].tag = 0;
        if (profileInfo.major == 1 && profileInfo.minor == 0) {
            ProfileBody_1_0 body = new ProfileBody_1_0();
            body.iiop_version = new Version(1, 0);
            body.host = host;
            body.port = port >= 32768 ? (short)(port - 65535 - 1) : (short)port;
            body.object_key = profileInfo.key;
            Buffer buf = new Buffer();
            OutputStream out = new OutputStream(buf);
            out._OB_writeEndian();
            ProfileBody_1_0Helper.write(out, body);
            ior.profiles[0].profile_data = new byte[buf.length()];
            System.arraycopy(buf.data(), 0, ior.profiles[0].profile_data, 0, buf.length());
        } else {
            ProfileBody_1_1 body = new ProfileBody_1_1();
            body.iiop_version = new Version(profileInfo.major, profileInfo.minor);
            body.host = host;
            body.port = port >= 32768 ? (short)(port - 65535 - 1) : (short)port;
            body.object_key = profileInfo.key;
            body.components = profileInfo.components;
            Buffer buf = new Buffer();
            OutputStream out = new OutputStream(buf);
            out._OB_writeEndian();
            ProfileBody_1_1Helper.write(out, body);
            ior.profiles[0].profile_data = new byte[buf.length()];
            System.arraycopy(buf.data(), 0, ior.profiles[0].profile_data, 0, buf.length());
        }
        return ior;
    }

    public static IOR createIOR(IOR ior, String id, byte[] key) {
        int profile;
        for (profile = 0; profile < ior.profiles.length && ior.profiles[profile].tag != 0; ++profile) {
        }
        Assert.assertTrue(profile < ior.profiles.length);
        Buffer buf = new Buffer(ior.profiles[profile].profile_data, ior.profiles[profile].profile_data.length);
        InputStream in = new InputStream(buf, 0, false, null, false);
        in._OB_readEndian();
        ProfileBody_1_0 body = ProfileBody_1_0Helper.read(in);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.key = key;
        profileInfo.major = body.iiop_version.major;
        profileInfo.minor = body.iiop_version.minor;
        profileInfo.components = new TaggedComponent[0];
        return Util.createIOR(body.host, body.port, id, profileInfo);
    }

    public static boolean extractProfileInfo(IOR ior, ProfileInfoHolder profileInfo) {
        ProfileInfoSeqHolder profileInfoSeq = new ProfileInfoSeqHolder();
        profileInfoSeq.value = new ProfileInfo[0];
        Util.extractAllProfileInfos(ior, profileInfoSeq, false, null, 0, false);
        if (profileInfoSeq.value.length > 0) {
            Assert.assertTrue(profileInfoSeq.value.length == 1);
            profileInfo.value = profileInfoSeq.value[0];
            return true;
        }
        return false;
    }

    public static boolean hostMatch(String host1, String host2, boolean loopbackMatches) {
        block5: {
            if (!host1.equals(host2)) {
                try {
                    InetAddress addr1 = InetAddress.getByName(host1);
                    InetAddress addr2 = InetAddress.getByName(host2);
                    if (addr1.equals(addr2)) break block5;
                    if (loopbackMatches) {
                        InetAddress loopback = InetAddress.getByName("127.0.0.1");
                        if (!addr2.equals(loopback)) {
                            return false;
                        }
                        break block5;
                    }
                    return false;
                }
                catch (UnknownHostException ex) {
                    return false;
                }
            }
        }
        return true;
    }

    public static void extractAllProfileInfos(IOR ior, ProfileInfoSeqHolder profileInfoSeq, boolean performMatch, String host, int port, boolean loopbackMatches) {
        short portNo = port >= 32768 ? (short)(port - 65535 - 1) : (short)port;
        Vector<ProfileInfo> vec = new Vector<ProfileInfo>();
        for (int i = 0; i < ior.profiles.length; ++i) {
            int j;
            TaggedComponent[] components;
            if (ior.profiles[i].tag != 0) continue;
            byte[] data = ior.profiles[i].profile_data;
            Buffer buf = new Buffer(data, data.length);
            InputStream in = new InputStream(buf, 0, false, null, false);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read(in);
            if (body.iiop_version.major > 1 || body.iiop_version.minor > 0) {
                int len = in.read_ulong();
                components = new TaggedComponent[len];
                for (j = 0; j < len; ++j) {
                    components[j] = TaggedComponentHelper.read(in);
                }
            } else {
                components = new TaggedComponent[]{};
            }
            if (performMatch) {
                boolean match = false;
                if (portNo == body.port && Util.hostMatch(host, body.host, loopbackMatches)) {
                    match = true;
                }
                if (!match) {
                    for (j = 0; j < components.length && !match; ++j) {
                        if (components[j].tag != 3) continue;
                        byte[] d = components[j].component_data;
                        Buffer b = new Buffer(d, d.length);
                        InputStream s = new InputStream(b, 0, false, null, false);
                        s._OB_readEndian();
                        String altHost = s.read_string();
                        short altPort = s.read_ushort();
                        if (portNo != altPort || !Util.hostMatch(host, altHost, loopbackMatches)) continue;
                        match = true;
                    }
                }
                if (!match) continue;
            }
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.key = body.object_key;
            profileInfo.minor = body.iiop_version.minor;
            profileInfo.major = body.iiop_version.major;
            profileInfo.id = ior.profiles[i].tag;
            profileInfo.index = i;
            profileInfo.components = components;
            vec.addElement(profileInfo);
        }
        if (vec.size() > 0) {
            int len = profileInfoSeq.value.length;
            if (len == 0) {
                profileInfoSeq.value = new ProfileInfo[vec.size()];
                vec.copyInto(profileInfoSeq.value);
            } else {
                ProfileInfo[] arr = new ProfileInfo[len + vec.size()];
                System.arraycopy(profileInfoSeq.value, 0, arr, 0, len);
                for (int i = 0; i < vec.size(); ++i) {
                    arr[len + i] = (ProfileInfo)vec.elementAt(i);
                }
                profileInfoSeq.value = arr;
            }
        }
    }

    public static boolean equivalent(IOR ior1, IOR ior2) {
        InputStream in;
        Buffer buf;
        byte[] data;
        int p2;
        int p1;
        int cnt1 = 0;
        int cnt2 = 0;
        for (p1 = 0; p1 < ior1.profiles.length; ++p1) {
            if (ior1.profiles[p1].tag != 0) continue;
            ++cnt1;
        }
        for (p2 = 0; p2 < ior2.profiles.length; ++p2) {
            if (ior2.profiles[p2].tag != 0) continue;
            ++cnt2;
        }
        if (cnt1 != cnt2) {
            return false;
        }
        ProfileBody_1_0[] bodies1 = new ProfileBody_1_0[cnt1];
        int b1 = 0;
        for (p1 = 0; p1 < ior1.profiles.length; ++p1) {
            if (ior1.profiles[p1].tag != 0) continue;
            data = ior1.profiles[p1].profile_data;
            buf = new Buffer(data, data.length);
            in = new InputStream(buf, 0, false, null, false);
            in._OB_readEndian();
            bodies1[b1++] = ProfileBody_1_0Helper.read(in);
        }
        if (b1 != cnt1) {
            throw new InternalError();
        }
        ProfileBody_1_0[] bodies2 = new ProfileBody_1_0[cnt2];
        int b2 = 0;
        for (p2 = 0; p2 < ior2.profiles.length; ++p2) {
            if (ior2.profiles[p2].tag != 0) continue;
            data = ior2.profiles[p2].profile_data;
            buf = new Buffer(data, data.length);
            in = new InputStream(buf, 0, false, null, false);
            in._OB_readEndian();
            bodies2[b2++] = ProfileBody_1_0Helper.read(in);
        }
        if (b2 != cnt2) {
            throw new InternalError();
        }
        block4: for (b1 = 0; b1 < cnt1; ++b1) {
            for (b2 = 0; b2 < cnt2; ++b2) {
                if (bodies2[b2] == null || !Util.compareBodies(bodies1[b1], bodies2[b2])) continue;
                bodies1[b1] = null;
                bodies2[b2] = null;
                continue block4;
            }
        }
        for (b1 = 0; b1 < cnt1; ++b1) {
            if (bodies1[b1] == null) continue;
            return false;
        }
        for (b2 = 0; b2 < cnt2; ++b2) {
            if (bodies2[b2] == null) continue;
            return false;
        }
        return true;
    }

    static boolean compareBodies(ProfileBody_1_0 body1, ProfileBody_1_0 body2) {
        if (body1.iiop_version.major != body2.iiop_version.major || body1.iiop_version.minor != body2.iiop_version.minor) {
            return false;
        }
        if (body1.port != body2.port) {
            return false;
        }
        if (body1.object_key.length != body2.object_key.length) {
            return false;
        }
        for (int k = 0; k < body1.object_key.length; ++k) {
            if (body1.object_key[k] == body2.object_key[k]) continue;
            return false;
        }
        if (!body1.host.equals(body2.host)) {
            try {
                InetAddress addr1 = InetAddress.getByName(body1.host);
                InetAddress addr2 = InetAddress.getByName(body2.host);
                if (!addr1.equals(addr2)) {
                    return false;
                }
            }
            catch (UnknownHostException ex) {
                return false;
            }
        }
        return true;
    }

    public static int hash(IOR ior, int maximum) {
        int hash = 0;
        for (int i = 0; i < ior.profiles.length; ++i) {
            if (ior.profiles[i].tag != 0) continue;
            byte[] data = ior.profiles[i].profile_data;
            Buffer buf = new Buffer(data, data.length);
            InputStream in = new InputStream(buf, 0, false, null, false);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read(in);
            hash ^= body.port;
            int j = 0;
            while (j + 1 < body.object_key.length) {
                hash ^= body.object_key[j + 1] * 256 + body.object_key[j];
                j += 2;
            }
        }
        return hash % (maximum + 1);
    }
}

