/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;

public class RollingProcessFileAppender
extends RollingFileAppender {
    private static String PROCESS = "businessobjects.logging.process";
    private String m_ext = null;
    private String m_pureName = null;
    private String m_processID = null;
    private String m_timeStamp = null;

    public RollingProcessFileAppender() {
        this.m_processID = null;
        this.m_processID = System.getProperty(PROCESS);
    }

    public void activateOptions() {
        if (this.fileName != null) {
            int pos = this.fileName.lastIndexOf(46);
            if (pos != -1) {
                this.m_pureName = this.fileName.substring(0, pos);
                this.m_ext = this.fileName.length() > pos + 1 ? this.fileName.substring(pos + 1) : "";
            } else {
                this.m_pureName = this.fileName;
                this.m_ext = null;
            }
            Date date = new Date(System.currentTimeMillis());
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH);
            this.m_timeStamp = format.format(date);
            this.fileName = this.m_processID != null ? this.m_pureName + "_" + this.m_timeStamp + "_" + this.m_processID + "." + this.m_ext : this.m_pureName + "_" + this.m_timeStamp + "." + this.m_ext;
        } else {
            LogLog.error((String)"RollingPorcessFileAppender: Input filename name is null");
        }
        super.activateOptions();
    }

    public RollingProcessFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, bufferedIO, bufferSize);
    }

    public void rollOver() {
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        int maximumBackupIndex = this.maxBackupIndex;
        if (maximumBackupIndex > 0) {
            File target;
            File file = new File(this.getIndexedFileName(maximumBackupIndex, this.m_timeStamp));
            if (file.exists()) {
                file.delete();
            }
            for (int i = maximumBackupIndex - 1; i >= 1; --i) {
                file = new File(this.getIndexedFileName(i, this.m_timeStamp));
                if (!file.exists()) continue;
                target = new File(this.getIndexedFileName(i + 1, this.m_timeStamp));
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                file.renameTo(target);
            }
            target = new File(this.getIndexedFileName(1, this.m_timeStamp));
            this.closeFile();
            file = new File(this.fileName);
            LogLog.debug((String)("Renaming file " + file + " to " + target));
            file.renameTo(target);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    private String getIndexedFileName(int index, String timeStamp) {
        if (this.m_processID != null) {
            return this.m_pureName + "_" + timeStamp + "_" + this.m_processID + ".bak" + index + "." + this.m_ext;
        }
        return this.m_pureName + "_" + timeStamp + ".bak" + index + "." + this.m_ext;
    }
}

