/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import java.util.HashMap;
import java.util.TimeZone;

public abstract class TimeZoneUtil {
    static HashMap sapToJavaMap = new HashMap(128);
    static HashMap javaToSapMap = new HashMap(1024);

    public static TimeZone getTimeZone(String sapTimeZoneID) {
        String javaTimeZoneID = TimeZoneUtil.getJavaTimeZoneID(sapTimeZoneID);
        if (javaTimeZoneID != null) {
            return TimeZone.getTimeZone(javaTimeZoneID);
        }
        return null;
    }

    public static String getJavaTimeZoneID(String sapTimeZoneID) {
        if (sapTimeZoneID == null) {
            return null;
        }
        MapEntry entry = (MapEntry)sapToJavaMap.get(sapTimeZoneID);
        if (entry != null && entry.javaTimeZoneID != null && entry.javaTimeZoneID.length > 0) {
            return entry.javaTimeZoneID[0];
        }
        return null;
    }

    public static String getSAPTimeZoneID(String javaTimeZoneID) {
        if (javaTimeZoneID == null) {
            return null;
        }
        MapEntry entry = (MapEntry)javaToSapMap.get(javaTimeZoneID);
        if (entry != null) {
            return entry.sapTimeZoneID;
        }
        return null;
    }

    public static String getSAPTimeZoneID(TimeZone timeZone) {
        if (timeZone != null) {
            return TimeZoneUtil.getSAPTimeZoneID(timeZone.getID());
        }
        return null;
    }

    static {
        new MapEntry("UTC-12", new String[]{"GMT-12:00", "Etc/GMT+12"});
        new MapEntry("UTC-11", new String[]{"GMT-11:00", "Etc/GMT+11", "MIT", "Pacific/Apia", "Pacific/Midway", "Pacific/Niue", "Pacific/Pago_Pago", "Pacific/Samoa", "US/Samoa"});
        new MapEntry("UTC-10", new String[]{"GMT-10:00", "Etc/GMT+10", "HST", "Pacific/Fakaofo", "Pacific/Honolulu", "Pacific/Johnston", "Pacific/Rarotonga", "Pacific/Tahiti", "SystemV/HST10", "US/Hawaii"});
        new MapEntry("UTC-9", new String[]{"GMT-09:00", "Etc/GMT+9", "Pacific/Gambier", "SystemV/YST9"});
        new MapEntry("UTC-8", new String[]{"GMT-08:00", "Etc/GMT+8", "Pacific/Pitcairn", "SystemV/PST8"});
        new MapEntry("UTC-7", new String[]{"GMT-07:00", "Etc/GMT+7", "America/Dawson_Creek", "America/Hermosillo", "America/Phoenix", "MST", "PNT", "SystemV/MST7", "US/Arizona"});
        new MapEntry("UTC-6", new String[]{"GMT-06:00", "Etc/GMT+6", "America/Belize", "America/Costa_Rica", "America/El_Salvador", "America/Guatemala", "America/Managua", "America/Regina", "America/Swift_Current", "America/Tegucigalpa", "Canada/East-Saskatchewan", "Canada/Saskatchewan", "Pacific/Galapagos", "SystemV/CST6"});
        new MapEntry("UTC-5", new String[]{"GMT-05:00", "Etc/GMT+5", "America/Bogota", "America/Cayman", "America/Coral_Harbour", "America/Eirunepe", "America/Guayaquil", "America/Jamaica", "America/Lima", "America/Panama", "America/Porto_Acre", "America/Rio_Branco", "Brazil/Acre", "EST", "Jamaica", "SystemV/EST5"});
        new MapEntry("UTC-4", new String[]{"GMT-04:00", "Etc/GMT+4", "America/Anguilla", "America/Antigua", "America/Aruba", "America/Barbados", "America/Boa_Vista", "America/Caracas", "America/Curacao", "America/Dominica", "America/Grenada", "America/Guadeloupe", "America/Guyana", "America/La_Paz", "America/Manaus", "America/Martinique", "America/Montserrat", "America/Port_of_Spain", "America/Porto_Velho", "America/Puerto_Rico", "America/Santo_Domingo", "America/St_Kitts", "America/St_Lucia", "America/St_Thomas", "America/St_Vincent", "America/Tortola", "America/Virgin", "Brazil/West", "PRT", "SystemV/AST4"});
        new MapEntry("UTC-3", new String[]{"GMT-03:00", "Etc/GMT+3", "AGT", "America/Araguaina", "America/Argentina/Buenos_Aires", "America/Argentina/Catamarca", "America/Argentina/ComodRivadavia", "America/Argentina/Cordoba", "America/Argentina/Jujuy", "America/Argentina/La_Rioja", "America/Argentina/Mendoza", "America/Argentina/Rio_Gallegos", "America/Argentina/San_Juan", "America/Argentina/Tucuman", "America/Argentina/Ushuaia", "America/Bahia", "America/Belem", "America/Buenos_Aires", "America/Catamarca", "America/Cayenne", "America/Cordoba", "America/Fortaleza", "America/Jujuy", "America/Maceio", "America/Mendoza", "America/Montevideo", "America/Paramaribo", "America/Recife", "America/Rosario", "Antarctica/Rothera"});
        new MapEntry("UTC-2", new String[]{"GMT-02:00", "Etc/GMT+2", "America/Noronha", "Atlantic/South_Georgia", "Brazil/DeNoronha"});
        new MapEntry("UTC-1", new String[]{"GMT-01:00", "Etc/GMT+1", "Atlantic/Cape_Verde"});
        new MapEntry("UTC", new String[]{"GMT", "Etc/GMT", "Etc/GMT+0", "Etc/GMT-0", "Etc/UTC", "Etc/Greenwich", "Etc/Zulu", "Etc/Universal", "UTC", "Africa/Abidjan", "Africa/Accra", "Africa/Bamako", "Africa/Banjul", "Africa/Bissau", "Africa/Casablanca", "Africa/Conakry", "Africa/Dakar", "Africa/El_Aaiun", "Africa/Freetown", "Africa/Lome", "Africa/Monrovia", "Africa/Nouakchott", "Africa/Ouagadougou", "Africa/Sao_Tome", "Africa/Timbuktu", "America/Danmarkshavn", "Atlantic/Reykjavik", "Atlantic/St_Helena", "Etc/GMT0", "Etc/UCT", "GMT0", "Greenwich", "Iceland", "UCT", "Universal", "Zulu"});
        new MapEntry("UTC+1", new String[]{"GMT+01:00", "Etc/GMT-1"});
        new MapEntry("WAT", new String[]{"Africa/Algiers", "Africa/Bangui", "Africa/Brazzaville", "Africa/Douala", "Africa/Kinshasa", "Africa/Lagos", "Africa/Libreville", "Africa/Luanda", "Africa/Malabo", "Africa/Ndjamena", "Africa/Niamey", "Africa/Porto-Novo"});
        new MapEntry("UTC+2", new String[]{"GMT+02:00", "Etc/GMT-2", "Africa/Blantyre", "Africa/Bujumbura", "Africa/Gaborone", "Africa/Harare", "Africa/Johannesburg", "Africa/Kigali", "Africa/Lubumbashi", "Africa/Lusaka", "Africa/Maputo", "Africa/Maseru", "Africa/Mbabane", "Africa/Tripoli", "CAT", "Libya"});
        new MapEntry("CAT", new String[]{"CAT"});
        new MapEntry("UTC+3", new String[]{"GMT+03:00", "Etc/GMT-3", "Africa/Addis_Ababa", "Africa/Asmera", "Africa/Dar_es_Salaam", "Africa/Djibouti", "Africa/Kampala", "Africa/Khartoum", "Africa/Mogadishu", "Africa/Nairobi", "Antarctica/Syowa", "Asia/Aden", "Asia/Bahrain", "Asia/Kuwait", "Asia/Qatar", "Asia/Riyadh", "EAT", "Indian/Antananarivo", "Indian/Comoro", "Indian/Mayotte"});
        new MapEntry("UTC+4", new String[]{"GMT+04:00", "Etc/GMT-4", "Asia/Dubai", "Asia/Muscat", "Asia/Tbilisi", "Indian/Mahe", "Indian/Mauritius", "Indian/Reunion"});
        new MapEntry("UTC+5", new String[]{"GMT+05:00", "Etc/GMT-5", "Asia/Aqtau", "Asia/Aqtobe", "Asia/Ashgabat", "Asia/Ashkhabad", "Asia/Dushanbe", "Asia/Karachi", "Asia/Oral", "Asia/Samarkand", "Asia/Tashkent", "Indian/Kerguelen", "Indian/Maldives", "PLT"});
        new MapEntry("UTC+53", new String[]{"GMT+05:30", "Asia/Calcutta", "Asia/Colombo"});
        new MapEntry("INDIA", new String[]{"IST"});
        new MapEntry("NEPAL", new String[]{"Asia/Katmandu"});
        new MapEntry("UTC+6", new String[]{"GMT+06:00", "Etc/GMT-6", "Antarctica/Mawson", "Antarctica/Vostok", "Asia/Almaty", "Asia/Bishkek", "Asia/Dacca", "Asia/Dhaka", "Asia/Qyzylorda", "Asia/Thimbu", "Asia/Thimphu", "BST", "Indian/Chagos"});
        new MapEntry("UTC+63", new String[]{"GMT+06:30", "Asia/Rangoon", "Indian/Cocos"});
        new MapEntry("UTC+7", new String[]{"GMT+07:00", "Etc/GMT-7", "Antarctica/Davis", "Asia/Bangkok", "Asia/Jakarta", "Asia/Phnom_Penh", "Asia/Pontianak", "Asia/Saigon", "Asia/Vientiane", "Indian/Christmas", "VST"});
        new MapEntry("UTC+8", new String[]{"GMT+08:00", "Etc/GMT-8", "Antarctica/Casey", "Asia/Brunei", "Asia/Chongqing", "Asia/Chungking", "Asia/Harbin", "Asia/Hong_Kong", "Asia/Kashgar", "Asia/Kuala_Lumpur", "Asia/Kuching", "Asia/Macao", "Asia/Macau", "Asia/Makassar", "Asia/Manila", "Asia/Shanghai", "Asia/Singapore", "Asia/Taipei", "Asia/Ujung_Pandang", "Asia/Urumqi", "CTT", "Hongkong", "PRC", "Singapore"});
        new MapEntry("AUSWA", new String[]{"Australia/West", "Australia/Perth"});
        new MapEntry("UTC+9", new String[]{"GMT+09:00", "Etc/GMT-9", "Asia/Dili", "Asia/Jayapura", "Asia/Pyongyang", "Asia/Seoul", "JST", "Pacific/Palau", "ROK"});
        new MapEntry("JAPAN", new String[]{"Japan", "Asia/Tokyo"});
        new MapEntry("UTC+10", new String[]{"GMT+10:00", "Etc/GMT-10", "Antarctica/DumontDUrville", "Australia/Brisbane", "Australia/Lindeman", "Pacific/Guam", "Pacific/Port_Moresby", "Pacific/Saipan", "Pacific/Truk", "Pacific/Yap"});
        new MapEntry("AUSQLD", new String[]{"Australia/Queensland"});
        new MapEntry("UTC+11", new String[]{"GMT+11:00", "Etc/GMT-11", "Pacific/Efate", "Pacific/Guadalcanal", "Pacific/Kosrae", "Pacific/Noumea", "Pacific/Ponape", "SST"});
        new MapEntry("NORFLK", new String[]{"Pacific/Norfolk"});
        new MapEntry("UTC+12", new String[]{"GMT+12:00", "Etc/GMT-12", "Kwajalein", "Pacific/Fiji", "Pacific/Funafuti", "Pacific/Kwajalein", "Pacific/Majuro", "Pacific/Nauru", "Pacific/Tarawa", "Pacific/Wake", "Pacific/Wallis"});
        new MapEntry("UTC+13", new String[]{"GMT+13:00", "Etc/GMT-13", "Pacific/Enderbury", "Pacific/Tongatapu"});
        new MapEntry("UTC+14", new String[]{"GMT+14:00", "Etc/GMT-14", "Pacific/Kiritimati"});
        new MapEntry("AUSNT", new String[]{"ACT", "Australia/Darwin", "Australia/North"});
        new MapEntry("AFGHAN", new String[]{"Asia/Kabul"});
        new MapEntry("IRAN", new String[]{"Asia/Tehran", "Iran"});
        new MapEntry("ALAW", new String[]{"America/Adak", "America/Atka"});
        new MapEntry("HAW", new String[]{"US/Aleutian"});
        new MapEntry("ALA", new String[]{"AST", "America/Anchorage", "America/Juneau", "America/Nome", "America/Yakutat", "SystemV/YST9YDT", "US/Alaska"});
        new MapEntry("PST", new String[]{"PST", "America/Dawson", "America/Ensenada", "America/Los_Angeles", "America/Tijuana", "America/Vancouver", "America/Whitehorse", "Canada/Pacific", "Canada/Yukon", "Mexico/BajaNorte", "PST8PDT", "SystemV/PST8PDT", "US/Pacific", "US/Pacific-New"});
        new MapEntry("MST", new String[]{"America/Boise", "America/Cambridge_Bay", "America/Chihuahua", "America/Denver", "America/Edmonton", "America/Inuvik", "America/Mazatlan", "America/Shiprock", "America/Yellowknife", "Canada/Mountain", "MST7MDT", "Mexico/BajaSur", "Navajo", "SystemV/MST7MDT", "US/Mountain"});
        new MapEntry("CHILEE", new String[]{"Chile/EasterIsland", "Pacific/Easter"});
        new MapEntry("CST", new String[]{"CST", "America/Cancun", "America/Chicago", "America/Indiana/Knox", "America/Indiana/Vincennes", "America/Knox_IN", "America/Menominee", "America/Merida", "America/Mexico_City", "America/Monterrey", "America/North_Dakota/Center", "America/North_Dakota/New_Salem", "America/Rainy_River", "America/Rankin_Inlet", "America/Winnipeg", "CST6CDT", "Canada/Central", "Mexico/General", "SystemV/CST6CDT", "US/Central", "US/Indiana-Starke"});
        new MapEntry("EST", new String[]{"America/New_York"});
        new MapEntry("ESTNO", new String[]{"America/Indianapolis", "America/Indiana/Indianapolis"});
        new MapEntry("EST_", new String[]{"America/Detroit", "America/Fort_Wayne", "America/Grand_Turk", "America/Havana", "America/Indiana/Marengo", "America/Indiana/Vevay", "America/Indiana/Petersburg", "America/Iqaluit", "America/Kentucky/Louisville", "America/Kentucky/Monticello", "America/Louisville", "America/Montreal", "America/Nassau", "America/Nipigon", "America/Pangnirtung", "America/Port-au-Prince", "America/Thunder_Bay", "America/Toronto", "Canada/Eastern", "Cuba", "EST5EDT", "IET", "SystemV/EST5EDT", "US/East-Indiana", "US/Eastern", "US/Michigan"});
        new MapEntry("AST", new String[]{"America/Glace_Bay", "America/Goose_Bay", "America/Halifax", "America/Moncton", "America/Thule", "Canada/Atlantic", "SystemV/AST4ADT"});
        new MapEntry("GSTW", new String[]{"Atlantic/Bermuda"});
        new MapEntry("FLKND", new String[]{"Atlantic/Stanley"});
        new MapEntry("BRZLAN", new String[]{"America/Asuncion", "America/Campo_Grande", "America/Cuiaba", "America/Santiago", "Antarctica/Palmer"});
        new MapEntry("CHILE", new String[]{"Chile/Continental"});
        new MapEntry("NST", new String[]{"America/St_Johns"});
        new MapEntry("NFDL", new String[]{"Canada/Newfoundland", "CNT"});
        new MapEntry("GST", new String[]{"America/Godthab"});
        new MapEntry("PIERRE", new String[]{"America/Miquelon"});
        new MapEntry("BRAZIL", new String[]{"BET", "America/Sao_Paulo"});
        new MapEntry("BRZLEA", new String[]{"Brazil/East"});
        new MapEntry("GSTE", new String[]{"America/Scoresbysund"});
        new MapEntry("AZOREAN", new String[]{"Atlantic/Azores"});
        new MapEntry("GMTUK", new String[]{"Europe/Belfast", "GB-Eire"});
        new MapEntry("WET", new String[]{"WET", "Atlantic/Canary", "Atlantic/Faeroe", "Atlantic/Madeira", "Eire", "Europe/Dublin", "Europe/Lisbon", "Portugal"});
        new MapEntry("UK", new String[]{"Europe/London", "GB"});
        new MapEntry("CET", new String[]{"CET", "Africa/Ceuta", "Africa/Tunis", "Arctic/Longyearbyen", "Atlantic/Jan_Mayen", "ECT", "Europe/Amsterdam", "Europe/Andorra", "Europe/Belgrade", "Europe/Berlin", "Europe/Bratislava", "Europe/Brussels", "Europe/Budapest", "Europe/Copenhagen", "Europe/Gibraltar", "Europe/Ljubljana", "Europe/Luxembourg", "Europe/Madrid", "Europe/Malta", "Europe/Monaco", "Europe/Oslo", "Europe/Paris", "Europe/Prague", "Europe/Rome", "Europe/San_Marino", "Europe/Sarajevo", "Europe/Skopje", "Europe/Stockholm", "Europe/Tirane", "Europe/Vaduz", "Europe/Vatican", "Europe/Vienna", "Europe/Warsaw", "Europe/Zagreb", "Europe/Zurich", "MET", "Poland"});
        new MapEntry("EGYPT", new String[]{"Africa/Cairo", "Egypt"});
        new MapEntry("LBANON", new String[]{"Asia/Beirut"});
        new MapEntry("SYRIA", new String[]{"Asia/Damascus"});
        new MapEntry("ISRAEL", new String[]{"Asia/Tel_Aviv", "Asia/Tel_Aviv", "Israel", "Asia/Jerusalem"});
        new MapEntry("JORDAN", new String[]{"Asia/Amman"});
        new MapEntry("EET", new String[]{"EET", "ART", "Asia/Istanbul", "Asia/Nicosia", "Europe/Athens", "Europe/Bucharest", "Europe/Chisinau", "Europe/Helsinki", "Europe/Istanbul", "Europe/Kaliningrad", "Europe/Kiev", "Europe/Mariehamn", "Europe/Minsk", "Europe/Nicosia", "Europe/Riga", "Europe/Simferopol", "Europe/Sofia", "Europe/Tallinn", "Europe/Tiraspol", "Europe/Uzhgorod", "Europe/Vilnius", "Europe/Zaporozhye", "Turkey"});
        new MapEntry("IRAQ", new String[]{"Asia/Baghdad"});
        new MapEntry("RUS03", new String[]{"Europe/Moscow", "W-SU"});
        new MapEntry("RUS04", new String[]{"Asia/Baku", "Asia/Yerevan", "Europe/Samara", "NET"});
        new MapEntry("RUS05", new String[]{"Asia/Yekaterinburg"});
        new MapEntry("RUS06", new String[]{"Asia/Novosibirsk", "Asia/Omsk"});
        new MapEntry("RUS07", new String[]{"Asia/Hovd", "Asia/Krasnoyarsk"});
        new MapEntry("RUS08", new String[]{"Asia/Irkutsk", "Asia/Ulaanbaatar", "Asia/Ulan_Bator"});
        new MapEntry("RUS09", new String[]{"Asia/Choibalsan", "Asia/Yakutsk"});
        new MapEntry("AUSSA", new String[]{"Australia/Adelaide", "Australia/Broken_Hill", "Australia/South", "Australia/Yancowinna"});
        new MapEntry("AUSACT", new String[]{"AET", "Australia/ACT", "Australia/Canberra", "Australia/Currie", "Australia/Hobart", "Australia/Melbourne", "Australia/Sydney"});
        new MapEntry("AUSNSW", new String[]{"Australia/NSW"});
        new MapEntry("AUSTAS", new String[]{"Australia/Tasmania"});
        new MapEntry("AUSVIC", new String[]{"Australia/Victoria"});
        new MapEntry("RUS10", new String[]{"Asia/Sakhalin", "Asia/Vladivostok"});
        new MapEntry("AUSLHI", new String[]{"Australia/LHI", "Australia/Lord_Howe"});
        new MapEntry("RUS11", new String[]{"Asia/Magadan"});
        new MapEntry("RUS12", new String[]{"Asia/Anadyr", "Asia/Kamchatka"});
        new MapEntry("NZST", new String[]{"NST", "Antarctica/McMurdo", "Antarctica/South_Pole", "NZ", "Pacific/Auckland"});
        new MapEntry("NZCHA", new String[]{"NZ-CHAT", "Pacific/Chatham"});
    }

    protected static class MapEntry {
        String sapTimeZoneID;
        String[] javaTimeZoneID;

        protected MapEntry(String sapTimeZoneID, String[] javaTimeZoneID) {
            this.sapTimeZoneID = sapTimeZoneID;
            this.javaTimeZoneID = javaTimeZoneID;
            sapToJavaMap.put(sapTimeZoneID, this);
            int i = 0;
            while (i < javaTimeZoneID.length) {
                javaToSapMap.put(javaTimeZoneID[i], this);
                ++i;
            }
        }
    }
}

