/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.Codecs;
import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class XMLWriterBase {
    public static final String NAMESPACE_URN_SOAP_UC = "urn:sap-com:document:sap:soap:functions:uc-style";
    public static final String NAMESPACE_URN_SAP_RFC = "urn:sap-com:document:sap:rfc:functions";
    public static final byte ESCAPE_NONE = 0;
    public static final byte ESCAPE_DEFAULT = 1;
    public static final byte ESCAPE_IDOC46 = 2;
    public static final byte ESCAPE_IDOC610 = 3;
    protected static final int DOCUMENT_BUFFER_SIZE = 1024;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] LESSTHAN = new char[]{'&', '#', '6', '0', ';'};
    private static final char[] GREATERTHAN = new char[]{'&', '#', '6', '2', ';'};
    private static final char[] AMPERSAND = new char[]{'&', '#', '3', '8', ';'};
    private static final char[] CDATASTART = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATAEND = new char[]{']', ']', '>'};
    private static final char[] COMMENTSTART = new char[]{'<', '!', '-', '-', ' '};
    private static final char[] COMMENTEND = new char[]{' ', '-', '-', '>'};
    protected XMLWriterBase m_parent = null;
    private char[] m_xmldoc = null;
    private int m_offset = 0;
    private int m_length = 0;
    private char[] m_buffer = new char[0];
    private Writer m_out = null;
    private String m_encoding = "UTF-8";
    protected byte m_escape_mode = 1;
    protected boolean m_trim_spaces = true;
    protected boolean m_with_end_of_line = false;

    public XMLWriterBase() {
        this.m_xmldoc = new char[1024];
    }

    public XMLWriterBase(OutputStream out, String encoding) throws UnsupportedEncodingException {
        this(null, out, encoding);
    }

    public XMLWriterBase(XMLWriterBase parent, OutputStream out, String encoding) throws UnsupportedEncodingException {
        this(parent, new BufferedWriter(new OutputStreamWriter(out, encoding != null ? encoding : "UTF-8")));
        if (this.m_encoding != null) {
            this.m_encoding = encoding;
        }
    }

    public XMLWriterBase(XMLWriterBase parent, Writer out) {
        this.m_parent = parent;
        if (this.m_parent == null) {
            this.m_buffer = new char[1024];
            this.m_xmldoc = new char[1024];
            this.m_offset = 0;
            this.m_out = out;
        } else {
            this.m_buffer = this.m_parent.m_buffer;
            this.m_xmldoc = this.m_parent.m_xmldoc;
            this.m_offset = this.m_parent.m_offset;
            this.m_length = this.m_parent.m_length;
            this.m_out = this.m_parent.m_out;
            this.m_encoding = this.m_parent.m_encoding;
            this.m_escape_mode = this.m_parent.m_escape_mode;
            this.m_trim_spaces = this.m_parent.m_trim_spaces;
            this.m_with_end_of_line = this.m_parent.m_with_end_of_line;
        }
    }

    private final void propagateToParent() {
        XMLWriterBase parent = this.m_parent;
        while (parent != null) {
            parent.m_xmldoc = this.m_xmldoc;
            parent.m_offset = this.m_offset;
            parent.m_length = this.m_length;
            parent = parent.m_parent;
        }
    }

    protected final void ensureBufferCapacity(int size) throws IOException {
        if (this.m_offset + size >= this.m_xmldoc.length) {
            if (this.m_out != null && this.m_offset > 0) {
                this.flush();
            }
            if (this.m_offset + size >= this.m_xmldoc.length) {
                char[] old = this.m_xmldoc;
                size += this.m_offset;
                size = (size / 1024 + 1) * 2 * 1024;
                this.m_xmldoc = new char[size];
                System.arraycopy(old, 0, this.m_xmldoc, 0, this.m_offset);
            }
            this.propagateToParent();
        }
    }

    public final String getEncoding() {
        return this.m_encoding;
    }

    public final byte getEscapeMode() {
        return this.m_escape_mode;
    }

    public final void setEscapeMode(byte escape_mode) {
        this.m_escape_mode = escape_mode;
    }

    public final boolean getTrimTrailingSpaces() {
        return this.m_trim_spaces;
    }

    public final void setTrimTrailingSpaces(boolean trim_spaces) {
        this.m_trim_spaces = trim_spaces;
    }

    public final boolean getEndOfLineMode() {
        return this.m_with_end_of_line;
    }

    public final void setEndOfLineMode(boolean with_end_of_line) {
        this.m_with_end_of_line = with_end_of_line;
    }

    public final int length() {
        return this.m_out == null ? this.m_offset : this.m_length + this.m_offset;
    }

    protected final char[] getBuffer() {
        return this.m_out == null ? this.m_xmldoc : null;
    }

    public final char[] toCharArray() {
        if (this.m_out != null) {
            return new char[0];
        }
        char[] xmldoc = new char[this.m_offset];
        System.arraycopy(this.m_xmldoc, 0, xmldoc, 0, this.m_offset);
        return xmldoc;
    }

    public final String toString() {
        return this.m_out == null ? new String(this.m_xmldoc, 0, this.m_offset) : "";
    }

    public void reset() {
        if (JCO.getTraceLevel() > 9) {
            JCO.fireTrace(10, "[JAV-LAYER] XMLWriterBase.reset()");
        }
        this.m_xmldoc = new char[1024];
        this.m_offset = 0;
        this.m_length = 0;
        this.propagateToParent();
    }

    public void flush() throws IOException {
        if (this.m_out != null && this.m_offset > 0) {
            this.m_out.write(this.m_xmldoc, 0, this.m_offset);
            this.m_out.flush();
            this.m_length += this.m_offset;
            this.m_offset = 0;
            this.propagateToParent();
        }
    }

    public void close() throws IOException {
        if (this.m_parent == null) {
            this.flush();
        } else {
            this.m_parent.m_buffer = this.m_buffer;
            this.propagateToParent();
        }
    }

    public String escape(String tag) throws CharConversionException {
        if (this.m_escape_mode == 0) {
            return tag;
        }
        int ioffset = 0;
        int length = tag.length();
        if (length * 5 > this.m_buffer.length) {
            this.m_buffer = new char[length * 5];
        }
        if (this.m_escape_mode == 2) {
            int i = 0;
            while (i < length) {
                char c = tag.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    this.m_buffer[ioffset++] = c;
                } else if (i > 0 && (c >= '0' && c <= '9' || c == '_')) {
                    this.m_buffer[ioffset++] = c;
                } else if (c == '/') {
                    this.m_buffer[ioffset++] = i == 0 ? 95 : 45;
                } else {
                    throw new CharConversionException("Field name '" + tag + "' cannot be converted to an XML compliant element tag");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                char c = tag.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_') {
                    this.m_buffer[ioffset++] = c;
                } else if (i > 0 && (c >= '0' && c <= '9' || c == '.')) {
                    this.m_buffer[ioffset++] = c;
                } else if (c == '/') {
                    this.m_buffer[ioffset++] = 95;
                    this.m_buffer[ioffset++] = 45;
                } else {
                    this.m_buffer[ioffset++] = 95;
                    this.m_buffer[ioffset++] = 45;
                    this.m_buffer[ioffset++] = 45;
                    this.m_buffer[ioffset++] = hex[c >> 4 & 0xF];
                    this.m_buffer[ioffset++] = hex[c >> 0 & 0xF];
                }
                ++i;
            }
        }
        return new String(this.m_buffer, 0, ioffset);
    }

    public final XMLWriterBase content(byte[] value) throws IOException {
        if (value == null) {
            return this;
        }
        return this.content(value, 0, value.length);
    }

    public final XMLWriterBase content(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this;
        }
        char[] svalue = Codecs.Base64.encode(value, offset, length);
        length = svalue.length;
        this.ensureBufferCapacity(length);
        System.arraycopy(svalue, 0, this.m_xmldoc, this.m_offset, length);
        this.m_offset += length;
        return this;
    }

    public final XMLWriterBase content(char[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this;
        }
        if (this.m_trim_spaces && length > 0) {
            while (length > 0 && value[offset + length - 1] == ' ') {
                --length;
            }
        }
        if (length <= 0) {
            return this;
        }
        int required_length = length;
        if (this.m_escape_mode == 0) {
            this.ensureBufferCapacity(required_length);
            System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
            this.m_offset += length;
        } else if (this.m_escape_mode == 1 || this.m_escape_mode == 3) {
            char c;
            int end = offset + length;
            required_length = length;
            int i = offset;
            while (i < end) {
                c = value[i];
                if (c == '<' || c == '>' || c == '&') {
                    required_length += 4;
                }
                ++i;
            }
            this.ensureBufferCapacity(required_length);
            if (required_length > length) {
                end = offset + length;
                i = offset;
                while (i < end) {
                    c = value[i];
                    switch (c) {
                        case '<': {
                            System.arraycopy(LESSTHAN, 0, this.m_xmldoc, this.m_offset, LESSTHAN.length);
                            this.m_offset += LESSTHAN.length;
                            break;
                        }
                        case '>': {
                            System.arraycopy(GREATERTHAN, 0, this.m_xmldoc, this.m_offset, GREATERTHAN.length);
                            this.m_offset += GREATERTHAN.length;
                            break;
                        }
                        case '&': {
                            System.arraycopy(AMPERSAND, 0, this.m_xmldoc, this.m_offset, AMPERSAND.length);
                            this.m_offset += AMPERSAND.length;
                            break;
                        }
                        default: {
                            this.m_xmldoc[this.m_offset++] = c;
                        }
                    }
                    ++i;
                }
            } else {
                System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
                this.m_offset += length;
            }
        } else {
            char c;
            boolean must_escape = false;
            int end = offset + length;
            required_length = length;
            int i = offset;
            while (i < end && !must_escape) {
                c = value[i];
                if (c == '<' || c == '>' || c == '&') {
                    must_escape = true;
                }
                ++i;
            }
            if (must_escape) {
                end = offset + length - 2;
                i = offset;
                while (i < end) {
                    if (value[i] == ']' && value[i + 1] == ']' && value[i + 2] == '>') {
                        required_length += GREATERTHAN.length;
                    }
                    ++i;
                }
                this.ensureBufferCapacity(required_length + CDATASTART.length + CDATAEND.length);
                System.arraycopy(CDATASTART, 0, this.m_xmldoc, this.m_offset, CDATASTART.length);
                this.m_offset += CDATASTART.length;
                if (required_length > length) {
                    i = offset;
                    end = offset + length - 2;
                    while (i < end) {
                        c = value[i];
                        if (c == ']' && value[i + 1] == ']' && value[i + 2] == '>') {
                            this.m_xmldoc[this.m_offset++] = 93;
                            this.m_xmldoc[this.m_offset++] = 93;
                            System.arraycopy(GREATERTHAN, 0, this.m_xmldoc, this.m_offset, GREATERTHAN.length);
                            this.m_offset += GREATERTHAN.length;
                            i += 3;
                            continue;
                        }
                        this.m_xmldoc[this.m_offset++] = c;
                        ++i;
                    }
                    i = end;
                    while (i < end + 2) {
                        this.m_xmldoc[this.m_offset++] = value[i];
                        ++i;
                    }
                } else {
                    System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
                    this.m_offset += length;
                }
                System.arraycopy(CDATAEND, 0, this.m_xmldoc, this.m_offset, CDATAEND.length);
                this.m_offset += CDATAEND.length;
            } else {
                this.ensureBufferCapacity(required_length);
                System.arraycopy(value, offset, this.m_xmldoc, this.m_offset, length);
                this.m_offset += length;
            }
        }
        return this;
    }

    public final XMLWriterBase content(String value) throws IOException {
        if (value == null) {
            return this;
        }
        int length = value.length();
        if (length > this.m_buffer.length) {
            this.m_buffer = new char[length];
        }
        value.getChars(0, length, this.m_buffer, 0);
        return this.content(this.m_buffer, 0, length);
    }

    public final XMLWriterBase stag(String name) throws IOException {
        return name == null ? this : this.stag(name, null, this.m_with_end_of_line);
    }

    public final XMLWriterBase stag(String name, String[] attributes) throws IOException {
        return name == null ? this : this.stag(name, attributes, this.m_with_end_of_line);
    }

    protected final XMLWriterBase stag(String name, String[] attributes, boolean eol) throws IOException {
        int length;
        if (name == null || (length = name.length()) == 0) {
            return this;
        }
        int required_length = length + 2;
        if (eol) {
            ++required_length;
        }
        if (attributes == null || attributes.length == 0) {
            this.ensureBufferCapacity(required_length);
            this.m_xmldoc[this.m_offset++] = 60;
            name.getChars(0, length, this.m_xmldoc, this.m_offset);
            this.m_offset += length;
            this.m_xmldoc[this.m_offset++] = 62;
        } else {
            int i = 0;
            while (i < attributes.length) {
                required_length += attributes[i].length() + 1;
                ++i;
            }
            this.ensureBufferCapacity(required_length);
            this.m_xmldoc[this.m_offset++] = 60;
            name.getChars(0, length, this.m_xmldoc, this.m_offset);
            this.m_offset += length;
            int i2 = 0;
            while (i2 < attributes.length) {
                length = attributes[i2].length();
                this.m_xmldoc[this.m_offset++] = 32;
                attributes[i2].getChars(0, length, this.m_xmldoc, this.m_offset);
                this.m_offset += length;
                ++i2;
            }
            this.m_xmldoc[this.m_offset++] = 62;
        }
        if (eol) {
            this.m_xmldoc[this.m_offset++] = 10;
        }
        return this;
    }

    public final XMLWriterBase etag(String name) throws IOException {
        int length;
        if (name == null || (length = name.length()) == 0) {
            return this;
        }
        int required_length = length + 3;
        if (this.m_with_end_of_line) {
            ++required_length;
        }
        this.ensureBufferCapacity(required_length);
        this.m_xmldoc[this.m_offset++] = 60;
        this.m_xmldoc[this.m_offset++] = 47;
        name.getChars(0, length, this.m_xmldoc, this.m_offset);
        this.m_offset += length;
        this.m_xmldoc[this.m_offset++] = 62;
        if (this.m_with_end_of_line) {
            this.m_xmldoc[this.m_offset++] = 10;
        }
        return this;
    }

    public final XMLWriterBase empty(String name) throws IOException {
        return this.empty(name, null);
    }

    public final XMLWriterBase empty(String name, String[] attributes) throws IOException {
        int length;
        if (name == null || (length = name.length()) == 0) {
            return this;
        }
        int required_length = length + 3;
        if (this.m_with_end_of_line) {
            ++required_length;
        }
        if (attributes == null || attributes.length == 0) {
            this.ensureBufferCapacity(required_length);
            this.m_xmldoc[this.m_offset++] = 60;
            name.getChars(0, length, this.m_xmldoc, this.m_offset);
            this.m_offset += length;
            this.m_xmldoc[this.m_offset++] = 47;
            this.m_xmldoc[this.m_offset++] = 62;
        } else {
            int i = 0;
            while (i < attributes.length) {
                required_length += attributes[i].length() + 1;
                ++i;
            }
            this.ensureBufferCapacity(required_length);
            this.m_xmldoc[this.m_offset++] = 60;
            name.getChars(0, length, this.m_xmldoc, this.m_offset);
            this.m_offset += length;
            int i2 = 0;
            while (i2 < attributes.length) {
                length = attributes[i2].length();
                this.m_xmldoc[this.m_offset++] = 32;
                attributes[i2].getChars(0, length, this.m_xmldoc, this.m_offset);
                this.m_offset += length;
                ++i2;
            }
            this.m_xmldoc[this.m_offset++] = 47;
            this.m_xmldoc[this.m_offset++] = 62;
        }
        if (this.m_with_end_of_line) {
            this.m_xmldoc[this.m_offset++] = 10;
        }
        return this;
    }

    public final XMLWriterBase prolog() throws IOException {
        String prolog = "<?xml version=\"1.0\" encoding=\"" + this.m_encoding + "\"?>";
        int length = prolog.length();
        this.ensureBufferCapacity(length + (this.m_with_end_of_line ? 1 : 0));
        prolog.getChars(0, length, this.m_xmldoc, this.m_offset);
        this.m_offset += length;
        if (this.m_with_end_of_line) {
            this.m_xmldoc[this.m_offset++] = 10;
        }
        return this;
    }

    public final XMLWriterBase comment(String comment) throws IOException {
        int length = comment.length();
        this.ensureBufferCapacity(length + COMMENTSTART.length + COMMENTEND.length + (this.m_with_end_of_line ? 1 : 0));
        System.arraycopy(COMMENTSTART, 0, this.m_xmldoc, this.m_offset, COMMENTSTART.length);
        this.m_offset += COMMENTSTART.length;
        comment.getChars(0, length, this.m_xmldoc, this.m_offset);
        this.m_offset += length;
        System.arraycopy(COMMENTEND, 0, this.m_xmldoc, this.m_offset, COMMENTEND.length);
        this.m_offset += COMMENTEND.length;
        if (this.m_with_end_of_line) {
            this.m_xmldoc[this.m_offset++] = 10;
        }
        return this;
    }

    public XMLWriterBase element(String name, String value) throws IOException {
        this.stag(name, null, false);
        this.content(value);
        return this.etag(name);
    }

    public XMLWriterBase element(String name, String[] attributes, String value) throws IOException {
        this.stag(name, attributes, false);
        this.content(value);
        return this.etag(name);
    }

    public XMLWriterBase element(String name, byte[] value) throws IOException {
        return this.element(name, null, value);
    }

    public XMLWriterBase element(String name, String[] attributes, byte[] value) throws IOException {
        this.stag(name, attributes, false);
        if (value != null) {
            this.content(value, 0, value.length);
        }
        return this.etag(name);
    }
}

