/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;

class AutoKeyInfo
extends OracleResultSetMetaData {
    String originalSql;
    String newSql;
    String tableName;
    byte sqlKind = 0;
    int sqlParserParamCount;
    String[] sqlParserParamList;
    boolean useNamedParameter;
    int current_argument;
    String[] columnNames;
    int[] columnIndexes;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    short[] tableFormOfUses;
    int[] tablePrecisions;
    int[] tableScales;
    String[] tableTypeNames;
    int autoKeyType;
    static final int KEYFLAG = 0;
    static final int COLUMNAME = 1;
    static final int COLUMNINDEX = 2;
    static final char QMARK = '?';
    int[] returnTypes;
    Accessor[] returnAccessors;
    private static final ThreadLocal<OracleSql> SQL_PARSER = new ThreadLocal(){

        protected OracleSql initialValue() {
            return new OracleSql(null);
        }
    };
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    AutoKeyInfo(String sql) {
        this.originalSql = sql;
        this.autoKeyType = 0;
    }

    AutoKeyInfo(String sql, String[] colNames) {
        this.originalSql = sql;
        this.columnNames = colNames;
        this.autoKeyType = 1;
    }

    AutoKeyInfo(String sql, int[] colIndexes) {
        this.originalSql = sql;
        this.columnIndexes = colIndexes;
        this.autoKeyType = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSql() throws SQLException {
        if (this.originalSql == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        OracleSql sqlParser = SQL_PARSER.get();
        sqlParser.initialize(this.originalSql);
        this.sqlKind = sqlParser.getSqlKind();
        if (this.sqlKind == 4) {
            this.sqlParserParamCount = sqlParser.getParameterCount();
            this.sqlParserParamList = sqlParser.getParameterList();
            if (this.sqlParserParamList == OracleSql.EMPTY_LIST) {
                this.useNamedParameter = false;
            } else {
                this.useNamedParameter = true;
                this.current_argument = this.sqlParserParamCount;
            }
        }
    }

    private String generateUniqueNamedParameter() {
        String nextArg;
        boolean retry;
        block0: do {
            retry = false;
            nextArg = Integer.toString(++this.current_argument).intern();
            for (int i2 = 0; i2 < this.sqlParserParamCount; ++i2) {
                if (this.sqlParserParamList[i2] != nextArg) continue;
                retry = true;
                continue block0;
            }
        } while (retry);
        return ":" + nextArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNewSql() throws SQLException {
        try {
            if (this.newSql != null) {
                return this.newSql;
            }
            if (this.sqlKind == 0) {
                this.parseSql();
            }
            switch (this.autoKeyType) {
                case 0: {
                    this.newSql = this.originalSql + " RETURNING ROWID INTO " + (this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
                    this.returnTypes = new int[1];
                    this.returnTypes[0] = 104;
                    break;
                }
                case 1: {
                    this.getNewSqlByColumnName();
                    break;
                }
                case 2: {
                    this.getNewSqlByColumnIndexes();
                }
            }
            this.sqlKind = 0;
            this.sqlParserParamList = null;
            return this.newSql;
        }
        catch (Exception e2) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    private String getNewSqlByColumnName() throws SQLException {
        int i2;
        this.returnTypes = new int[this.columnNames.length];
        this.columnIndexes = new int[this.columnNames.length];
        StringBuffer newSqlBuf = new StringBuffer(this.originalSql);
        newSqlBuf.append(" RETURNING ");
        for (i2 = 0; i2 < this.columnNames.length; ++i2) {
            int type;
            this.returnTypes[i2] = type = this.getReturnParamTypeCode(i2, this.columnNames[i2], this.columnIndexes);
            newSqlBuf.append(this.columnNames[i2]);
            if (i2 >= this.columnNames.length - 1) continue;
            newSqlBuf.append(", ");
        }
        newSqlBuf.append(" INTO ");
        for (i2 = 0; i2 < this.columnNames.length - 1; ++i2) {
            newSqlBuf.append((this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
        }
        newSqlBuf.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
        this.newSql = new String(newSqlBuf);
        return this.newSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewSqlByColumnIndexes() throws SQLException {
        int i2;
        this.returnTypes = new int[this.columnIndexes.length];
        StringBuffer newSqlBuf = new StringBuffer(this.originalSql);
        newSqlBuf.append(" RETURNING ");
        for (i2 = 0; i2 < this.columnIndexes.length; ++i2) {
            int index = this.columnIndexes[i2] - 1;
            if (index < 0 || index > this.tableColumnNames.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int type = this.tableColumnTypes[index];
            String name = this.tableColumnNames[index];
            this.returnTypes[i2] = type;
            newSqlBuf.append(name);
            if (i2 >= this.columnIndexes.length - 1) continue;
            newSqlBuf.append(", ");
        }
        newSqlBuf.append(" INTO ");
        for (i2 = 0; i2 < this.columnIndexes.length - 1; ++i2) {
            newSqlBuf.append((this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
        }
        newSqlBuf.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
        this.newSql = new String(newSqlBuf);
        return this.newSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getReturnParamTypeCode(int pos, String columnName, int[] columnIndexes) throws SQLException {
        for (int i2 = 0; i2 < this.tableColumnNames.length; ++i2) {
            if (!columnName.equalsIgnoreCase(this.tableColumnNames[i2])) continue;
            columnIndexes[pos] = i2 + 1;
            return this.tableColumnTypes[i2];
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    final boolean isInsertSqlStmt() throws SQLException {
        if (this.sqlKind == 0) {
            this.parseSql();
        }
        return this.sqlKind == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTableName() throws SQLException {
        int end;
        int start;
        if (this.tableName != null) {
            return this.tableName;
        }
        String s2 = this.originalSql.trim().toUpperCase();
        int pos = s2.indexOf("INSERT");
        if ((pos = s2.indexOf("INTO", pos)) < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        int len = s2.length();
        for (start = pos + 5; start < len && s2.charAt(start) == ' '; ++start) {
        }
        if (start >= len) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        for (end = start + 1; end < len && s2.charAt(end) != ' ' && s2.charAt(end) != '('; ++end) {
        }
        if (start == end - 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.tableName = s2.substring(start, end);
        return this.tableName;
    }

    void allocateSpaceForDescribedData(int numColumns) throws SQLException {
        this.numColumns = numColumns;
        this.tableColumnNames = new String[numColumns];
        this.tableColumnTypes = new int[numColumns];
        this.tableMaxLengths = new int[numColumns];
        this.tableNullables = new boolean[numColumns];
        this.tableFormOfUses = new short[numColumns];
        this.tablePrecisions = new int[numColumns];
        this.tableScales = new int[numColumns];
        this.tableTypeNames = new String[numColumns];
    }

    void fillDescribedData(int index, String colName, int type, int maxLength, boolean nullable, short form, int precision, int scale, String typeName) throws SQLException {
        this.tableColumnNames[index] = colName;
        this.tableColumnTypes[index] = type;
        this.tableMaxLengths[index] = maxLength;
        this.tableNullables[index] = nullable;
        this.tableFormOfUses[index] = form;
        this.tablePrecisions[index] = precision;
        this.tableScales[index] = scale;
        this.tableTypeNames[index] = typeName;
    }

    void initMetaData(OracleReturnResultSet rset) throws SQLException {
        if (this.returnAccessors != null) {
            return;
        }
        this.returnAccessors = rset.returnAccessors;
        switch (this.autoKeyType) {
            case 0: {
                this.initMetaDataKeyFlag();
                break;
            }
            case 1: 
            case 2: {
                this.initMetaDataColumnIndexes();
            }
        }
    }

    void initMetaDataKeyFlag() throws SQLException {
        this.returnAccessors[0].columnName = "ROWID";
        this.returnAccessors[0].describeType = 104;
        this.returnAccessors[0].describeMaxLength = 4;
        this.returnAccessors[0].nullable = true;
        this.returnAccessors[0].precision = 0;
        this.returnAccessors[0].scale = 0;
        this.returnAccessors[0].formOfUse = 0;
    }

    void initMetaDataColumnIndexes() throws SQLException {
        for (int i2 = 0; i2 < this.returnAccessors.length; ++i2) {
            Accessor accessor = this.returnAccessors[i2];
            int index = this.columnIndexes[i2] - 1;
            accessor.columnName = this.tableColumnNames[index];
            accessor.describeType = this.tableColumnTypes[index];
            accessor.describeMaxLength = this.tableMaxLengths[index];
            accessor.nullable = this.tableNullables[index];
            accessor.precision = this.tablePrecisions[index];
            accessor.scale = this.tablePrecisions[index];
            accessor.formOfUse = this.tableFormOfUses[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getValidColumnIndex(int column) throws SQLException {
        if (column <= 0 || column > this.returnAccessors.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return column - 1;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.returnAccessors.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int column) throws SQLException {
        if (column <= 0 || column > this.returnAccessors.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return this.returnAccessors[column - 1].columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName(int column) throws SQLException {
        if (column <= 0 || column > this.returnAccessors.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return this.getTableName();
    }

    @Override
    Accessor[] getDescription() throws SQLException {
        return this.returnAccessors;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.AutoKeyInfo"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

