/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class DoubleBinder
extends VarnumBinder {
    char[] digits;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DoubleBinder() {
        block12: {
            this.digits = new char[20];
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    DoubleBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DoubleBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DoubleBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] b2 = bindBytes;
            int offset = byteoffset + 1;
            double val = stmt.parameterDouble[rank][bindPosition];
            int len = 0;
            if (val == 0.0) {
                b2[offset] = -128;
                len = 1;
            } else if (val == Double.POSITIVE_INFINITY) {
                b2[offset] = -1;
                b2[offset + 1] = 101;
                len = 2;
            } else if (val == Double.NEGATIVE_INFINITY) {
                b2[offset] = 0;
                len = 1;
            } else {
                long bits;
                int rawExponent;
                int guess;
                boolean neg;
                boolean bl = neg = val < 0.0;
                if (neg) {
                    val = -val;
                }
                if ((guess = ((rawExponent = (int)((bits = Double.doubleToLongBits(val)) >> 52 & 0x7FFL)) > 1023 ? 126 : 127) - (int)((double)(rawExponent - 1023) / 6.643856189774725)) < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            DoubleBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)3) + " trying to bind " + val);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (guess > 192) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            DoubleBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)2) + " trying to bind " + val);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (val > factorTable[guess]) {
                    while (guess > 0 && val > factorTable[--guess]) {
                    }
                } else {
                    while (guess < 193 && val <= factorTable[guess + 1]) {
                        ++guess;
                    }
                }
                if (val == factorTable[guess]) {
                    if (guess < 65) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                DoubleBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)3) + " trying to bind " + val);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (guess > 192) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                DoubleBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)2) + " trying to bind " + val);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (neg) {
                        b2[offset] = (byte)(62 - (127 - guess));
                        b2[offset + 1] = 100;
                        b2[offset + 2] = 102;
                        len = 3;
                    } else {
                        b2[offset] = (byte)(192 + (128 - guess));
                        b2[offset + 1] = 2;
                        len = 2;
                    }
                } else {
                    int nSignificantBits;
                    if (guess < 64) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                DoubleBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)3) + " trying to bind " + val);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (guess > 191) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                DoubleBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)2) + " trying to bind " + val);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    long dBits = neg ? bits & Long.MAX_VALUE : bits;
                    long fractBits = dBits & 0xFFFFFFFFFFFFFL;
                    int binExp = rawExponent;
                    char[] digits = stmt.digits;
                    if (binExp == 0) {
                        while ((fractBits & 0x10000000000000L) == 0L) {
                            fractBits <<= 1;
                            --binExp;
                        }
                        nSignificantBits = 53 + binExp;
                        ++binExp;
                    } else {
                        fractBits |= 0x10000000000000L;
                        nSignificantBits = 53;
                    }
                    len = this.dtoa(b2, offset, val, neg, false, digits, binExp -= 1023, fractBits, nSignificantBits);
                }
            }
            b2[byteoffset] = (byte)len;
            bindIndicators[indoffset] = 0;
            bindIndicators[lenoffset] = (short)(len + 1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DoubleBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.DoubleBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

