/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

class FDBigInt {
    int nWords;
    int[] data;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FDBigInt(int v) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(v));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.nWords = 1;
            this.data = new int[1];
            this.data[0] = v;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FDBigInt(long v) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(v));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.data = new int[2];
            this.data[0] = (int)v;
            this.data[1] = (int)(v >>> 32);
            this.nWords = this.data[1] == 0 ? 1 : 2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FDBigInt(FDBigInt other) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(other));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.nWords = other.nWords;
            this.data = new int[this.nWords];
            System.arraycopy(other.data, 0, this.data, 0, this.nWords);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FDBigInt(int[] d2, int n2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(d2) + ", " + OracleLog.argument(n2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.data = d2;
            this.nWords = n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lshiftMe(int c2) throws IllegalArgumentException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (c2 <= 0) {
                if (c2 == 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "negative shift count");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("negative shift count");
            }
            int wordcount = c2 >> 5;
            int bitcount = c2 & 0x1F;
            int anticount = 32 - bitcount;
            int[] t = this.data;
            int[] s2 = this.data;
            if (this.nWords + wordcount + 1 > t.length) {
                t = new int[this.nWords + wordcount + 1];
            }
            int target = this.nWords + wordcount;
            int src = this.nWords - 1;
            if (bitcount == 0) {
                System.arraycopy(s2, 0, t, wordcount, this.nWords);
                target = wordcount - 1;
            } else {
                t[target--] = s2[src] >>> anticount;
                while (src >= 1) {
                    t[target--] = s2[src] << bitcount | s2[--src] >>> anticount;
                }
                t[target--] = s2[src] << bitcount;
            }
            while (target >= 0) {
                t[target--] = 0;
            }
            this.data = t;
            this.nWords += wordcount + 1;
            while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
                --this.nWords;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int normalizeMe() throws IllegalArgumentException {
        long __ol_nanos__ = 0L;
        try {
            int src;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int wordcount = 0;
            int bitcount = 0;
            int v = 0;
            for (src = this.nWords - 1; src >= 0 && (v = this.data[src]) == 0; --src) {
                ++wordcount;
            }
            if (src < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "zero value");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("zero value");
            }
            this.nWords -= wordcount;
            if ((v & 0xF0000000) != 0) {
                bitcount = 32;
                while ((v & 0xF0000000) != 0) {
                    v >>>= 1;
                    --bitcount;
                }
            } else {
                while (v <= 1048575) {
                    v <<= 8;
                    bitcount += 8;
                }
                while (v <= 0x7FFFFFF) {
                    v <<= 1;
                    ++bitcount;
                }
            }
            if (bitcount != 0) {
                this.lshiftMe(bitcount);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bitcount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = bitcount;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FDBigInt mult(int iv) {
        long __ol_nanos__ = 0L;
        try {
            long v;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(iv));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int[] r2 = new int[(v = (long)iv) * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
            long p2 = 0L;
            for (int i2 = 0; i2 < this.nWords; ++i2) {
                r2[i2] = (int)(p2 += v * ((long)this.data[i2] & 0xFFFFFFFFL));
                p2 >>>= 32;
            }
            if (p2 == 0L) {
                FDBigInt __result__ = new FDBigInt(r2, this.nWords);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                FDBigInt fDBigInt = __result__;
                return fDBigInt;
            }
            r2[this.nWords] = (int)p2;
            FDBigInt __result__ = new FDBigInt(r2, this.nWords + 1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            FDBigInt fDBigInt = __result__;
            return fDBigInt;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FDBigInt mult(FDBigInt other) {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(other));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int[] r2 = new int[this.nWords + other.nWords];
            for (i2 = 0; i2 < this.nWords; ++i2) {
                long v = (long)this.data[i2] & 0xFFFFFFFFL;
                long p2 = 0L;
                for (int j2 = 0; j2 < other.nWords; ++j2) {
                    r2[i2 + j2] = (int)(p2 += ((long)r2[i2 + j2] & 0xFFFFFFFFL) + v * ((long)other.data[j2] & 0xFFFFFFFFL));
                    p2 >>>= 32;
                }
                r2[i2 + j2] = (int)p2;
            }
            for (i2 = r2.length - 1; i2 > 0 && r2[i2] == 0; --i2) {
            }
            FDBigInt __result__ = new FDBigInt(r2, i2 + 1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            FDBigInt fDBigInt = __result__;
            return fDBigInt;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FDBigInt add(FDBigInt other) {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            int m2;
            int[] b2;
            int n2;
            int[] a2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(other));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long c2 = 0L;
            if (this.nWords >= other.nWords) {
                a2 = this.data;
                n2 = this.nWords;
                b2 = other.data;
                m2 = other.nWords;
            } else {
                a2 = other.data;
                n2 = other.nWords;
                b2 = this.data;
                m2 = this.nWords;
            }
            int[] r2 = new int[n2];
            for (i2 = 0; i2 < n2; ++i2) {
                c2 += (long)a2[i2] & 0xFFFFFFFFL;
                if (i2 < m2) {
                    c2 += (long)b2[i2] & 0xFFFFFFFFL;
                }
                r2[i2] = (int)c2;
                c2 >>= 32;
            }
            if (c2 != 0L) {
                int[] s2 = new int[r2.length + 1];
                System.arraycopy(r2, 0, s2, 0, r2.length);
                s2[i2++] = (int)c2;
                FDBigInt __result__ = new FDBigInt(s2, i2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                FDBigInt fDBigInt = __result__;
                return fDBigInt;
            }
            FDBigInt __result__ = new FDBigInt(r2, i2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            FDBigInt fDBigInt = __result__;
            return fDBigInt;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int cmp(FDBigInt other) {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            int j2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(other));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.nWords > other.nWords) {
                j2 = other.nWords - 1;
                for (i2 = this.nWords - 1; i2 > j2; --i2) {
                    if (this.data[i2] == 0) continue;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = 1;
                    return n2;
                }
            } else if (this.nWords < other.nWords) {
                j2 = this.nWords - 1;
                for (i2 = other.nWords - 1; i2 > j2; --i2) {
                    if (other.data[i2] == 0) continue;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n3 = -1;
                    return n3;
                }
            } else {
                i2 = this.nWords - 1;
            }
            while (i2 > 0 && this.data[i2] == other.data[i2]) {
                --i2;
            }
            int a2 = this.data[i2];
            int b2 = other.data[i2];
            if (a2 < 0) {
                if (b2 < 0) {
                    int __result__ = a2 - b2;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n4 = __result__;
                    return n4;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __result__ = 1;
                return __result__;
            }
            if (b2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __result__ = -1;
                return __result__;
            }
            int __result__ = a2 - b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n5 = __result__;
            return n5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int quoRemIteration(FDBigInt S) throws IllegalArgumentException {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(S));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.nWords != S.nWords) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "disparate values");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("disparate values");
            }
            int n2 = this.nWords - 1;
            long q2 = ((long)this.data[n2] & 0xFFFFFFFFL) / (long)S.data[n2];
            long diff = 0L;
            for (int i3 = 0; i3 <= n2; ++i3) {
                this.data[i3] = (int)(diff += ((long)this.data[i3] & 0xFFFFFFFFL) - q2 * ((long)S.data[i3] & 0xFFFFFFFFL));
                diff >>= 32;
            }
            if (diff != 0L) {
                long sum = 0L;
                while (sum == 0L) {
                    sum = 0L;
                    for (i2 = 0; i2 <= n2; ++i2) {
                        this.data[i2] = (int)(sum += ((long)this.data[i2] & 0xFFFFFFFFL) + ((long)S.data[i2] & 0xFFFFFFFFL));
                        sum >>= 32;
                    }
                    if (sum != 0L && sum != 1L) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                FDBigInt.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing RuntimeException: " + "Assertion botch: " + sum + " carry out of division correction");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new RuntimeException("Assertion botch: " + sum + " carry out of division correction");
                    }
                    --q2;
                }
            }
            long p2 = 0L;
            for (i2 = 0; i2 <= n2; ++i2) {
                this.data[i2] = (int)(p2 += 10L * ((long)this.data[i2] & 0xFFFFFFFFL));
                p2 >>= 32;
            }
            if (p2 != 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        FDBigInt.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing RuntimeException: " + "Assertion botch: carry out of *10");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new RuntimeException("Assertion botch: carry out of *10");
            }
            int __result__ = (int)q2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FDBigInt.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.FDBigInt"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

