/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BLOB;

class OracleBlobOutputStream
extends OutputStream {
    long lobOffset;
    BLOB blob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobOutputStream(BLOB blob, int bufferSize) throws SQLException {
        block12: {
            this(blob, bufferSize, 1L);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(bufferSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobOutputStream(BLOB blob, int bufferSize, long offset) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            PhysicalConnection pConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(bufferSize) + ", " + OracleLog.argument(offset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (blob == null || bufferSize <= 0 || offset < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "Illegal Arguments");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("Illegal Arguments");
            }
            this.blob = blob;
            this.lobOffset = offset;
            PhysicalConnection physicalConnection = pConnection = (PhysicalConnection)blob.getInternalConnection();
            synchronized (physicalConnection) {
                this.buf = pConnection.getByteBuffer(bufferSize);
            }
            this.count = 0;
            this.bufSize = bufferSize;
            this.isClosed = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b2) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ensureOpen();
            if (this.count >= this.bufSize) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)b2;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        long __ol_nanos__;
        block24: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(b2) + ", " + OracleLog.argument(off) + ", " + OracleLog.argument(len));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.ensureOpen();
                int start = off;
                int lengthToWrite = Math.min(len, b2.length - off);
                if (lengthToWrite >= 2 * this.bufSize) {
                    if (this.count > 0) {
                        this.flushBuffer();
                    }
                    try {
                        this.lobOffset += (long)this.blob.setBytes(this.lobOffset, b2, off, lengthToWrite);
                        break block24;
                    }
                    catch (SQLException e2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleBlobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        IOException __ex__ = DatabaseError.createIOException(e2);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                int end = start + lengthToWrite;
                while (start < end) {
                    int bytesWritten = Math.min(this.bufSize - this.count, end - start);
                    System.arraycopy(b2, start, this.buf, this.count, bytesWritten);
                    start += bytesWritten;
                    this.count += bytesWritten;
                    if (this.count < this.bufSize) continue;
                    this.flushBuffer();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.ensureOpen();
            this.flushBuffer();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        long __ol_nanos__;
        block40: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!this.isClosed) break block40;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        try {
            this.isClosed = true;
            this.flushBuffer();
        }
        finally {
            try {
                PhysicalConnection pConnection;
                PhysicalConnection physicalConnection = pConnection = (PhysicalConnection)this.blob.getInternalConnection();
                synchronized (physicalConnection) {
                    if (this.buf != null) {
                        pConnection.cacheBuffer(this.buf);
                        this.buf = null;
                    }
                }
            }
            catch (SQLException ea) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + ea);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException __ex__ = DatabaseError.createIOException(ea);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleBlobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                if (this.count > 0) {
                    this.lobOffset += (long)this.blob.setBytes(this.lobOffset, this.buf, 0, this.count);
                    this.count = 0;
                }
            }
            catch (SQLException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException __ex__ = DatabaseError.createIOException(e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        block24: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (!this.isClosed) break block24;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleBlobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleBlobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                OracleConnection __result__ = this.blob.getInternalConnection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleConnection oracleConnection = __result__;
                return oracleConnection;
            }
            catch (Exception exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleConnection oracleConnection = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return oracleConnection;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleBlobOutputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

