/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class OracleResultSet
implements oracle.jdbc.internal.OracleResultSet {
    static final boolean DEBUG = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleResultSet() {
    }

    int getFirstUserColumnIndex() throws SQLException {
        return 0;
    }

    @Override
    public abstract void closeStatementOnClose() throws SQLException;

    @Override
    public abstract Array getArray(int var1) throws SQLException;

    @Override
    public abstract BigDecimal getBigDecimal(int var1) throws SQLException;

    @Override
    public abstract BigDecimal getBigDecimal(int var1, int var2) throws SQLException;

    @Override
    public abstract Blob getBlob(int var1) throws SQLException;

    @Override
    public abstract boolean getBoolean(int var1) throws SQLException;

    @Override
    public abstract byte getByte(int var1) throws SQLException;

    @Override
    public abstract byte[] getBytes(int var1) throws SQLException;

    @Override
    public abstract Clob getClob(int var1) throws SQLException;

    @Override
    public abstract Date getDate(int var1) throws SQLException;

    @Override
    public abstract Date getDate(int var1, Calendar var2) throws SQLException;

    @Override
    public abstract double getDouble(int var1) throws SQLException;

    @Override
    public abstract float getFloat(int var1) throws SQLException;

    @Override
    public abstract int getInt(int var1) throws SQLException;

    @Override
    public abstract long getLong(int var1) throws SQLException;

    @Override
    public abstract NClob getNClob(int var1) throws SQLException;

    @Override
    public abstract String getNString(int var1) throws SQLException;

    @Override
    public abstract Object getObject(int var1) throws SQLException;

    public abstract Object getObject(int var1, Map var2) throws SQLException;

    @Override
    public abstract Ref getRef(int var1) throws SQLException;

    @Override
    public abstract RowId getRowId(int var1) throws SQLException;

    @Override
    public abstract short getShort(int var1) throws SQLException;

    @Override
    public abstract SQLXML getSQLXML(int var1) throws SQLException;

    @Override
    public abstract String getString(int var1) throws SQLException;

    @Override
    public abstract Time getTime(int var1) throws SQLException;

    @Override
    public abstract Time getTime(int var1, Calendar var2) throws SQLException;

    @Override
    public abstract Timestamp getTimestamp(int var1) throws SQLException;

    @Override
    public abstract Timestamp getTimestamp(int var1, Calendar var2) throws SQLException;

    @Override
    public abstract URL getURL(int var1) throws SQLException;

    @Override
    public abstract ARRAY getARRAY(int var1) throws SQLException;

    @Override
    public abstract BFILE getBFILE(int var1) throws SQLException;

    @Override
    public abstract BFILE getBfile(int var1) throws SQLException;

    @Override
    public abstract BLOB getBLOB(int var1) throws SQLException;

    @Override
    public abstract CHAR getCHAR(int var1) throws SQLException;

    @Override
    public abstract CLOB getCLOB(int var1) throws SQLException;

    @Override
    public abstract ResultSet getCursor(int var1) throws SQLException;

    @Override
    public abstract CustomDatum getCustomDatum(int var1, CustomDatumFactory var2) throws SQLException;

    @Override
    public abstract DATE getDATE(int var1) throws SQLException;

    @Override
    public abstract INTERVALDS getINTERVALDS(int var1) throws SQLException;

    @Override
    public abstract INTERVALYM getINTERVALYM(int var1) throws SQLException;

    @Override
    public abstract NUMBER getNUMBER(int var1) throws SQLException;

    @Override
    public abstract OPAQUE getOPAQUE(int var1) throws SQLException;

    @Override
    public abstract Datum getOracleObject(int var1) throws SQLException;

    @Override
    public abstract ORAData getORAData(int var1, ORADataFactory var2) throws SQLException;

    @Override
    public abstract RAW getRAW(int var1) throws SQLException;

    @Override
    public abstract REF getREF(int var1) throws SQLException;

    @Override
    public abstract ROWID getROWID(int var1) throws SQLException;

    @Override
    public abstract STRUCT getSTRUCT(int var1) throws SQLException;

    @Override
    public abstract TIMESTAMPLTZ getTIMESTAMPLTZ(int var1) throws SQLException;

    @Override
    public abstract TIMESTAMPTZ getTIMESTAMPTZ(int var1) throws SQLException;

    @Override
    public abstract TIMESTAMP getTIMESTAMP(int var1) throws SQLException;

    @Override
    public abstract InputStream getAsciiStream(int var1) throws SQLException;

    @Override
    public abstract InputStream getBinaryStream(int var1) throws SQLException;

    @Override
    public abstract Reader getCharacterStream(int var1) throws SQLException;

    @Override
    public abstract Reader getNCharacterStream(int var1) throws SQLException;

    @Override
    public abstract InputStream getUnicodeStream(int var1) throws SQLException;

    @Override
    public abstract void updateArray(int var1, Array var2) throws SQLException;

    @Override
    public abstract void updateBigDecimal(int var1, BigDecimal var2) throws SQLException;

    @Override
    public abstract void updateBlob(int var1, Blob var2) throws SQLException;

    @Override
    public abstract void updateBoolean(int var1, boolean var2) throws SQLException;

    @Override
    public abstract void updateByte(int var1, byte var2) throws SQLException;

    @Override
    public abstract void updateBytes(int var1, byte[] var2) throws SQLException;

    @Override
    public abstract void updateClob(int var1, Clob var2) throws SQLException;

    @Override
    public abstract void updateDate(int var1, Date var2) throws SQLException;

    public abstract void updateDate(int var1, Date var2, Calendar var3) throws SQLException;

    @Override
    public abstract void updateDouble(int var1, double var2) throws SQLException;

    @Override
    public abstract void updateFloat(int var1, float var2) throws SQLException;

    @Override
    public abstract void updateInt(int var1, int var2) throws SQLException;

    @Override
    public abstract void updateLong(int var1, long var2) throws SQLException;

    @Override
    public abstract void updateNClob(int var1, NClob var2) throws SQLException;

    @Override
    public abstract void updateNString(int var1, String var2) throws SQLException;

    @Override
    public abstract void updateObject(int var1, Object var2) throws SQLException;

    @Override
    public abstract void updateObject(int var1, Object var2, int var3) throws SQLException;

    @Override
    public abstract void updateRef(int var1, Ref var2) throws SQLException;

    @Override
    public abstract void updateRowId(int var1, RowId var2) throws SQLException;

    @Override
    public abstract void updateShort(int var1, short var2) throws SQLException;

    @Override
    public abstract void updateSQLXML(int var1, SQLXML var2) throws SQLException;

    @Override
    public abstract void updateString(int var1, String var2) throws SQLException;

    @Override
    public abstract void updateTime(int var1, Time var2) throws SQLException;

    public abstract void updateTime(int var1, Time var2, Calendar var3) throws SQLException;

    @Override
    public abstract void updateTimestamp(int var1, Timestamp var2) throws SQLException;

    public abstract void updateTimestamp(int var1, Timestamp var2, Calendar var3) throws SQLException;

    public abstract void updateURL(int var1, URL var2) throws SQLException;

    @Override
    public abstract void updateARRAY(int var1, ARRAY var2) throws SQLException;

    @Override
    public abstract void updateBFILE(int var1, BFILE var2) throws SQLException;

    @Override
    public abstract void updateBfile(int var1, BFILE var2) throws SQLException;

    public abstract void updateBinaryFloat(int var1, float var2) throws SQLException;

    public abstract void updateBinaryFloat(int var1, BINARY_FLOAT var2) throws SQLException;

    public abstract void updateBinaryDouble(int var1, double var2) throws SQLException;

    public abstract void updateBinaryDouble(int var1, BINARY_DOUBLE var2) throws SQLException;

    @Override
    public abstract void updateBLOB(int var1, BLOB var2) throws SQLException;

    @Override
    public abstract void updateCHAR(int var1, CHAR var2) throws SQLException;

    @Override
    public abstract void updateCLOB(int var1, CLOB var2) throws SQLException;

    public abstract void updateCursor(int var1, ResultSet var2) throws SQLException;

    @Override
    public abstract void updateCustomDatum(int var1, CustomDatum var2) throws SQLException;

    @Override
    public abstract void updateDATE(int var1, DATE var2) throws SQLException;

    public abstract void updateFixedCHAR(int var1, String var2) throws SQLException;

    @Override
    public abstract void updateINTERVALDS(int var1, INTERVALDS var2) throws SQLException;

    @Override
    public abstract void updateINTERVALYM(int var1, INTERVALYM var2) throws SQLException;

    @Override
    public abstract void updateNUMBER(int var1, NUMBER var2) throws SQLException;

    public abstract void updateOPAQUE(int var1, OPAQUE var2) throws SQLException;

    @Override
    public abstract void updateOracleObject(int var1, Datum var2) throws SQLException;

    @Override
    public abstract void updateORAData(int var1, ORAData var2) throws SQLException;

    @Override
    public abstract void updateRAW(int var1, RAW var2) throws SQLException;

    @Override
    public abstract void updateREF(int var1, REF var2) throws SQLException;

    public abstract void updateRefType(int var1, REF var2) throws SQLException;

    @Override
    public abstract void updateROWID(int var1, ROWID var2) throws SQLException;

    @Override
    public abstract void updateSTRUCT(int var1, STRUCT var2) throws SQLException;

    @Override
    public abstract void updateTIMESTAMPLTZ(int var1, TIMESTAMPLTZ var2) throws SQLException;

    @Override
    public abstract void updateTIMESTAMPTZ(int var1, TIMESTAMPTZ var2) throws SQLException;

    @Override
    public abstract void updateTIMESTAMP(int var1, TIMESTAMP var2) throws SQLException;

    @Override
    public abstract void updateBlob(int var1, InputStream var2) throws SQLException;

    @Override
    public abstract void updateBlob(int var1, InputStream var2, long var3) throws SQLException;

    @Override
    public abstract void updateClob(int var1, Reader var2) throws SQLException;

    @Override
    public abstract void updateClob(int var1, Reader var2, long var3) throws SQLException;

    @Override
    public abstract void updateNClob(int var1, Reader var2) throws SQLException;

    @Override
    public abstract void updateNClob(int var1, Reader var2, long var3) throws SQLException;

    @Override
    public abstract void updateAsciiStream(int var1, InputStream var2) throws SQLException;

    @Override
    public abstract void updateAsciiStream(int var1, InputStream var2, int var3) throws SQLException;

    @Override
    public abstract void updateAsciiStream(int var1, InputStream var2, long var3) throws SQLException;

    @Override
    public abstract void updateBinaryStream(int var1, InputStream var2) throws SQLException;

    @Override
    public abstract void updateBinaryStream(int var1, InputStream var2, int var3) throws SQLException;

    @Override
    public abstract void updateBinaryStream(int var1, InputStream var2, long var3) throws SQLException;

    @Override
    public abstract void updateCharacterStream(int var1, Reader var2) throws SQLException;

    @Override
    public abstract void updateCharacterStream(int var1, Reader var2, int var3) throws SQLException;

    @Override
    public abstract void updateCharacterStream(int var1, Reader var2, long var3) throws SQLException;

    @Override
    public abstract void updateNCharacterStream(int var1, Reader var2) throws SQLException;

    @Override
    public abstract void updateNCharacterStream(int var1, Reader var2, long var3) throws SQLException;

    public abstract void updateUnicodeStream(int var1, InputStream var2, int var3) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(String columnName) throws SQLException {
        Array array;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Array __result__ = this.getArray(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            array = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        BigDecimal bigDecimal;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            BigDecimal __result__ = this.getBigDecimal(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bigDecimal = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String columnName, int y) throws SQLException {
        BigDecimal bigDecimal;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            BigDecimal __result__ = this.getBigDecimal(this.findColumn(columnName), y);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bigDecimal = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(String columnName) throws SQLException {
        Blob blob;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Blob __result__ = this.getBlob(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            blob = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean __result__ = this.getBoolean(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String columnName) throws SQLException {
        byte by;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte __result__ = this.getByte(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            by = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        byte[] byArray;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = this.getBytes(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(String columnName) throws SQLException {
        Clob clob;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Clob __result__ = this.getClob(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            clob = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return clob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String columnName) throws SQLException {
        Date date;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Date __result__ = this.getDate(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            date = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String columnName, Calendar y) throws SQLException {
        Date date;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Date __result__ = this.getDate(this.findColumn(columnName), y);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            date = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String columnName) throws SQLException {
        double d2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            double __result__ = this.getDouble(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            d2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String columnName) throws SQLException {
        float f2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            float __result__ = this.getFloat(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            f2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String columnName) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = this.getInt(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String columnName) throws SQLException {
        long l2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long __result__ = this.getLong(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(String columnName) throws SQLException {
        NClob nClob;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            NClob __result__ = this.getNClob(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nClob = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nClob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(String columnName) throws SQLException {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.getNString(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String columnName) throws SQLException {
        Object object;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Object __result__ = this.getObject(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String columnName, Map y) throws SQLException {
        Object object;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Object __result__ = this.getObject(this.findColumn(columnName), y);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(String columnName) throws SQLException {
        Ref ref;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Ref __result__ = this.getRef(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ref = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(String columnName) throws SQLException {
        RowId rowId;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            RowId __result__ = this.getRowId(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rowId = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String columnName) throws SQLException {
        short s2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            short __result__ = this.getShort(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            s2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        SQLXML sQLXML;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            SQLXML __result__ = this.getSQLXML(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sQLXML = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sQLXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String columnName) throws SQLException {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.getString(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String columnName) throws SQLException {
        Time time;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Time __result__ = this.getTime(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            time = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String columnName, Calendar y) throws SQLException {
        Time time;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Time __result__ = this.getTime(this.findColumn(columnName), y);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            time = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        Timestamp timestamp;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Timestamp __result__ = this.getTimestamp(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timestamp = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String columnName, Calendar y) throws SQLException {
        Timestamp timestamp;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Timestamp __result__ = this.getTimestamp(this.findColumn(columnName), y);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            timestamp = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(String columnName) throws SQLException {
        URL uRL;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            URL __result__ = this.getURL(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            uRL = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(String columnName) throws SQLException {
        ARRAY aRRAY;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ARRAY __result__ = this.getARRAY(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            aRRAY = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(String columnName) throws SQLException {
        BFILE bFILE;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            BFILE __result__ = this.getBFILE(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bFILE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bFILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(String columnName) throws SQLException {
        BFILE bFILE;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            BFILE __result__ = this.getBfile(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bFILE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bFILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(String columnName) throws SQLException {
        BLOB bLOB;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            BLOB __result__ = this.getBLOB(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(String columnName) throws SQLException {
        CHAR cHAR;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CHAR __result__ = this.getCHAR(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            cHAR = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return cHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(String columnName) throws SQLException {
        CLOB cLOB;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CLOB __result__ = this.getCLOB(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            cLOB = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(String columnName) throws SQLException {
        ResultSet resultSet;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ResultSet __result__ = this.getCursor(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            resultSet = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(String columnName, CustomDatumFactory y) throws SQLException {
        CustomDatum customDatum;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CustomDatum __result__ = this.getCustomDatum(this.findColumn(columnName), y);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            customDatum = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return customDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(String columnName) throws SQLException {
        DATE dATE;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            DATE __result__ = this.getDATE(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dATE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(String columnName) throws SQLException {
        INTERVALDS iNTERVALDS;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            INTERVALDS __result__ = this.getINTERVALDS(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            iNTERVALDS = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return iNTERVALDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(String columnName) throws SQLException {
        INTERVALYM iNTERVALYM;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            INTERVALYM __result__ = this.getINTERVALYM(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            iNTERVALYM = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return iNTERVALYM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(String columnName) throws SQLException {
        NUMBER nUMBER;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            NUMBER __result__ = this.getNUMBER(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nUMBER = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(String columnName) throws SQLException {
        OPAQUE oPAQUE;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OPAQUE __result__ = this.getOPAQUE(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oPAQUE = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oPAQUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(String columnName) throws SQLException {
        Datum datum;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Datum __result__ = this.getOracleObject(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            datum = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(String columnName, ORADataFactory y) throws SQLException {
        ORAData oRAData;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ORAData __result__ = this.getORAData(this.findColumn(columnName), y);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oRAData = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oRAData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(String columnName) throws SQLException {
        RAW rAW;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            RAW __result__ = this.getRAW(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rAW = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rAW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(String columnName) throws SQLException {
        REF rEF;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            REF __result__ = this.getREF(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rEF = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(String columnName) throws SQLException {
        ROWID rOWID;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ROWID __result__ = this.getROWID(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            rOWID = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return rOWID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(String columnName) throws SQLException {
        STRUCT sTRUCT;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            STRUCT __result__ = this.getSTRUCT(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            sTRUCT = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(String columnName) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPLTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(String columnName) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMPTZ = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(String columnName) throws SQLException {
        TIMESTAMP tIMESTAMP;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMP __result__ = this.getTIMESTAMP(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            tIMESTAMP = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        InputStream inputStream;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            InputStream __result__ = this.getAsciiStream(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        InputStream inputStream;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            InputStream __result__ = this.getBinaryStream(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        Reader reader;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Reader __result__ = this.getCharacterStream(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            reader = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        Reader reader;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Reader __result__ = this.getNCharacterStream(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            reader = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        InputStream inputStream;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            InputStream __result__ = this.getUnicodeStream(this.findColumn(columnName));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            inputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArray(String columnName, Array value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateArray(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBigDecimal(String columnName, BigDecimal value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBigDecimal(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String columnName, Blob value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBlob(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBoolean(String columnName, boolean value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBoolean(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByte(String columnName, byte value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateByte(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBytes(String columnName, byte[] value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBytes(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String columnName, Clob value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateClob(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDate(String columnName, Date value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateDate(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(String columnName, Date value, Calendar y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateDate(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDouble(String columnName, double value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateDouble(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFloat(String columnName, float value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateFloat(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInt(String columnName, int value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateInt(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLong(String columnName, long value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateLong(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String columnName, NClob value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateNClob(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNString(String columnName, String value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateNString(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String columnName, Object value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateObject(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(String columnName, Object value, int y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateObject(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRef(String columnName, Ref value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateRef(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRowId(String columnName, RowId value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateRowId(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShort(String columnName, short value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateShort(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSQLXML(String columnName, SQLXML value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateSQLXML(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(String columnName, String value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateString(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTime(String columnName, Time value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateTime(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(String columnName, Time value, Calendar y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateTime(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimestamp(String columnName, Timestamp value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateTimestamp(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(String columnName, Timestamp value, Calendar y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateTimestamp(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateURL(String columnName, URL value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateURL(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateARRAY(String columnName, ARRAY value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateARRAY(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBFILE(String columnName, BFILE value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBFILE(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBfile(String columnName, BFILE value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBfile(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryFloat(String columnName, float value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBinaryFloat(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryFloat(String columnName, BINARY_FLOAT value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBinaryFloat(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryDouble(String columnName, double value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBinaryDouble(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryDouble(String columnName, BINARY_DOUBLE value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBinaryDouble(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBLOB(String columnName, BLOB value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBLOB(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCHAR(String columnName, CHAR value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateCHAR(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCLOB(String columnName, CLOB value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateCLOB(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursor(String columnName, ResultSet value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateCursor(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCustomDatum(String columnName, CustomDatum value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateCustomDatum(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDATE(String columnName, DATE value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateDATE(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFixedCHAR(String columnName, String value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateFixedCHAR(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateINTERVALDS(String columnName, INTERVALDS value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateINTERVALDS(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateINTERVALYM(String columnName, INTERVALYM value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateINTERVALYM(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNUMBER(String columnName, NUMBER value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateNUMBER(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOPAQUE(String columnName, OPAQUE value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateOPAQUE(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOracleObject(String columnName, Datum value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateOracleObject(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateORAData(String columnName, ORAData value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateORAData(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRAW(String columnName, RAW value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateRAW(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateREF(String columnName, REF value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateREF(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRefType(String columnName, REF value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateRefType(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateROWID(String columnName, ROWID value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateROWID(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSTRUCT(String columnName, STRUCT value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateSTRUCT(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTIMESTAMPLTZ(String columnName, TIMESTAMPLTZ value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateTIMESTAMPLTZ(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTIMESTAMPTZ(String columnName, TIMESTAMPTZ value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateTIMESTAMPTZ(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTIMESTAMP(String columnName, TIMESTAMP value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateTIMESTAMP(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String columnName, InputStream value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBlob(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlob(String columnName, InputStream value, long y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBlob(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String columnName, Reader value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateClob(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClob(String columnName, Reader value, long y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateClob(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String columnName, Reader value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateNClob(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNClob(String columnName, Reader value, long y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateNClob(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String columnName, InputStream value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateAsciiStream(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String columnName, InputStream value, int y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateAsciiStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAsciiStream(String columnName, InputStream value, long y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateAsciiStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String columnName, InputStream value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBinaryStream(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String columnName, InputStream value, int y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBinaryStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBinaryStream(String columnName, InputStream value, long y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateBinaryStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String columnName, Reader value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateCharacterStream(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String columnName, Reader value, int y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateCharacterStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharacterStream(String columnName, Reader value, long y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateCharacterStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String columnName, Reader value) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateNCharacterStream(this.findColumn(columnName), value);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNCharacterStream(String columnName, Reader value, long y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateNCharacterStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnicodeStream(String columnName, InputStream value, int y) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(y));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateUnicodeStream(this.findColumn(columnName), value, y);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    @Override
    public abstract OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int var1) throws SQLException;

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(String columnName) throws SQLException {
        return this.getAuthorizationIndicator(this.findColumn(columnName));
    }

    public abstract void setAutoRefetch(boolean var1) throws SQLException;

    public abstract boolean getAutoRefetch() throws SQLException;

    @Override
    public abstract SQLWarning getWarnings() throws SQLException;

    @Override
    public abstract void clearWarnings() throws SQLException;

    @Override
    public abstract String getCursorName() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract int findColumn(String var1) throws SQLException;

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract void close() throws SQLException;

    @Override
    public abstract boolean wasNull() throws SQLException;

    @Override
    public abstract boolean isBeforeFirst() throws SQLException;

    @Override
    public abstract boolean isAfterLast() throws SQLException;

    @Override
    public abstract boolean isFirst() throws SQLException;

    @Override
    public abstract boolean isLast() throws SQLException;

    @Override
    public abstract void beforeFirst() throws SQLException;

    @Override
    public abstract void afterLast() throws SQLException;

    @Override
    public abstract boolean first() throws SQLException;

    @Override
    public abstract boolean last() throws SQLException;

    @Override
    public abstract int getRow() throws SQLException;

    @Override
    public abstract boolean absolute(int var1) throws SQLException;

    @Override
    public abstract boolean relative(int var1) throws SQLException;

    @Override
    public abstract boolean previous() throws SQLException;

    @Override
    public abstract void setFetchDirection(int var1) throws SQLException;

    @Override
    public abstract int getFetchDirection() throws SQLException;

    @Override
    public abstract void setFetchSize(int var1) throws SQLException;

    @Override
    public abstract int getFetchSize() throws SQLException;

    @Override
    public abstract int getType() throws SQLException;

    @Override
    public abstract int getConcurrency() throws SQLException;

    @Override
    public abstract void insertRow() throws SQLException;

    @Override
    public abstract void updateRow() throws SQLException;

    @Override
    public abstract void deleteRow() throws SQLException;

    @Override
    public abstract void refreshRow() throws SQLException;

    @Override
    public abstract void moveToInsertRow() throws SQLException;

    @Override
    public abstract void cancelRowUpdates() throws SQLException;

    @Override
    public abstract void moveToCurrentRow() throws SQLException;

    @Override
    public abstract Statement getStatement() throws SQLException;

    @Override
    public abstract boolean rowUpdated() throws SQLException;

    @Override
    public abstract boolean rowInserted() throws SQLException;

    @Override
    public abstract boolean rowDeleted() throws SQLException;

    @Override
    public abstract void updateNull(int var1) throws SQLException;

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        block24: {
            boolean bl;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(iface));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!iface.isInterface()) break block24;
                boolean __result__ = iface.isInstance(this);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        block24: {
            OracleResultSet oracleResultSet;
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(iface));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!iface.isInterface() || !iface.isInstance(this)) break block24;
                OracleResultSet __result__ = this;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSet = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return (T)oracleResultSet;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    abstract OracleStatement getOracleStatement() throws SQLException;

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

