/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8TTIpro
extends T4CTTIMsg {
    short svrCharSet;
    short svrCharSetElem;
    byte svrFlags;
    byte[] proSvrStr;
    byte proSvrVer;
    short oVersion = (short)-1;
    boolean svrInfoAvailable = false;
    byte[] proCliVerTTC8 = new byte[]{6, 5, 4, 3, 2, 1, 0};
    byte[] proCliStrTTC8 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 56, 46, 50, 46, 48, 0};
    short NCHAR_CHARSET = 0;
    byte[] runtimeCapabilities = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4C8TTIpro(T4CConnection _conn) throws SQLException, IOException {
        super(_conn, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] receive() throws SQLException, IOException {
        int j2;
        if (this.meg.unmarshalSB1() != 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4C8TTIpro.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 401);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.meg.proSvrVer = this.proSvrVer = this.meg.unmarshalSB1();
        switch (this.proSvrVer) {
            case 4: {
                this.oVersion = (short)7230;
                break;
            }
            case 5: {
                this.oVersion = (short)8030;
                break;
            }
            case 6: {
                this.oVersion = (short)8100;
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4C8TTIpro.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 444);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 444);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        this.meg.unmarshalSB1();
        this.proSvrStr = this.meg.unmarshalTEXT(50);
        this.oVersion = this.getOracleVersion();
        this.svrCharSet = (short)this.meg.unmarshalUB2();
        this.svrFlags = (byte)this.meg.unmarshalUB1();
        this.svrCharSetElem = (short)this.meg.unmarshalUB2();
        if (this.svrCharSetElem > 0) {
            this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
        }
        this.svrInfoAvailable = true;
        if (this.proSvrVer < 5) {
            return null;
        }
        byte rep = this.meg.types.getRep((byte)1);
        this.meg.types.setRep((byte)1, (byte)0);
        int fdoLength = this.meg.unmarshalUB2();
        this.meg.types.setRep((byte)1, rep);
        byte[] fdo = this.meg.unmarshalNBytes(fdoLength);
        int i2 = 6 + (fdo[5] & 0xFF) + (fdo[6] & 0xFF);
        this.NCHAR_CHARSET = (short)((fdo[i2 + 3] & 0xFF) << 8);
        this.NCHAR_CHARSET = (short)(this.NCHAR_CHARSET | (short)(fdo[i2 + 4] & 0xFF));
        if (this.proSvrVer < 6) {
            return null;
        }
        int len = this.meg.unmarshalUB1();
        byte[] sccap = new byte[len];
        for (j2 = 0; j2 < len; ++j2) {
            sccap[j2] = (byte)this.meg.unmarshalUB1();
        }
        len = this.meg.unmarshalUB1();
        if (len > 0) {
            this.runtimeCapabilities = new byte[len];
            for (j2 = 0; j2 < len; ++j2) {
                this.runtimeCapabilities[j2] = (byte)this.meg.unmarshalUB1();
            }
        }
        return sccap;
    }

    short getOracleVersion() {
        return this.oVersion;
    }

    byte[] getServerRuntimeCapabilities() {
        return this.runtimeCapabilities;
    }

    short getCharacterSet() {
        return this.svrCharSet;
    }

    short getncharCHARSET() {
        return this.NCHAR_CHARSET;
    }

    byte getFlags() {
        return this.svrFlags;
    }

    void marshal() throws SQLException, IOException {
        this.marshalTTCcode();
        this.meg.marshalB1Array(this.proCliVerTTC8);
        this.meg.marshalB1Array(this.proCliStrTTC8);
    }

    void printServerInfo() {
        if (this.svrInfoAvailable) {
            int i2 = 0;
            StringWriter s2 = new StringWriter();
            s2.write("Protocol string  =");
            while (i2 < this.proSvrStr.length) {
                s2.write((char)this.proSvrStr[i2++]);
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8TTIpro"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

