/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIsto
extends T4CTTIfun {
    static final short OV6STRT = 48;
    static final short OV6STOP = 49;
    static final int STOMFDBA = 1;
    static final int STOMFACA = 2;
    static final int STOMFALO = 4;
    static final int STOMFSHU = 8;
    static final int STOMFFRC = 16;
    static final int STOMFPOL = 32;
    static final int STOMFABO = 64;
    static final int STOMFATX = 128;
    static final int STOMFLTX = 256;
    static final int STOSDONE = 1;
    static final int STOSINPR = 2;
    static final int STOSERR = 3;
    private int inmode = 0;
    private int outmode = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIsto(T4CConnection _connection) {
        super(_connection, (byte)3);
    }

    void doOV6STRT(int mode) throws IOException, SQLException {
        this.setFunCode((short)48);
        this.inmode = mode;
        this.outmode = 0;
        this.doRPC();
    }

    void doOV6STOP(int mode) throws IOException, SQLException {
        this.setFunCode((short)49);
        this.inmode = mode;
        this.outmode = 0;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalSWORD(this.inmode);
        this.meg.marshalPTR();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.outmode = (int)this.meg.unmarshalUB4();
        if (this.outmode == 3) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIsto.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIsto.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIsto.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIsto"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

