/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.util;

import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public class RepConversion {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public static void printInHex(byte b2) {
        System.out.print((char)RepConversion.nibbleToHex((byte)((b2 & 0xF0) >> 4)));
        System.out.print((char)RepConversion.nibbleToHex((byte)(b2 & 0xF)));
    }

    public static byte nibbleToHex(byte nibble) {
        return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
    }

    public static byte asciiHexToNibble(byte b2) {
        byte value = b2 >= 97 && b2 <= 102 ? (byte)(b2 - 97 + 10) : (b2 >= 65 && b2 <= 70 ? (byte)(b2 - 65 + 10) : (b2 >= 48 && b2 <= 57 ? (byte)(b2 - 48) : b2));
        return value;
    }

    public static void bArray2Nibbles(byte[] array, byte[] nibbles) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            nibbles[i2 * 2] = RepConversion.nibbleToHex((byte)((array[i2] & 0xF0) >> 4));
            nibbles[i2 * 2 + 1] = RepConversion.nibbleToHex((byte)(array[i2] & 0xF));
        }
    }

    public static String bArray2String(byte[] array) {
        StringBuffer result = new StringBuffer(array.length * 2);
        for (int i2 = 0; i2 < array.length; ++i2) {
            result.append((char)RepConversion.nibbleToHex((byte)((array[i2] & 0xF0) >> 4)));
            result.append((char)RepConversion.nibbleToHex((byte)(array[i2] & 0xF)));
        }
        return result.toString();
    }

    public static byte[] nibbles2bArray(byte[] nibbles) {
        byte[] array = new byte[nibbles.length / 2];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = (byte)(RepConversion.asciiHexToNibble(nibbles[i2 * 2]) << 4);
            int n2 = i2;
            array[n2] = (byte)(array[n2] | RepConversion.asciiHexToNibble(nibbles[i2 * 2 + 1]));
        }
        return array;
    }

    public static void printInHex(long value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue, 0));
    }

    public static void printInHex(int value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue, 0));
    }

    public static void printInHex(short value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue, 0));
    }

    public static byte[] toHex(long value) {
        int lsize = 16;
        byte[] hex = new byte[lsize];
        for (int i2 = lsize - 1; i2 >= 0; --i2) {
            hex[i2] = RepConversion.nibbleToHex((byte)(value & 0xFL));
            value >>= 4;
        }
        return hex;
    }

    public static byte[] toHex(int value) {
        int lsize = 8;
        byte[] hex = new byte[lsize];
        for (int i2 = lsize - 1; i2 >= 0; --i2) {
            hex[i2] = RepConversion.nibbleToHex((byte)(value & 0xF));
            value >>= 4;
        }
        return hex;
    }

    public static byte[] toHex(short value) {
        int lsize = 4;
        byte[] hex = new byte[lsize];
        for (int i2 = lsize - 1; i2 >= 0; --i2) {
            hex[i2] = RepConversion.nibbleToHex((byte)(value & 0xF));
            value = (short)(value >> 4);
        }
        return hex;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.util");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.util.RepConversion"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

