/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class Datum
implements Serializable {
    private byte[] data;
    static final long serialVersionUID = 4645732484621936751L;

    public Datum() {
    }

    public Datum(byte[] newData) {
        this.data = newData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Datum)) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Datum od = (Datum)obj;
            if (this.data == null && od.data == null) {
                return true;
            }
            if (this.data == null && od.data != null || this.data != null && od.data == null) {
                return false;
            }
            if (this.data.length != od.data.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (this.data[i2] == od.data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] shareBytes() {
        return this.data;
    }

    public long getLength() {
        if (null == this.data) {
            return 0L;
        }
        return this.data.length;
    }

    public void setBytes(byte[] array) {
        int length = array.length;
        this.data = new byte[length];
        System.arraycopy(array, 0, this.data, 0, length);
    }

    public void setShareBytes(byte[] array) {
        this.data = array;
    }

    public byte[] getBytes() {
        byte[] tmp = new byte[this.data.length];
        System.arraycopy(this.data, 0, tmp, 0, this.data.length);
        return tmp;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String stringValue() throws SQLException {
        throw new SQLException("Conversion to String failed");
    }

    public String stringValue(Connection conn) throws SQLException {
        return this.stringValue();
    }

    public boolean booleanValue() throws SQLException {
        throw new SQLException("Conversion to boolean failed");
    }

    public int intValue() throws SQLException {
        throw new SQLException("Conversion to integer failed");
    }

    public long longValue() throws SQLException {
        throw new SQLException("Conversion to long failed");
    }

    public float floatValue() throws SQLException {
        throw new SQLException("Conversion to float failed");
    }

    public double doubleValue() throws SQLException {
        throw new SQLException("Conversion to double failed");
    }

    public byte byteValue() throws SQLException {
        throw new SQLException("Conversion to byte failed");
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        throw new SQLException("Conversion to BigDecimal failed");
    }

    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public Time timeValue() throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Time timeValue(Calendar cal) throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Timestamp timestampValue() throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Timestamp timestampValue(Calendar cal) throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Reader characterStreamValue() throws SQLException {
        throw new SQLException("Conversion to character stream failed");
    }

    public InputStream asciiStreamValue() throws SQLException {
        throw new SQLException("Conversion to ascii stream failed");
    }

    public InputStream binaryStreamValue() throws SQLException {
        throw new SQLException("Conversion to binary stream failed");
    }

    public abstract boolean isConvertibleTo(Class var1);

    public abstract Object toJdbc() throws SQLException;

    public abstract Object makeJdbcArray(int var1);

    protected static int compareBytes(byte[] m2, byte[] n2) {
        int ml = m2.length;
        int nl = n2.length;
        int cc = Math.min(ml, nl);
        int um = 0;
        int un = 0;
        for (int cl = 0; cl < cc; ++cl) {
            um = m2[cl] & 0xFF;
            un = n2[cl] & 0xFF;
            if (um == un) continue;
            if (um < un) {
                return -1;
            }
            return 1;
        }
        if (ml == nl) {
            return 0;
        }
        if (ml > nl) {
            return 1;
        }
        return -1;
    }
}

