/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_13:29:03_PDT_2010";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(BLOB blob, byte[] pattern, long startPos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long __result__ = LobPlsqlUtil.hasPattern(blob.getInternalConnection(), blob, 2004, pattern, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long isSubLob(BLOB blob, BLOB subLob, long startPos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long __result__ = LobPlsqlUtil.isSubLob(blob.getInternalConnection(), blob, 2004, subLob, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long hasPattern(CLOB clob, char[] pattern, long startPos) throws SQLException {
        long lobLen;
        long patternLen;
        OracleConnection conn;
        block83: {
            long __ol_nanos__ = 0L;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pattern == null || startPos <= 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = 0L;
                return l2;
            }
            conn = clob.getInternalConnection();
            patternLen = pattern.length;
            lobLen = LobPlsqlUtil.length(conn, clob, 2005);
            if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l3 = 0L;
                return l3;
            }
            if (patternLen <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn)) {
                OracleCallableStatement cstmt = null;
                try {
                    cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                    cstmt.registerOutParameter(1, 2);
                    if (clob.isNCLOB()) {
                        cstmt.setFormOfUse(2, (short)2);
                        cstmt.setFormOfUse(3, (short)2);
                    }
                    cstmt.setCLOB(2, clob);
                    cstmt.setString(3, new String(pattern));
                    cstmt.setLong(4, startPos);
                    cstmt.execute();
                    long __result__ = cstmt.getLong(1);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l4 = __result__;
                    return l4;
                }
                finally {
                    cstmt.close();
                    cstmt = null;
                }
            }
            break block83;
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        block53: while (true) {
            long subMatchedPos;
            char[] subPattern;
            int subPatternLen;
            if (!done) {
                if (patternLen > lobLen - subStartPos + 1L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l5 = 0L;
                    return l5;
                }
                matchedLen = 0;
                subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                subPattern = new char[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                if (subMatchedPos == 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l6 = 0L;
                    return l6;
                }
                matchedPos = subMatchedPos;
                matchedLen += subPatternLen;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l7 = matchedPos;
                return l7;
            }
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (true) {
                if (!moreChunks) continue block53;
                subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                subPattern = new char[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l8 = 0L;
                    return l8;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long isSubLob(CLOB clob, CLOB subLob, long startPos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (subLob == null || startPos <= 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = 0L;
                return l2;
            }
            OracleConnection conn = clob.getInternalConnection();
            long patternLen = LobPlsqlUtil.length(conn, subLob, 2005);
            long lobLen = LobPlsqlUtil.length(conn, clob, 2005);
            if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l3 = 0L;
                return l3;
            }
            if (patternLen <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn)) {
                char[] pattern = new char[(int)patternLen];
                subLob.getChars(1L, (int)patternLen, pattern);
                long __result__ = LobPlsqlUtil.hasPattern(clob, pattern, startPos);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l4 = __result__;
                return l4;
            }
            int matchedLen = 0;
            long subStartPos = startPos;
            boolean done = false;
            long matchedPos = 0L;
            while (!done) {
                if (patternLen > lobLen - subStartPos + 1L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l5 = 0L;
                    return l5;
                }
                matchedLen = 0;
                int subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                char[] subPattern = new char[subPatternLen];
                subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
                long subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                if (subMatchedPos == 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l6 = 0L;
                    return l6;
                }
                matchedPos = subMatchedPos;
                matchedLen += subPatternLen;
                subStartPos = subMatchedPos + (long)subPatternLen;
                boolean moreChunks = true;
                while (moreChunks) {
                    subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                    subPattern = new char[subPatternLen];
                    subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
                    subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                    if (subMatchedPos == subStartPos) {
                        subStartPos += (long)subPatternLen;
                        if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                        moreChunks = false;
                        done = true;
                        continue;
                    }
                    if (subMatchedPos == 0L) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        long l7 = 0L;
                        return l7;
                    }
                    subStartPos = subMatchedPos - (long)matchedLen;
                    moreChunks = false;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l8 = matchedPos;
            return l8;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(BFILE bfile, byte[] pattern, long startPos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long __result__ = LobPlsqlUtil.hasPattern(bfile.getInternalConnection(), bfile, -13, pattern, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long isSubLob(BFILE bfile, BFILE subLob, long startPos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long __result__ = LobPlsqlUtil.isSubLob(bfile.getInternalConnection(), bfile, -13, subLob, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileGetName(BFILE bfile) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleCallableStatement cstmt = null;
            String ret = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
                cstmt.setBFILE(1, bfile);
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 12);
                cstmt.execute();
                ret = cstmt.getString(3);
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileGetDirAlias(BFILE bfile) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleCallableStatement cstmt = null;
            String ret = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
                cstmt.setBFILE(1, bfile);
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 12);
                cstmt.execute();
                ret = cstmt.getString(2);
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPlsqlMaxInstrSize(OracleConnection conn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean isCharSetMultibyte = conn.isCharSetMultibyte(conn.getDriverCharSet());
            int maxCharbyteSize = conn.getMaxCharbyteSize();
            int ret = 32512;
            if (isCharSetMultibyte) {
                ret = 32512 / (conn.getC2SNlsRatio() * maxCharbyteSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long read(OracleConnection conn, Datum lob, int type, long pos, long length, byte[] bytes_read) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int totalSizeRead;
            block44: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(bytes_read));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleCallableStatement cstmt = null;
                totalSizeRead = 0;
                try {
                    cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.read (:1, :2, :3, :4); end;");
                    int readThisTime = 0;
                    int chunkSize = 0;
                    if (LobPlsqlUtil.isNCLOB(lob)) {
                        cstmt.setFormOfUse(1, (short)2);
                        cstmt.setFormOfUse(4, (short)2);
                    }
                    cstmt.setObject(1, (Object)lob, type);
                    cstmt.registerOutParameter(2, 2);
                    cstmt.registerOutParameter(4, -3);
                    while ((long)totalSizeRead < length) {
                        chunkSize = Math.min((int)length, 32512);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug: read chunks: chunkSize=" + chunkSize);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        cstmt.setInt(2, chunkSize);
                        cstmt.setInt(3, (int)pos + totalSizeRead);
                        cstmt.execute();
                        readThisTime = cstmt.getInt(2);
                        byte[] bytesThisTime = cstmt.getBytes(4);
                        System.arraycopy(bytesThisTime, 0, bytes_read, totalSizeRead, readThisTime);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug:  sizeRead=" + readThisTime);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        totalSizeRead += readThisTime;
                        length -= (long)readThisTime;
                    }
                }
                catch (SQLException e2) {
                    if (e2.getErrorCode() != 1403) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug: Exception caught and thrown." + e2.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw e2;
                    }
                    if (!TRACE || !OracleLog.recursiveEnter()) break block44;
                    try {
                        LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug: ORA-1403 No data found end of file");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                finally {
                    if (cstmt != null) {
                        cstmt.close();
                        cstmt = null;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + (long)totalSizeRead);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = totalSizeRead;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long length(OracleConnection conn, Datum lob, int type) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            long lob_length = 0L;
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := dbms_lob.getLength (:2); end;");
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(2, (short)2);
                }
                cstmt.setObject(2, (Object)lob, type);
                cstmt.registerOutParameter(1, 2);
                cstmt.execute();
                lob_length = cstmt.getLong(1);
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + lob_length);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = lob_length;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long hasPattern(OracleConnection conn, Datum lob, int type, byte[] pattern, long startPos) throws SQLException {
        long lobLen;
        long patternLen;
        block82: {
            long __ol_nanos__ = 0L;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pattern == null || startPos <= 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = 0L;
                return l2;
            }
            patternLen = pattern.length;
            lobLen = LobPlsqlUtil.length(conn, lob, type);
            if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l3 = 0L;
                return l3;
            }
            if (patternLen <= 32512L) {
                OracleCallableStatement cstmt = null;
                try {
                    cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                    cstmt.registerOutParameter(1, 2);
                    cstmt.setObject(2, (Object)lob, type);
                    cstmt.setBytes(3, pattern);
                    cstmt.setLong(4, startPos);
                    cstmt.execute();
                    long __result__ = cstmt.getLong(1);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l4 = __result__;
                    return l4;
                }
                finally {
                    cstmt.close();
                    cstmt = null;
                }
            }
            break block82;
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        block53: while (true) {
            long subMatchedPos;
            byte[] subPattern;
            int subPatternLen;
            if (!done) {
                if (patternLen > lobLen - subStartPos + 1L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l5 = 0L;
                    return l5;
                }
                matchedLen = 0;
                subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                subPattern = new byte[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                if (subMatchedPos == 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l6 = 0L;
                    return l6;
                }
                matchedPos = subMatchedPos;
                matchedLen += subPatternLen;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l7 = matchedPos;
                return l7;
            }
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (true) {
                if (!moreChunks) continue block53;
                subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                subPattern = new byte[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l8 = 0L;
                    return l8;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long isSubLob(OracleConnection conn, Datum lob, int type, Datum subLob, long startPos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (subLob == null || startPos <= 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = 0L;
                return l2;
            }
            long patternLen = LobPlsqlUtil.length(conn, subLob, type);
            long lobLen = LobPlsqlUtil.length(conn, lob, type);
            if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l3 = 0L;
                return l3;
            }
            if (patternLen <= 32512L) {
                byte[] pattern = new byte[(int)patternLen];
                LobPlsqlUtil.read(conn, subLob, type, 1L, patternLen, pattern);
                long __result__ = LobPlsqlUtil.hasPattern(conn, lob, type, pattern, startPos);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l4 = __result__;
                return l4;
            }
            int matchedLen = 0;
            long subStartPos = startPos;
            boolean done = false;
            long matchedPos = 0L;
            while (!done) {
                if (patternLen > lobLen - subStartPos + 1L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l5 = 0L;
                    return l5;
                }
                matchedLen = 0;
                int subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                byte[] subPattern = new byte[subPatternLen];
                LobPlsqlUtil.read(conn, subLob, type, matchedLen + 1, subPatternLen, subPattern);
                long subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                if (subMatchedPos == 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l6 = 0L;
                    return l6;
                }
                matchedPos = subMatchedPos;
                matchedLen += subPatternLen;
                subStartPos = subMatchedPos + (long)subPatternLen;
                boolean moreChunks = true;
                while (moreChunks) {
                    subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                    subPattern = new byte[subPatternLen];
                    LobPlsqlUtil.read(conn, subLob, type, matchedLen + 1, subPatternLen, subPattern);
                    subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                    if (subMatchedPos == subStartPos) {
                        subStartPos += (long)subPatternLen;
                        if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                        moreChunks = false;
                        done = true;
                        continue;
                    }
                    if (subMatchedPos == 0L) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        long l7 = 0L;
                        return l7;
                    }
                    subStartPos = subMatchedPos - (long)matchedLen;
                    moreChunks = false;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l8 = matchedPos;
            return l8;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNCLOB(Datum lob) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(lob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Class<?> cl = null;
            try {
                cl = Class.forName("oracle.sql.CLOB");
            }
            catch (ClassNotFoundException exp) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINEST, "         Debug: Could not find class oracle.sql.CLOB ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return bl;
            }
            if (!cl.isInstance(lob)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean exp = false;
                return exp;
            }
            CLOB clob = (CLOB)lob;
            boolean __result__ = clob.isNCLOB();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum createTemporaryLob(Connection conn, boolean cache, int duration, int type, short form_of_use) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(form_of_use));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Statement cstmt = null;
            Datum ret = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.createTemporary (:1," + (cache ? "TRUE" : "FALSE") + ", :2); end;");
                cstmt.registerOutParameter(1, type);
                cstmt.setFormOfUse(1, form_of_use);
                cstmt.setInt(2, duration);
                cstmt.execute();
                ret = cstmt.getOracleObject(1);
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum = ret;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTemporaryLob(Connection conn, Datum temp_lob, int type) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(temp_lob) + ", " + OracleLog.argument(type));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.freeTemporary (:1); end;");
                cstmt.registerOutParameter(1, type);
                if (LobPlsqlUtil.isNCLOB(temp_lob)) {
                    cstmt.setFormOfUse(1, (short)2);
                }
                cstmt.setOracleObject(1, temp_lob);
                cstmt.execute();
                Datum ret = cstmt.getOracleObject(1);
                byte[] locator = ret.shareBytes();
                temp_lob.setShareBytes(locator);
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.LobPlsqlUtil"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

