/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.datatables.domain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jtech.marble.datatables.domain.Column;
import com.jtech.marble.datatables.domain.Order;
import com.jtech.marble.datatables.domain.Search;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class DataTablesInput {
    @NotNull
    @Min(value=0L)
    private Integer draw = 1;
    @NotNull
    @Min(value=0L)
    private Integer start = 0;
    @NotNull
    @Min(value=-1L)
    private Integer length = 10;
    @NotNull
    private Search search = new Search();
    @NotEmpty
    private List<Order> order = Lists.newArrayList();
    @NotEmpty
    private List<Column> columns = Lists.newArrayList();

    public Map<String, Column> getColumnsAsMap() {
        HashMap map = Maps.newHashMap();
        for (Column column : this.columns) {
            map.put(column.getData(), column);
        }
        return map;
    }

    public Column getColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        for (Column column : this.columns) {
            if (!columnName.equals(column.getData())) continue;
            return column;
        }
        return null;
    }

    public void addColumn(String columnName, boolean searchable, boolean orderable, String searchValue) {
        this.columns.add(new Column(columnName, "", searchable, orderable, new Search(searchValue, false)));
    }

    public void addOrder(String columnName, boolean ascending) {
        if (columnName == null) {
            return;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!columnName.equals(this.columns.get(i).getData())) continue;
            this.order.add(new Order(i, ascending ? "asc" : "desc"));
        }
    }

    public Integer getDraw() {
        return this.draw;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLength() {
        return this.length;
    }

    public Search getSearch() {
        return this.search;
    }

    public List<Order> getOrder() {
        return this.order;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setDraw(Integer draw) {
        this.draw = draw;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setSearch(Search search) {
        this.search = search;
    }

    public void setOrder(List<Order> order) {
        this.order = order;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTablesInput)) {
            return false;
        }
        DataTablesInput other = (DataTablesInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$draw = this.getDraw();
        Integer other$draw = other.getDraw();
        if (this$draw == null ? other$draw != null : !((Object)this$draw).equals(other$draw)) {
            return false;
        }
        Integer this$start = this.getStart();
        Integer other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Search this$search = this.getSearch();
        Search other$search = other.getSearch();
        if (this$search == null ? other$search != null : !((Object)this$search).equals(other$search)) {
            return false;
        }
        List<Order> this$order = this.getOrder();
        List<Order> other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTablesInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $draw = this.getDraw();
        result = result * 59 + ($draw == null ? 43 : ((Object)$draw).hashCode());
        Integer $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Search $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
        List<Order> $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    public String toString() {
        return "DataTablesInput(draw=" + this.getDraw() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", search=" + this.getSearch() + ", order=" + this.getOrder() + ", columns=" + this.getColumns() + ")";
    }
}

