/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util;

import com.google.common.base.Throwables;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class PasswordUtil {
    private static final int SALT_SIZE = 8;
    private static final String HASH_ALGORITHM = "SHA-1";
    private static final int HASH_INTERATIONS = 1024;
    private static SecureRandom random = new SecureRandom();

    public static boolean checkPassword(String salt, String password, String plainPassword) {
        byte[] saltHex = PasswordUtil.decodeHex(salt);
        byte[] hashPassword = PasswordUtil.sha1(plainPassword.getBytes(), saltHex);
        return StringUtils.equals((CharSequence)PasswordUtil.encodeHex(hashPassword), (CharSequence)password);
    }

    private static byte[] decodeHex(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    public static String encodeHex(byte[] input) {
        return Hex.encodeHexString((byte[])input);
    }

    private static byte[] sha1(byte[] input, byte[] salt) {
        return PasswordUtil.digest(input, HASH_ALGORITHM, salt, 1024);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] generateSalt() {
        byte[] bytes = new byte[8];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String generatePassword(byte[] salt, String clearPassword) {
        byte[] hashPassword = PasswordUtil.sha1(clearPassword.getBytes(), salt);
        return PasswordUtil.encodeHex(hashPassword);
    }
}

